/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.JsonAssert;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.AbstractHttpCache;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.preload.PipelineExecutor;
import org.apache.shindig.gadgets.render.ProxyRenderer;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.PipelinedData;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class ProxyRendererTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final String PROXIED_HTML_CONTENT = "Hello, Universe!";
    private static final Uri PROXIED_HTML_HREF = Uri.parse((String)"http://example.org/proxied.php");
    private static final Uri EXPECTED_PROXIED_HTML_HREF = Uri.parse((String)"http://example.org/proxied.php?lang=all&country=ALL");
    private static final GadgetContext CONTEXT = new GadgetContext(){

        public SecurityToken getToken() {
            return new AnonymousSecurityToken();
        }
    };
    private final FakeHttpCache cache = new FakeHttpCache();
    private final FakeRequestPipeline pipeline = new FakeRequestPipeline();
    private final FakePipelineExecutor pipelineExecutor = new FakePipelineExecutor();
    private final ProxyRenderer proxyRenderer = new ProxyRenderer((RequestPipeline)this.pipeline, (HttpCache)this.cache, (PipelineExecutor)this.pipelineExecutor);

    private Gadget makeGadget(String content) throws GadgetException {
        GadgetSpec spec = new GadgetSpec(SPEC_URL, "<Module><ModulePrefs title=''/><Content><![CDATA[" + content + "]]></Content></Module>");
        return new Gadget().setSpec(spec).setContext(CONTEXT).setCurrentView(spec.getView("default"));
    }

    private Gadget makeHrefGadget(String authz) throws Exception {
        Gadget gadget = this.makeGadget("");
        String doc = "<Content href='" + PROXIED_HTML_HREF + "' authz='" + authz + "'/>";
        View view = new View("proxied", Arrays.asList(XmlUtil.parse((String)doc)), SPEC_URL);
        gadget.setCurrentView(view);
        return gadget;
    }

    @Test
    public void renderProxied() throws Exception {
        HttpRequest request = new HttpRequest(EXPECTED_PROXIED_HTML_HREF);
        HttpResponse response = new HttpResponse(PROXIED_HTML_CONTENT);
        this.pipeline.plainResponses.put(EXPECTED_PROXIED_HTML_HREF, response);
        String content = this.proxyRenderer.render(this.makeHrefGadget("none"));
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
        Assert.assertEquals((Object)response, (Object)this.cache.getResponse(request));
    }

    @Test
    public void renderProxiedRelative() throws Exception {
        Uri base = EXPECTED_PROXIED_HTML_HREF;
        final Uri relative = Uri.parse((String)"/some/path?foo=bar");
        Uri resolved = new UriBuilder(base.resolve(relative)).addQueryParameter("lang", GadgetSpec.DEFAULT_LOCALE.getLanguage()).addQueryParameter("country", GadgetSpec.DEFAULT_LOCALE.getCountry()).toUri();
        HttpRequest request = new HttpRequest(resolved);
        HttpResponse response = new HttpResponse(PROXIED_HTML_CONTENT);
        this.pipeline.plainResponses.put(resolved, response);
        Gadget gadget = this.makeHrefGadget("none");
        gadget.setContext(new GadgetContext(gadget.getContext()){

            public String getParameter(String name) {
                return name.equals("path") ? relative.toString() : null;
            }
        });
        String content = this.proxyRenderer.render(gadget);
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
        Assert.assertEquals((Object)response, (Object)this.cache.getResponse(request));
    }

    @Test
    public void renderProxiedRelativeBadPath() throws Exception {
        HttpRequest request = new HttpRequest(EXPECTED_PROXIED_HTML_HREF);
        HttpResponse response = new HttpResponse(PROXIED_HTML_CONTENT);
        this.pipeline.plainResponses.put(EXPECTED_PROXIED_HTML_HREF, response);
        Gadget gadget = this.makeHrefGadget("none");
        gadget.setContext(new GadgetContext(gadget.getContext()){

            public String getParameter(String name) {
                return name.equals("path") ? "$(^)$" : null;
            }
        });
        String content = this.proxyRenderer.render(gadget);
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
        Assert.assertEquals((Object)response, (Object)this.cache.getResponse(request));
    }

    @Test
    public void renderProxiedFromCache() throws Exception {
        HttpRequest request = new HttpRequest(EXPECTED_PROXIED_HTML_HREF);
        HttpResponse response = new HttpResponse(PROXIED_HTML_CONTENT);
        this.cache.addResponse(request, response);
        String content = this.proxyRenderer.render(this.makeHrefGadget("none"));
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
    }

    @Test
    public void renderProxiedSigned() throws Exception {
        this.pipeline.signedResponses.put(EXPECTED_PROXIED_HTML_HREF, new HttpResponse(PROXIED_HTML_CONTENT));
        String content = this.proxyRenderer.render(this.makeHrefGadget("signed"));
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
    }

    @Test
    public void renderProxiedOAuth() throws Exception {
        this.pipeline.oauthResponses.put(EXPECTED_PROXIED_HTML_HREF, new HttpResponse(PROXIED_HTML_CONTENT));
        String content = this.proxyRenderer.render(this.makeHrefGadget("oauth"));
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
    }

    @Test
    public void renderProxiedCustomLocale() throws Exception {
        UriBuilder uri = new UriBuilder(PROXIED_HTML_HREF);
        uri.putQueryParameter("lang", new String[]{"foo"});
        uri.putQueryParameter("country", new String[]{"BAR"});
        Gadget gadget = this.makeHrefGadget("none");
        gadget.setContext(new GadgetContext(){

            public Locale getLocale() {
                return new Locale("foo", "BAR");
            }

            public SecurityToken getToken() {
                return new AnonymousSecurityToken();
            }
        });
        this.pipeline.plainResponses.put(uri.toUri(), new HttpResponse(PROXIED_HTML_CONTENT));
        String content = this.proxyRenderer.render(gadget);
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
    }

    @Test
    public void renderProxiedWithPreload() throws Exception {
        ImmutableList prefetchedJson = ImmutableList.of((Object)new JSONObject("{id: 'foo', data: 'bar'}"));
        this.pipelineExecutor.results = new PipelineExecutor.Results(null, (Collection)prefetchedJson, null);
        this.pipeline.plainResponses.put(EXPECTED_PROXIED_HTML_HREF, new HttpResponse(PROXIED_HTML_CONTENT));
        String content = this.proxyRenderer.render(this.makeHrefGadget("none"));
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
        HttpRequest lastHttpRequest = this.pipeline.getLastHttpRequest();
        Assert.assertEquals((Object)"POST", (Object)lastHttpRequest.getMethod());
        Assert.assertEquals((Object)"application/json;charset=utf-8", (Object)lastHttpRequest.getHeader("Content-Type"));
        String postBody = lastHttpRequest.getPostBodyAsString();
        JsonAssert.assertJsonEquals((String)JsonSerializer.serialize((Collection)prefetchedJson), (String)postBody);
        Assert.assertTrue((boolean)this.pipelineExecutor.wasPreloaded);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakePipelineExecutor
    extends PipelineExecutor {
        protected boolean wasPreloaded;
        protected PipelineExecutor.Results results;

        public FakePipelineExecutor() {
            super(null, null, null);
        }

        public PipelineExecutor.Results execute(GadgetContext context, Collection<PipelinedData> pipelines) {
            this.wasPreloaded = true;
            return this.results;
        }
    }

    private static class FakeRequestPipeline
    implements RequestPipeline {
        protected final Map<Uri, HttpResponse> plainResponses = Maps.newHashMap();
        protected final Map<Uri, HttpResponse> signedResponses = Maps.newHashMap();
        protected final Map<Uri, HttpResponse> oauthResponses = Maps.newHashMap();
        private HttpRequest lastHttpRequest;

        protected FakeRequestPipeline() {
        }

        public HttpResponse execute(HttpRequest request) throws GadgetException {
            HttpResponse response;
            this.lastHttpRequest = request;
            if (request.getGadget() == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "No gadget associated with rendering request.");
            }
            if (request.getContainer() == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "No container associated with rendering request.");
            }
            if (request.getSecurityToken() == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "No security token associated with rendering request.");
            }
            if (request.getOAuthArguments() == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "No oauth arguments associated with rendering request.");
            }
            Assert.assertTrue((boolean)request.getOAuthArguments().isProxiedContentRequest());
            switch (request.getAuthType()) {
                case NONE: {
                    response = this.plainResponses.get(request.getUri());
                    break;
                }
                case SIGNED: {
                    response = this.signedResponses.get(request.getUri());
                    break;
                }
                case OAUTH: {
                    response = this.oauthResponses.get(request.getUri());
                    break;
                }
                default: {
                    response = null;
                }
            }
            if (response == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unknown file: " + request.getUri());
            }
            return response;
        }

        public HttpRequest getLastHttpRequest() {
            return this.lastHttpRequest;
        }

        public void normalizeProtocol(HttpRequest request) throws GadgetException {
        }
    }

    private static class FakeHttpCache
    extends AbstractHttpCache {
        private final Map<String, HttpResponse> map = Maps.newHashMap();

        protected FakeHttpCache() {
        }

        protected void addResponseImpl(String key, HttpResponse response) {
            this.map.put(key, response);
        }

        protected HttpResponse getResponseImpl(String key) {
            return this.map.get(key);
        }

        protected HttpResponse removeResponseImpl(String key) {
            return this.map.remove(key);
        }
    }
}

