/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletResponse;
import junitx.framework.StringAssert;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.servlet.MakeRequestHandler;
import org.apache.shindig.gadgets.servlet.MakeRequestServlet;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.easymock.EasyMock;
import org.json.JSONException;
import org.json.JSONObject;

public class MakeRequestServletTest
extends ServletTestFixture {
    private static final Uri REQUEST_URL = Uri.parse((String)"http://example.org/file");
    private static final String RESPONSE_BODY = "Hello, world!";
    private static final String ERROR_MESSAGE = "Broken!";
    private static final Enumeration<String> EMPTY_ENUM = Collections.enumeration(Collections.emptyList());
    private final MakeRequestServlet servlet = new MakeRequestServlet();
    private final MakeRequestHandler handler = new MakeRequestHandler(this.pipeline, null);
    private final HttpRequest internalRequest = new HttpRequest(REQUEST_URL);
    private final HttpResponse internalResponse = new HttpResponse("Hello, world!");

    public void setUp() throws Exception {
        super.setUp();
        this.servlet.setMakeRequestHandler(this.handler);
        EasyMock.expect((Object)this.request.getHeaderNames()).andReturn(EMPTY_ENUM).anyTimes();
        EasyMock.expect((Object)this.request.getParameter("httpMethod")).andReturn((Object)"GET").anyTimes();
        EasyMock.expect((Object)this.request.getParameter("url")).andReturn((Object)REQUEST_URL.toString()).anyTimes();
    }

    private void setupGet() {
        EasyMock.expect((Object)this.request.getMethod()).andReturn((Object)"GET").anyTimes();
    }

    private void setupPost() {
        EasyMock.expect((Object)this.request.getMethod()).andReturn((Object)"POST").anyTimes();
    }

    private void assertResponseOk(int expectedStatus, String expectedBody) throws JSONException {
        if (this.recorder.getHttpStatusCode() == 200) {
            String body = this.recorder.getResponseAsString();
            StringAssert.assertStartsWith((String)"throw 1; < don't be evil' >", (String)body);
            body = body.substring("throw 1; < don't be evil' >".length());
            JSONObject object = new JSONObject(body);
            object = object.getJSONObject(REQUEST_URL.toString());
            MakeRequestServletTest.assertEquals((int)expectedStatus, (int)object.getInt("rc"));
            MakeRequestServletTest.assertEquals((String)expectedBody, (String)object.getString("body"));
        } else {
            MakeRequestServletTest.fail((String)"Invalid response for request.");
        }
    }

    public void testDoGetNormal() throws Exception {
        this.setupGet();
        EasyMock.expect((Object)this.pipeline.execute(this.internalRequest)).andReturn((Object)this.internalResponse);
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.assertResponseOk(200, RESPONSE_BODY);
    }

    public void testDoGetHttpError() throws Exception {
        this.setupGet();
        EasyMock.expect((Object)this.pipeline.execute(this.internalRequest)).andReturn((Object)HttpResponse.notFound());
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.assertResponseOk(404, "");
    }

    public void testDoGetException() throws Exception {
        this.setupGet();
        EasyMock.expect((Object)this.pipeline.execute(this.internalRequest)).andThrow((Throwable)new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, ERROR_MESSAGE));
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        MakeRequestServletTest.assertEquals((int)400, (int)this.recorder.getHttpStatusCode());
        StringAssert.assertContains((String)ERROR_MESSAGE, (String)this.recorder.getResponseAsString());
    }

    public void testDoPostNormal() throws Exception {
        this.setupPost();
        EasyMock.expect((Object)this.pipeline.execute(this.internalRequest)).andReturn((Object)this.internalResponse);
        this.replay();
        this.servlet.doPost(this.request, (HttpServletResponse)this.recorder);
        this.assertResponseOk(200, RESPONSE_BODY);
    }

    public void testDoPostHttpError() throws Exception {
        this.setupPost();
        EasyMock.expect((Object)this.pipeline.execute(this.internalRequest)).andReturn((Object)HttpResponse.notFound());
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.assertResponseOk(404, "");
    }

    public void testDoPostException() throws Exception {
        this.setupPost();
        EasyMock.expect((Object)this.pipeline.execute(this.internalRequest)).andThrow((Throwable)new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, ERROR_MESSAGE));
        this.replay();
        this.servlet.doPost(this.request, (HttpServletResponse)this.recorder);
        MakeRequestServletTest.assertEquals((int)400, (int)this.recorder.getHttpStatusCode());
        StringAssert.assertContains((String)ERROR_MESSAGE, (String)this.recorder.getResponseAsString());
    }
}

