/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.HttpServletResponseRecorder;
import org.apache.shindig.common.servlet.HttpUtilTest;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.servlet.ProxyBase;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.easymock.EasyMock;

public class ProxyBaseTest
extends ServletTestFixture {
    private final ProxyBase proxy = new ProxyBase(){

        protected void doFetch(HttpServletRequest request, HttpServletResponse response) {
        }
    };

    public void testValidateUrlNoPath() throws Exception {
        Uri url = this.proxy.validateUrl("http://www.example.com");
        ProxyBaseTest.assertEquals((String)"http", (String)url.getScheme());
        ProxyBaseTest.assertEquals((String)"www.example.com", (String)url.getAuthority());
        ProxyBaseTest.assertEquals((String)"/", (String)url.getPath());
        ProxyBaseTest.assertNull((Object)url.getQuery());
        ProxyBaseTest.assertNull((Object)url.getFragment());
    }

    public void testValidateUrlHttps() throws Exception {
        Uri url = this.proxy.validateUrl("https://www.example.com");
        ProxyBaseTest.assertEquals((String)"https", (String)url.getScheme());
        ProxyBaseTest.assertEquals((String)"www.example.com", (String)url.getAuthority());
        ProxyBaseTest.assertEquals((String)"/", (String)url.getPath());
        ProxyBaseTest.assertNull((Object)url.getQuery());
        ProxyBaseTest.assertNull((Object)url.getFragment());
    }

    public void testValidateUrlWithPath() throws Exception {
        Uri url = this.proxy.validateUrl("http://www.example.com/foo");
        ProxyBaseTest.assertEquals((String)"http", (String)url.getScheme());
        ProxyBaseTest.assertEquals((String)"www.example.com", (String)url.getAuthority());
        ProxyBaseTest.assertEquals((String)"/foo", (String)url.getPath());
        ProxyBaseTest.assertNull((Object)url.getQuery());
        ProxyBaseTest.assertNull((Object)url.getFragment());
    }

    public void testValidateUrlWithPort() throws Exception {
        Uri url = this.proxy.validateUrl("http://www.example.com:8080/foo");
        ProxyBaseTest.assertEquals((String)"http", (String)url.getScheme());
        ProxyBaseTest.assertEquals((String)"www.example.com:8080", (String)url.getAuthority());
        ProxyBaseTest.assertEquals((String)"/foo", (String)url.getPath());
        ProxyBaseTest.assertNull((Object)url.getQuery());
        ProxyBaseTest.assertNull((Object)url.getFragment());
    }

    public void testValidateUrlWithEncodedPath() throws Exception {
        Uri url = this.proxy.validateUrl("http://www.example.com/foo%20bar");
        ProxyBaseTest.assertEquals((String)"http", (String)url.getScheme());
        ProxyBaseTest.assertEquals((String)"www.example.com", (String)url.getAuthority());
        ProxyBaseTest.assertEquals((String)"/foo%20bar", (String)url.getPath());
        ProxyBaseTest.assertNull((Object)url.getQuery());
        ProxyBaseTest.assertNull((Object)url.getFragment());
    }

    public void testValidateUrlWithEncodedQuery() throws Exception {
        Uri url = this.proxy.validateUrl("http://www.example.com/foo?q=with%20space");
        ProxyBaseTest.assertEquals((String)"http", (String)url.getScheme());
        ProxyBaseTest.assertEquals((String)"www.example.com", (String)url.getAuthority());
        ProxyBaseTest.assertEquals((String)"/foo", (String)url.getPath());
        ProxyBaseTest.assertEquals((String)"q=with%20space", (String)url.getQuery());
        ProxyBaseTest.assertEquals((String)"with space", (String)url.getQueryParameter("q"));
        ProxyBaseTest.assertNull((Object)url.getFragment());
    }

    public void testValidateUrlWithNoPathAndEncodedQuery() throws Exception {
        Uri url = this.proxy.validateUrl("http://www.example.com?q=with%20space");
        ProxyBaseTest.assertEquals((String)"http", (String)url.getScheme());
        ProxyBaseTest.assertEquals((String)"www.example.com", (String)url.getAuthority());
        ProxyBaseTest.assertEquals((String)"/", (String)url.getPath());
        ProxyBaseTest.assertEquals((String)"q=with%20space", (String)url.getQuery());
        ProxyBaseTest.assertNull((Object)url.getFragment());
    }

    public void testValidateUrlNullInput() {
        try {
            this.proxy.validateUrl(null);
            ProxyBaseTest.fail((String)"Should have thrown");
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    public void testValidateUrlBadInput() {
        try {
            this.proxy.validateUrl("%$#%#$%#$%");
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    public void testValidateUrlBadProtocol() {
        try {
            this.proxy.validateUrl("gopher://foo");
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    public void testSetResponseHeaders() throws Exception {
        HttpResponse results = new HttpResponseBuilder().create();
        this.replay();
        this.proxy.setResponseHeaders(this.request, (HttpServletResponse)this.recorder, results);
        ProxyBaseTest.assertNotNull((String)"Expires header not set", (Object)this.recorder.getHeader("Expires"));
        ProxyBaseTest.assertNotNull((String)"Cache-Control header not set", (Object)this.recorder.getHeader("Cache-Control"));
        ProxyBaseTest.assertEquals((String)"attachment;filename=p.txt", (String)this.recorder.getHeader("Content-Disposition"));
    }

    public void testSetResponseHeadersForFlash() throws Exception {
        HttpResponse results = new HttpResponseBuilder().setHeader("Content-Type", "application/x-shockwave-flash").create();
        this.replay();
        this.proxy.setResponseHeaders(this.request, (HttpServletResponse)this.recorder, results);
        ProxyBaseTest.assertNotNull((String)"Expires header not set", (Object)this.recorder.getHeader("Expires"));
        ProxyBaseTest.assertNotNull((String)"Cache-Control header not set", (Object)this.recorder.getHeader("Cache-Control"));
        ProxyBaseTest.assertNull((String)"Content-Disposition header set for flash", (Object)this.recorder.getHeader("Content-Disposition"));
    }

    public void testSetResponseHeadersNoCache() throws Exception {
        TreeMap headers = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        headers.put("Pragma", Arrays.asList("no-cache"));
        HttpResponse results = new HttpResponseBuilder().addHeader("Pragma", "no-cache").create();
        this.replay();
        this.proxy.setResponseHeaders(this.request, (HttpServletResponse)this.recorder, results);
        ProxyBaseTest.assertNotNull((String)"Expires header not set", (Object)this.recorder.getHeader("Expires"));
        ProxyBaseTest.assertEquals((String)"no-cache", (String)this.recorder.getHeader("Pragma"));
        ProxyBaseTest.assertEquals((String)"no-cache", (String)this.recorder.getHeader("Cache-Control"));
        ProxyBaseTest.assertEquals((String)"attachment;filename=p.txt", (String)this.recorder.getHeader("Content-Disposition"));
    }

    public void testSetResponseHeadersForceParam() throws Exception {
        HttpResponse results = new HttpResponseBuilder().create();
        EasyMock.expect((Object)this.request.getParameter("refresh")).andReturn((Object)"30").anyTimes();
        this.replay();
        this.proxy.setResponseHeaders(this.request, (HttpServletResponse)this.recorder, results);
        HttpUtilTest.checkCacheControlHeaders((long)HttpUtilTest.testStartTime, (HttpServletResponseRecorder)this.recorder, (int)30, (boolean)false);
        ProxyBaseTest.assertEquals((String)"attachment;filename=p.txt", (String)this.recorder.getHeader("Content-Disposition"));
    }

    public void testSetResponseHeadersForceParamInvalid() throws Exception {
        HttpResponse results = new HttpResponseBuilder().create();
        EasyMock.expect((Object)this.request.getParameter("refresh")).andReturn((Object)"foo").anyTimes();
        this.replay();
        try {
            this.proxy.setResponseHeaders(this.request, (HttpServletResponse)this.recorder, results);
        }
        catch (GadgetException e) {
            ProxyBaseTest.assertEquals((Object)GadgetException.Code.INVALID_PARAMETER, (Object)e.getCode());
        }
    }

    public void testGetParameter() {
        EasyMock.expect((Object)this.request.getParameter("foo")).andReturn((Object)"bar");
        this.replay();
        ProxyBaseTest.assertEquals((String)"bar", (String)this.proxy.getParameter(this.request, "foo", "not foo"));
    }

    public void testGetParameterWithNullValue() {
        EasyMock.expect((Object)this.request.getParameter("foo")).andReturn(null);
        this.replay();
        ProxyBaseTest.assertEquals((String)"not foo", (String)this.proxy.getParameter(this.request, "foo", "not foo"));
    }

    public void testGetContainerWithContainer() {
        EasyMock.expect((Object)this.request.getParameter("container")).andReturn((Object)"bar");
        this.replay();
        ProxyBaseTest.assertEquals((String)"bar", (String)this.proxy.getContainer(this.request));
    }

    public void testGetContainerWithSynd() {
        EasyMock.expect((Object)this.request.getParameter("container")).andReturn(null);
        EasyMock.expect((Object)this.request.getParameter("synd")).andReturn((Object)"syndtainer");
        this.replay();
        ProxyBaseTest.assertEquals((String)"syndtainer", (String)this.proxy.getContainer(this.request));
    }

    public void testGetContainerNoParam() {
        EasyMock.expect((Object)this.request.getParameter("container")).andReturn(null);
        EasyMock.expect((Object)this.request.getParameter("synd")).andReturn(null);
        this.replay();
        ProxyBaseTest.assertEquals((String)"default", (String)this.proxy.getContainer(this.request));
    }
}

