/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.servlet.ProxyHandler;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.easymock.Capture;
import org.easymock.EasyMock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHandlerTest
extends ServletTestFixture {
    private static final String URL_ONE = "http://www.example.org/test.html";
    private static final String DATA_ONE = "hello world";
    private final ProxyHandler proxyHandler;

    public ProxyHandlerTest() {
        this.proxyHandler = new ProxyHandler(this.pipeline, this.lockedDomainService, this.rewriterRegistry);
    }

    private void expectGetAndReturnData(String url, byte[] data) throws Exception {
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        HttpResponse resp = new HttpResponseBuilder().setResponse(data).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
    }

    private void expectGetAndReturnHeaders(String url, Map<String, List<String>> headers) throws Exception {
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        HttpResponse resp = new HttpResponseBuilder().addAllHeaders(headers).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
    }

    private void setupProxyRequestMock(String host, String url) throws Exception {
        EasyMock.expect((Object)this.request.getHeader("Host")).andReturn((Object)host);
        EasyMock.expect((Object)this.request.getParameter("url")).andReturn((Object)url).atLeastOnce();
    }

    private void setupFailedProxyRequestMock(String host, String url) throws Exception {
        EasyMock.expect((Object)this.request.getHeader("Host")).andReturn((Object)host);
    }

    public void testIfModifiedSinceAlwaysReturnsEarly() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("If-Modified-Since")).andReturn((Object)"Yes, this is an invalid header.");
        this.replay();
        this.proxyHandler.fetch(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        ProxyHandlerTest.assertEquals((int)304, (int)this.recorder.getHttpStatusCode());
        ProxyHandlerTest.assertFalse((boolean)this.rewriter.responseWasRewritten());
    }

    public void testLockedDomainEmbed() throws Exception {
        this.setupProxyRequestMock("www.example.com", URL_ONE);
        EasyMock.expect((Object)this.lockedDomainService.isSafeForOpenProxy("www.example.com")).andReturn((Object)true);
        this.expectGetAndReturnData(URL_ONE, DATA_ONE.getBytes());
        this.replay();
        this.proxyHandler.fetch(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        ProxyHandlerTest.assertEquals((String)DATA_ONE, (String)this.recorder.getResponseAsString());
        ProxyHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testHttpRequestFillsParentAndContainer() throws Exception {
        this.setupProxyRequestMock("www.example.com", URL_ONE);
        EasyMock.expect((Object)this.lockedDomainService.isSafeForOpenProxy("www.example.com")).andReturn((Object)true);
        HttpResponse resp = new HttpResponseBuilder().setResponse(DATA_ONE.getBytes()).create();
        Capture httpRequest = new Capture();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.capture((Capture)httpRequest))).andReturn((Object)resp);
        this.replay();
        this.proxyHandler.fetch(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        ProxyHandlerTest.assertEquals((String)"default", (String)((HttpRequest)httpRequest.getValue()).getContainer());
        ProxyHandlerTest.assertEquals((Object)Uri.parse((String)URL_ONE), (Object)((HttpRequest)httpRequest.getValue()).getUri());
        ProxyHandlerTest.assertEquals((String)DATA_ONE, (String)this.recorder.getResponseAsString());
        ProxyHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testLockedDomainFailedEmbed() throws Exception {
        this.setupFailedProxyRequestMock("www.example.com", URL_ONE);
        EasyMock.expect((Object)this.lockedDomainService.isSafeForOpenProxy("www.example.com")).andReturn((Object)false);
        this.replay();
        try {
            this.proxyHandler.doFetch(this.request, this.response);
            ProxyHandlerTest.fail((String)"Should have thrown");
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    public void testHeadersPreserved() throws Exception {
        String url = "http://example.org/file.evil";
        String domain = "example.org";
        String contentType = "text/evil; charset=utf-8";
        String magicGarbage = "fadfdfdfd";
        HashMap headers = Maps.newHashMap();
        headers.put("Content-Type", Arrays.asList(contentType));
        headers.put("X-Magic-Garbage", Arrays.asList(magicGarbage));
        EasyMock.expect((Object)this.lockedDomainService.isSafeForOpenProxy(domain)).andReturn((Object)true).atLeastOnce();
        this.setupProxyRequestMock(domain, url);
        this.expectGetAndReturnHeaders(url, headers);
        this.replay();
        this.proxyHandler.fetch(this.request, (HttpServletResponse)this.recorder);
        ProxyHandlerTest.assertEquals((String)contentType, (String)this.recorder.getHeader("Content-Type"));
        ProxyHandlerTest.assertEquals((String)magicGarbage, (String)this.recorder.getHeader("X-Magic-Garbage"));
        ProxyHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testNoCache() throws Exception {
        String url = "http://example.org/file.evil";
        String domain = "example.org";
        EasyMock.expect((Object)this.lockedDomainService.isSafeForOpenProxy(domain)).andReturn((Object)true).atLeastOnce();
        this.setupProxyRequestMock(domain, url);
        EasyMock.expect((Object)this.request.getParameter("nocache")).andReturn((Object)"1").atLeastOnce();
        HttpRequest req = new HttpRequest(Uri.parse((String)url)).setIgnoreCache(true);
        HttpResponse resp = new HttpResponse("Hello");
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
        this.replay();
        this.proxyHandler.fetch(this.request, (HttpServletResponse)this.recorder);
        this.verify();
    }

    private void expectMime(String expectedMime, String contentMime, String outputMime) throws Exception {
        String url = "http://example.org/file.img?rewriteMime=" + expectedMime;
        String domain = "example.org";
        EasyMock.expect((Object)this.lockedDomainService.isSafeForOpenProxy(domain)).andReturn((Object)true).atLeastOnce();
        this.setupProxyRequestMock(domain, url);
        EasyMock.expect((Object)this.request.getParameter("rewriteMime")).andReturn((Object)expectedMime).anyTimes();
        HttpRequest req = new HttpRequest(Uri.parse((String)url)).setRewriteMimeType(expectedMime);
        HttpResponse resp = new HttpResponseBuilder().setResponseString("Hello").addHeader("Content-Type", contentMime).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
        this.replay();
        this.proxyHandler.fetch(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        ProxyHandlerTest.assertEquals((String)this.recorder.getContentType(), (String)outputMime);
        this.reset();
    }

    public void testMimeMatchPass() throws Exception {
        this.expectMime("text/css", "text/css", "text/css");
    }

    public void testMimeMatchPassWithAdditionalAttributes() throws Exception {
        this.expectMime("text/css", "text/css; charset=UTF-8", "text/css");
    }

    public void testMimeMatchOverrideNonMatch() throws Exception {
        this.expectMime("text/css", "image/png; charset=UTF-8", "text/css");
    }

    public void testMimeMatchVarySupport() throws Exception {
        this.expectMime("image/*", "image/gif", "image/gif");
    }
}

