/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import junit.framework.TestCase;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.SpecParserException;

public class FeatureTest
extends TestCase {
    public void testRequire() throws Exception {
        String xml = "<Require feature=\"foo\"/>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        FeatureTest.assertEquals((String)"foo", (String)feature.getName());
        FeatureTest.assertTrue((boolean)feature.getRequired());
    }

    public void testOptional() throws Exception {
        String xml = "<Optional feature=\"foo\"/>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        FeatureTest.assertEquals((String)"foo", (String)feature.getName());
        FeatureTest.assertFalse((boolean)feature.getRequired());
    }

    public void testParams() throws Exception {
        String key = "bar";
        String value = "Hello, World!";
        String xml = "<Require feature=\"foo\">  <Param name=\"" + key + "\">" + value + "</Param>" + "</Require>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        Multimap params = feature.getParams();
        FeatureTest.assertEquals((int)1, (int)params.size());
        FeatureTest.assertEquals((Object)ImmutableList.of((Object)value), (Object)params.get((Object)key));
    }

    public void testMultiParams() throws Exception {
        String key = "bar";
        String key2 = "bar2";
        String value = "Hello, World!";
        String value2 = "Goodbye, World!";
        String xml = "<Require feature=\"foo\">  <Param name=\"" + key + "\">" + value + "</Param>" + "  <Param name=\"" + key + "\">" + value2 + "</Param>" + "  <Param name=\"" + key2 + "\">" + value2 + "</Param>" + "  <Param name=\"" + key2 + "\">" + value + "</Param>" + "</Require>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        Multimap params = feature.getParams();
        FeatureTest.assertEquals((int)2, (int)params.keySet().size());
        FeatureTest.assertEquals((Object)ImmutableList.of((Object)value, (Object)value2), (Object)params.get((Object)key));
        FeatureTest.assertEquals((String)value, (String)feature.getParam(key));
        FeatureTest.assertEquals((Object)ImmutableList.of((Object)value2, (Object)value), (Object)params.get((Object)key2));
        FeatureTest.assertEquals((String)value2, (String)feature.getParam(key2));
        FeatureTest.assertEquals((Object)ImmutableList.of(), (Object)params.get((Object)"foobar"));
        FeatureTest.assertNull((Object)feature.getParam("foobar"));
    }

    public void testDoesNotLikeUnnamedFeatures() throws Exception {
        String xml = "<Require/>";
        try {
            new Feature(XmlUtil.parse((String)xml));
            FeatureTest.fail((String)"No exception thrown when an unnamed feature is passed.");
        }
        catch (SpecParserException specParserException) {
            // empty catch block
        }
    }

    public void testEnforceParamNames() throws Exception {
        String xml = "<Require feature=\"foo\"><Param>Test</Param></Require>";
        try {
            new Feature(XmlUtil.parse((String)xml));
            FeatureTest.fail((String)"No exception thrown when an unnamed parameter is passed.");
        }
        catch (SpecParserException specParserException) {
            // empty catch block
        }
    }
}

