/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.el.ELResolver;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.SocialMarkupHtmlParser;
import org.apache.shindig.gadgets.rewrite.XPathWrapper;
import org.apache.shindig.gadgets.templates.FlashTagHandler;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateContext;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlashTagHandlerTest
extends EasyMockTestCase {
    private MyTemplateProcessor processor;
    private DOMImplementation documentProvider;
    private FlashTagHandler handler;
    private GadgetFeatureRegistry featureRegistry;
    private GadgetContext gadgetContext = (GadgetContext)this.mock(GadgetContext.class);
    private Gadget gadget = (Gadget)this.mock(Gadget.class);
    private SocialMarkupHtmlParser parser;
    protected Document result;

    @Before
    public void setUp() throws Exception {
        this.processor = new MyTemplateProcessor();
        this.processor.context = new TemplateContext(this.gadget, Collections.emptyMap());
        Injector injector = Guice.createInjector((Module[])new Module[]{new ParseModule(), new PropertiesModule()});
        this.documentProvider = (DOMImplementation)injector.getInstance(DOMImplementation.class);
        this.parser = (SocialMarkupHtmlParser)injector.getInstance(SocialMarkupHtmlParser.class);
        this.featureRegistry = (GadgetFeatureRegistry)this.mock(GadgetFeatureRegistry.class);
        this.handler = new FlashTagHandler(new BeanJsonConverter(injector), this.featureRegistry, "http://example.org/ns");
        this.result = this.parser.parseDom("");
        EasyMock.expect((Object)this.gadget.getContext()).andReturn((Object)this.gadgetContext).anyTimes();
    }

    private void expectFeatureLookup() throws GadgetException {
        EasyMock.expect((Object)this.featureRegistry.getFeatures((Collection)EasyMock.anyObject())).andReturn((Object)ImmutableSet.of((Object)new GadgetFeature("swfobject", (List)ImmutableList.of((Object)JsLibrary.create((JsLibrary.Type)JsLibrary.Type.INLINE, (String)"swfobject()", (String)"swfobject", null)), Collections.emptySet())));
        EasyMock.expect((Object)this.gadgetContext.getContainer()).andReturn((Object)"default");
    }

    private void expectSecurityToken() {
        EasyMock.expect((Object)this.gadgetContext.getParameter((String)EasyMock.eq((Object)"st"))).andReturn((Object)"12345");
    }

    public void testBasicRender() throws Exception {
        Document document = this.parser.parseDom("<script type='text/os-template'><osx:Flash swf='http://www.example.org/test.swf'>Click Me</osx:Flash></script>");
        Element tag = (Element)DomUtil.getElementsByTagNameCaseInsensitive((Document)document, (Set)ImmutableSet.of((Object)"osx:flash")).get(0);
        this.expectSecurityToken();
        EasyMock.expect((Object)this.gadget.sanitizeOutput()).andReturn((Object)false);
        this.expectFeatureLookup();
        this.replay();
        this.handler.process(this.result.getDocumentElement().getFirstChild().getNextSibling(), tag, (TemplateProcessor)this.processor);
        XPathWrapper wrapper = new XPathWrapper(this.result);
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/head/script[1]"), (String)"swfobject()");
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/body/div/@id"), (String)"os_xFlash_alt_1");
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/body/div"), (String)"Click Me");
        FlashTagHandlerTest.assertNull((Object)wrapper.getNode("/html/body/div/@onclick"));
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/body/script[1]"), (String)"swfobject.embedSWF(\"http://www.example.org/test.swf\",\"os_xFlash_alt_1\",\"100px\",\"100px\",\"9.0.115\",null,null,{\"flashvars\":\"st=12345\"},{});");
        this.verify();
    }

    public void testSanitizedRender() throws Exception {
        Document document = this.parser.parseDom("<script type='text/os-template'><osx:Flash swf='http://www.example.org/test.swf'>Click Me</osx:Flash></script>");
        Element tag = (Element)DomUtil.getElementsByTagNameCaseInsensitive((Document)document, (Set)ImmutableSet.of((Object)"osx:flash")).get(0);
        this.expectSecurityToken();
        EasyMock.expect((Object)this.gadget.sanitizeOutput()).andReturn((Object)true);
        this.expectFeatureLookup();
        this.replay();
        this.handler.process(this.result.getDocumentElement().getFirstChild().getNextSibling(), tag, (TemplateProcessor)this.processor);
        XPathWrapper wrapper = new XPathWrapper(this.result);
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/head/script[1]"), (String)"swfobject()");
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/body/div/@id"), (String)"os_xFlash_alt_1");
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/body/div"), (String)"Click Me");
        FlashTagHandlerTest.assertNull((Object)wrapper.getNode("/html/body/div/@onclick"));
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/body/script[1]"), (String)"swfobject.embedSWF(\"http://www.example.org/test.swf\",\"os_xFlash_alt_1\",\"100px\",\"100px\",\"9.0.115\",null,null,{\"swliveconnect\":false,\"flashvars\":\"st=12345\",\"allowscriptaccess\":\"never\",\"allownetworking\":\"internal\"},{});");
        this.verify();
    }

    public void testSanitizedRenderClickToPlay() throws Exception {
        Document document = this.parser.parseDom("<script type='text/os-template'><osx:flash swf='http://www.example.org/test.swf' play='onclick'>Click Me</osx:flash></script>");
        Element tag = (Element)DomUtil.getElementsByTagNameCaseInsensitive((Document)document, (Set)ImmutableSet.of((Object)"osx:flash")).get(0);
        this.expectSecurityToken();
        EasyMock.expect((Object)this.gadget.sanitizeOutput()).andReturn((Object)true);
        this.expectFeatureLookup();
        this.replay();
        this.handler.process(this.result.getDocumentElement().getFirstChild().getNextSibling(), tag, (TemplateProcessor)this.processor);
        XPathWrapper wrapper = new XPathWrapper(this.result);
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/head/script[1]"), (String)"swfobject()");
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/body/div/@id"), (String)"os_xFlash_alt_1");
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/body/div"), (String)"Click Me");
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/body/div/@onclick"), (String)"os_xFlash_alt_1()");
        FlashTagHandlerTest.assertEquals((String)wrapper.getValue("/html/body/script[1]"), (String)"function os_xFlash_alt_1(){ swfobject.embedSWF(\"http://www.example.org/test.swf\",\"os_xFlash_alt_1\",\"100px\",\"100px\",\"9.0.115\",null,null,{\"swliveconnect\":false,\"flashvars\":\"st=12345\",\"allowscriptaccess\":\"never\",\"allownetworking\":\"internal\"},{}); }");
        this.verify();
    }

    @Test
    public void testConfigCreation() throws Exception {
        Document doc = this.documentProvider.createDocument(null, null, null);
        Element tag = doc.createElement("test");
        tag.setAttribute("id", "myflash");
        tag.setAttribute("class", "stylish");
        tag.setAttribute("swf", "http://www.example.org/x.swf");
        tag.setAttribute("width", "100px");
        tag.setAttribute("height", "200px");
        tag.setAttribute("name", "myflashname");
        tag.setAttribute("play", "onclick");
        tag.setAttribute("menu", "true");
        tag.setAttribute("scale", "exactfit");
        tag.setAttribute("wmode", "transparent");
        tag.setAttribute("devicefont", "true");
        tag.setAttribute("swliveconnect", "true");
        tag.setAttribute("allowscriptaccess", "samedomain");
        tag.setAttribute("quality", "autohigh");
        tag.setAttribute("salign", "tl");
        tag.setAttribute("bgcolor", "#77ff77");
        tag.setAttribute("allowfullscreen", "true");
        tag.setAttribute("allownetworking", "none");
        tag.setAttribute("flashvars", "a=b&c=d");
        FlashTagHandler.SwfObjectConfig config = this.handler.getSwfConfig(tag, (TemplateProcessor)this.processor);
        FlashTagHandlerTest.assertEquals((String)config.id, (String)"myflash");
        FlashTagHandlerTest.assertEquals((String)config.clazz, (String)"stylish");
        FlashTagHandlerTest.assertEquals((Object)config.swf, (Object)Uri.parse((String)"http://www.example.org/x.swf"));
        FlashTagHandlerTest.assertEquals((String)config.width, (String)"100px");
        FlashTagHandlerTest.assertEquals((String)config.height, (String)"200px");
        FlashTagHandlerTest.assertEquals((String)config.name, (String)"myflashname");
        FlashTagHandlerTest.assertEquals((Object)config.play, (Object)FlashTagHandler.SwfObjectConfig.Play.onclick);
        FlashTagHandlerTest.assertEquals((Object)config.menu, (Object)Boolean.TRUE);
        FlashTagHandlerTest.assertEquals((Object)config.scale, (Object)FlashTagHandler.SwfObjectConfig.Scale.exactfit);
        FlashTagHandlerTest.assertEquals((Object)config.wmode, (Object)FlashTagHandler.SwfObjectConfig.WMode.transparent);
        FlashTagHandlerTest.assertEquals((Object)config.devicefont, (Object)Boolean.TRUE);
        FlashTagHandlerTest.assertEquals((Object)config.swliveconnect, (Object)Boolean.TRUE);
        FlashTagHandlerTest.assertEquals((Object)config.allowscriptaccess, (Object)FlashTagHandler.SwfObjectConfig.ScriptAccess.samedomain);
        FlashTagHandlerTest.assertNull((Object)config.loop);
        FlashTagHandlerTest.assertEquals((Object)config.quality, (Object)FlashTagHandler.SwfObjectConfig.Quality.autohigh);
        FlashTagHandlerTest.assertEquals((Object)config.salign, (Object)FlashTagHandler.SwfObjectConfig.SAlign.tl);
        FlashTagHandlerTest.assertEquals((String)config.bgcolor, (String)"#77ff77");
        FlashTagHandlerTest.assertEquals((Object)config.allowfullscreen, (Object)Boolean.TRUE);
        FlashTagHandlerTest.assertEquals((Object)config.allownetworking, (Object)FlashTagHandler.SwfObjectConfig.NetworkAccess.none);
        FlashTagHandlerTest.assertEquals((String)config.flashvars, (String)"a=b&c=d");
    }

    @Test
    public void testConfigBindingFailure() throws Exception {
        Document document = this.parser.parseDom("<script type='text/os-template'><osx:flash swf='http://www.example.org/test.swf' play='junk'>Click Me</osx:flash></script>");
        Element tag = (Element)DomUtil.getElementsByTagNameCaseInsensitive((Document)document, (Set)ImmutableSet.of((Object)"osx:flash")).get(0);
        this.handler.process(this.result.getDocumentElement().getFirstChild().getNextSibling(), tag, (TemplateProcessor)this.processor);
        XPathWrapper wrapper = new XPathWrapper(this.result);
        FlashTagHandlerTest.assertTrue((boolean)wrapper.getValue("/html/body/span").startsWith("Failed to process os:Flash tag"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyTemplateProcessor
    implements TemplateProcessor {
        public TemplateContext context;

        private MyTemplateProcessor() {
        }

        public DocumentFragment processTemplate(Element template, TemplateContext templateContext, ELResolver globals, TagRegistry registry) {
            throw new UnsupportedOperationException();
        }

        public TemplateContext getTemplateContext() {
            return this.context;
        }

        public void processRepeat(Node result, Element element, Iterable<?> dataList, Runnable onEachLoop) {
            Iterator<?> iterator = dataList.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                onEachLoop.run();
            }
        }

        public <T> T evaluate(String expression, Class<T> type, T defaultValue) {
            return type.cast(expression);
        }

        public void processChildNodes(Node result, Node source) {
            NodeList childNodes = source.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(0).cloneNode(true);
                result.getOwnerDocument().adoptNode(child);
                result.appendChild(child);
            }
        }
    }
}

