/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableMap;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.templates.FakeTemplateProcessor;
import org.apache.shindig.gadgets.templates.IfTagHandler;
import org.apache.shindig.gadgets.templates.TagHandler;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.easymock.classextension.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IfTagHandlerTest {
    private FakeTemplateProcessor processor;
    private DOMImplementation documentProvider;
    private TagHandler handler;

    @Before
    public void setUp() throws Exception {
        this.processor = (FakeTemplateProcessor)EasyMock.createMock(FakeTemplateProcessor.class);
        this.documentProvider = new ParseModule.DOMImplementationProvider().get();
        this.handler = new IfTagHandler();
    }

    @Test
    public void conditionIsFalse() throws Exception {
        Document doc = this.documentProvider.createDocument(null, null, null);
        Element tag = doc.createElement("if");
        tag.setAttribute("condition", "fakeExpression");
        this.processor.expressionResults = ImmutableMap.of((Object)"fakeExpression", (Object)false);
        EasyMock.replay((Object[])new Object[]{this.processor});
        this.handler.process(null, tag, (TemplateProcessor)this.processor);
        EasyMock.verify((Object[])new Object[]{this.processor});
    }

    @Test
    public void conditionIsTrue() throws Exception {
        Document doc = this.documentProvider.createDocument(null, null, null);
        Element tag = doc.createElement("if");
        tag.setAttribute("condition", "fakeExpression");
        this.processor.expressionResults = ImmutableMap.of((Object)"fakeExpression", (Object)true);
        this.processor.processChildNodes((Node)org.easymock.EasyMock.isNull(), (Node)org.easymock.EasyMock.same((Object)tag));
        EasyMock.replay((Object[])new Object[]{this.processor});
        this.handler.process(null, tag, (TemplateProcessor)this.processor);
        EasyMock.verify((Object[])new Object[]{this.processor});
    }
}

