/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.apache.shindig.gadgets.variables.UserPrefSubstituter;

public class UserPrefSubstituterTest
extends TestCase {
    private final Substitutions substituter = new Substitutions();
    private static final String DEFAULT_NAME = "default";
    private static final String DEFAULT_VALUE = "default value";
    private static final String USER_NAME = "user";
    private static final String USER_VALUE = "user value";
    private static final String OVERRIDE_NAME = "override";
    private static final String OVERRIDE_VALUE = "override value";
    private static final String UNESCAPED_USER_VALUE = "<hello, & world > \"";
    private static final String ESCAPED_USER_VALUE = "&lt;hello, &amp; world &gt; &quot;";
    private static final String DEFAULT_XML = "<Module><ModulePrefs title=\"Hello, __UP_world__\"/><UserPref name=\"default\" datatype=\"string\" default_value=\"default value\"/><UserPref name=\"user\" datatype=\"string\"/><UserPref name=\"override\" datatype=\"string\"  default_value=\"FOOOOOOOOOOBAR!\"/><Content type=\"html\"/></Module>";
    private GadgetSpec spec;

    public void setUp() throws Exception {
        super.setUp();
        this.spec = new GadgetSpec(Uri.parse((String)"#"), DEFAULT_XML);
    }

    public void testSubstitutions() throws Exception {
        ImmutableMap map = ImmutableMap.of((Object)USER_NAME, (Object)USER_VALUE, (Object)OVERRIDE_NAME, (Object)OVERRIDE_VALUE);
        UserPrefs prefs = new UserPrefs((Map)map);
        UserPrefSubstituter.addSubstitutions((Substitutions)this.substituter, (GadgetSpec)this.spec, (UserPrefs)prefs);
        UserPrefSubstituterTest.assertEquals((String)DEFAULT_VALUE, (String)this.substituter.getSubstitution(Substitutions.Type.USER_PREF, DEFAULT_NAME));
        UserPrefSubstituterTest.assertEquals((String)USER_VALUE, (String)this.substituter.getSubstitution(Substitutions.Type.USER_PREF, USER_NAME));
        UserPrefSubstituterTest.assertEquals((String)OVERRIDE_VALUE, (String)this.substituter.getSubstitution(Substitutions.Type.USER_PREF, OVERRIDE_NAME));
    }

    public void testEscaping() throws Exception {
        ImmutableMap map = ImmutableMap.of((Object)USER_NAME, (Object)UNESCAPED_USER_VALUE);
        UserPrefs prefs = new UserPrefs((Map)map);
        UserPrefSubstituter.addSubstitutions((Substitutions)this.substituter, (GadgetSpec)this.spec, (UserPrefs)prefs);
        UserPrefSubstituterTest.assertEquals((String)ESCAPED_USER_VALUE, (String)this.substituter.getSubstitution(Substitutions.Type.USER_PREF, USER_NAME));
    }
}

