/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.HashLockedDomainService;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.easymock.EasyMock;

public class HashLockedDomainServiceTest
extends EasyMockTestCase {
    private HashLockedDomainService lockedDomainService;
    private Gadget wantsLocked = null;
    private Gadget notLocked = null;
    private final ContainerConfig requiredConfig = (ContainerConfig)this.mock(ContainerConfig.class);
    private final ContainerConfig enabledConfig = (ContainerConfig)this.mock(ContainerConfig.class);

    private Gadget makeGadget(boolean wantsLocked, String url) {
        String gadgetXml;
        List<Object> gadgetFeatures = new ArrayList();
        if (wantsLocked) {
            gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='locked-domain'/></ModulePrefs><Content/></Module>";
            gadgetFeatures = Arrays.asList(new GadgetFeature("locked-domain", new ArrayList(), null));
        } else {
            gadgetXml = "<Module><ModulePrefs title=''/><Content/></Module>";
        }
        GadgetSpec spec = null;
        try {
            spec = new GadgetSpec(Uri.parse((String)url), gadgetXml);
        }
        catch (GadgetException e) {
            return null;
        }
        GadgetFeatureRegistry registry = (GadgetFeatureRegistry)this.mock(GadgetFeatureRegistry.class);
        EasyMock.expect((Object)registry.getFeatures((Collection)EasyMock.isA(Collection.class))).andReturn(gadgetFeatures).anyTimes();
        return new Gadget().setSpec(spec).setGadgetFeatureRegistry(registry);
    }

    protected void setUp() throws Exception {
        super.setUp();
        EasyMock.expect((Object)this.requiredConfig.getString("default", "gadgets.lockedDomainSuffix")).andReturn((Object)"-a.example.com:8080").anyTimes();
        EasyMock.expect((Object)this.requiredConfig.getBool("default", "gadgets.lockedDomainRequired")).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.requiredConfig.getContainers()).andReturn(Arrays.asList("default")).anyTimes();
        EasyMock.expect((Object)this.enabledConfig.getString("default", "gadgets.lockedDomainSuffix")).andReturn((Object)"-a.example.com:8080").anyTimes();
        EasyMock.expect((Object)this.enabledConfig.getContainers()).andReturn(Arrays.asList("default")).anyTimes();
        this.wantsLocked = this.makeGadget(true, "http://somehost.com/somegadget.xml");
        this.notLocked = this.makeGadget(false, "not-locked");
    }

    public void testDisabledGlobally() {
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(this.requiredConfig, false);
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("anywhere.com"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("embed.com"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.notLocked, "default"));
        this.lockedDomainService = new HashLockedDomainService(this.enabledConfig, false);
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("anywhere.com"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("embed.com"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.notLocked, "default"));
    }

    public void testEnabledForGadget() {
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(this.enabledConfig, true);
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("images-a.example.com:8080"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("-a.example.com:8080"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("embed.com"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.wantsLocked, "default"));
        String target = this.lockedDomainService.getLockedDomainForGadget(this.wantsLocked, "default");
        HashLockedDomainServiceTest.assertEquals((String)"8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", (String)target);
    }

    public void testNotEnabledForGadget() {
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(this.enabledConfig, true);
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("images-a.example.com:8080"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("-a.example.com:8080"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("embed.com"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.notLocked, "default"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.notLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("auvn86n7q0l4ju2tq5cq8akotcjlda66-a.example.com:8080", this.notLocked, "default"));
        HashLockedDomainServiceTest.assertNull((Object)this.lockedDomainService.getLockedDomainForGadget(this.notLocked, "default"));
    }

    public void testRequiredForContainer() {
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(this.requiredConfig, true);
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("images-a.example.com:8080"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("-a.example.com:8080"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("embed.com"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.notLocked, "default"));
        String target = this.lockedDomainService.getLockedDomainForGadget(this.wantsLocked, "default");
        HashLockedDomainServiceTest.assertEquals((String)"8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", (String)target);
        target = this.lockedDomainService.getLockedDomainForGadget(this.notLocked, "default");
        HashLockedDomainServiceTest.assertEquals((String)"auvn86n7q0l4ju2tq5cq8akotcjlda66-a.example.com:8080", (String)target);
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("auvn86n7q0l4ju2tq5cq8akotcjlda66-a.example.com:8080", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("auvn86n7q0l4ju2tq5cq8akotcjlda66-a.example.com:8080", this.notLocked, "default"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.notLocked, "default"));
    }

    public void testMissingConfig() throws Exception {
        ContainerConfig containerMissingConfig = (ContainerConfig)this.mock(ContainerConfig.class);
        EasyMock.expect((Object)containerMissingConfig.getContainers()).andReturn(Arrays.asList("default"));
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(containerMissingConfig, true);
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.notLocked, "default"));
    }

    public void testMultiContainer() throws Exception {
        ContainerConfig inheritsConfig = (ContainerConfig)this.mock(ContainerConfig.class);
        EasyMock.expect((Object)inheritsConfig.getContainers()).andReturn(Arrays.asList("default", "other"));
        EasyMock.expect((Object)inheritsConfig.getBool((String)EasyMock.isA(String.class), (String)EasyMock.eq((Object)"gadgets.lockedDomainRequired"))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)inheritsConfig.getString((String)EasyMock.isA(String.class), (String)EasyMock.eq((Object)"gadgets.lockedDomainSuffix"))).andReturn((Object)"-a.example.com:8080").anyTimes();
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(inheritsConfig, true);
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.wantsLocked, "other"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.notLocked, "other"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.wantsLocked, "other"));
    }
}

