/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import junit.framework.TestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.http.CacheKeyBuilder;

public class CacheKeyBuilderTest
extends TestCase {
    private CacheKeyBuilder builder;

    public void setUp() {
        this.builder = new CacheKeyBuilder().setLegacyParam(0, (Object)Uri.parse((String)"http://example.com")).setLegacyParam(1, (Object)AuthType.SIGNED);
    }

    public void testBuilder() {
        CacheKeyBuilderTest.assertEquals((String)"http://example.com:signed:0:0:0:0:0:0:0", (String)this.builder.build());
    }

    public void testOwner() {
        this.builder.setLegacyParam(2, (Object)"owner");
        CacheKeyBuilderTest.assertEquals((String)"http://example.com:signed:owner:0:0:0:0:0:0", (String)this.builder.build());
    }

    public void testViewer() {
        this.builder.setLegacyParam(3, (Object)"viewer");
        CacheKeyBuilderTest.assertEquals((String)"http://example.com:signed:0:viewer:0:0:0:0:0", (String)this.builder.build());
    }

    public void testTokenOwner() {
        this.builder.setLegacyParam(4, (Object)"token");
        CacheKeyBuilderTest.assertEquals((String)"http://example.com:signed:0:0:token:0:0:0:0", (String)this.builder.build());
    }

    public void testAppUrl() {
        this.builder.setLegacyParam(5, (Object)"appurl");
        CacheKeyBuilderTest.assertEquals((String)"http://example.com:signed:0:0:0:appurl:0:0:0", (String)this.builder.build());
    }

    public void testInstanceId() {
        this.builder.setLegacyParam(6, (Object)"id");
        CacheKeyBuilderTest.assertEquals((String)"http://example.com:signed:0:0:0:0:id:0:0", (String)this.builder.build());
    }

    public void testServiceName() {
        this.builder.setLegacyParam(7, (Object)"srv");
        CacheKeyBuilderTest.assertEquals((String)"http://example.com:signed:0:0:0:0:0:srv:0", (String)this.builder.build());
    }

    public void testTokenName() {
        this.builder.setLegacyParam(8, (Object)"token");
        CacheKeyBuilderTest.assertEquals((String)"http://example.com:signed:0:0:0:0:0:0:token", (String)this.builder.build());
    }

    public void testParam() {
        this.builder.setParam("rh", (Object)1);
        CacheKeyBuilderTest.assertEquals((String)"http://example.com:signed:0:0:0:0:0:0:0:rh=1", (String)this.builder.build());
    }

    public void testResizeParams() {
        this.builder.setParam("rh", (Object)1);
        this.builder.setParam("rq", (Object)2);
        this.builder.setParam("rw", (Object)3);
        CacheKeyBuilderTest.assertEquals((String)"http://example.com:signed:0:0:0:0:0:0:0:rh=1:rq=2:rw=3", (String)this.builder.build());
    }
}

