/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.parser.css.CssTree;
import java.util.List;
import junit.framework.TestCase;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;
import org.apache.shindig.gadgets.parse.caja.CajaCssUtils;

public class CajaCssParserTest
extends TestCase {
    private CajaCssParser cajaCssParser;

    protected void setUp() throws Exception {
        super.setUp();
        this.cajaCssParser = new CajaCssParser();
        this.cajaCssParser.setCacheProvider((CacheProvider)new LruCacheProvider(10));
    }

    public void testBasicCssParse() throws Exception {
        String css = ".xyz { font : bold; } A { color : #7f7f7f }";
        CssTree.StyleSheet styleSheet = this.cajaCssParser.parseDom(css);
        List selectorList = CajaCssUtils.descendants((CssTree)styleSheet, CssTree.SimpleSelector.class);
        CajaCssParserTest.assertEquals((int)2, (int)selectorList.size());
        CajaCssParserTest.assertSame(CssTree.SimpleSelector.class, ((CssTree.SimpleSelector)selectorList.get(0)).getClass());
    }

    public void testCajaParseColonInRValue() throws Exception {
        String original = " A {\n -moz-opacity: 0.80;\n filter: alpha(opacity=40);\n filter: progid:DXImageTransform.Microsoft.Alpha(opacity=80);\n}";
        CssTree.StyleSheet styleSheet = this.cajaCssParser.parseDom(original);
        List selectorList = CajaCssUtils.descendants((CssTree)styleSheet, CssTree.SimpleSelector.class);
        CajaCssParserTest.assertEquals((int)1, (int)selectorList.size());
        CajaCssParserTest.assertSame(CssTree.SimpleSelector.class, ((CssTree.SimpleSelector)selectorList.get(0)).getClass());
    }

    public void testCajaParseNoLValue() throws Exception {
        String original = "body, input, td {\n  Arial, sans-serif;\n}";
        this.cajaCssParser.parseDom(original);
        CssTree.StyleSheet styleSheet = this.cajaCssParser.parseDom(original);
        List selectorList = CajaCssUtils.descendants((CssTree)styleSheet, CssTree.SimpleSelector.class);
        CajaCssParserTest.assertEquals((int)3, (int)selectorList.size());
        CajaCssParserTest.assertSame(CssTree.SimpleSelector.class, ((CssTree.SimpleSelector)selectorList.get(0)).getClass());
    }

    public void testCajaParseNoScheme() throws Exception {
        String original = "span { background-image:url('//www.example.org/image.gif'); }";
        this.cajaCssParser.parseDom(original);
        CssTree.StyleSheet styleSheet = this.cajaCssParser.parseDom(original);
        List selectorList = CajaCssUtils.descendants((CssTree)styleSheet, CssTree.SimpleSelector.class);
        CajaCssParserTest.assertEquals((int)1, (int)selectorList.size());
        CajaCssParserTest.assertSame(CssTree.SimpleSelector.class, ((CssTree.SimpleSelector)selectorList.get(0)).getClass());
    }

    public void testCajaParseCommentInContent() throws Exception {
        String original = "body { font : bold; } \n//A comment\n A { font : bold; }";
        this.cajaCssParser.parseDom(original);
        CssTree.StyleSheet styleSheet = this.cajaCssParser.parseDom(original);
        List selectorList = CajaCssUtils.descendants((CssTree)styleSheet, CssTree.SimpleSelector.class);
        CajaCssParserTest.assertEquals((int)2, (int)selectorList.size());
        CajaCssParserTest.assertSame(CssTree.SimpleSelector.class, ((CssTree.SimpleSelector)selectorList.get(0)).getClass());
    }

    public void testCajaParseDotInIdent() throws Exception {
        String original = "li{list-style:none;.padding-bottom:4px;}";
        this.cajaCssParser.parseDom(original);
        CssTree.StyleSheet styleSheet = this.cajaCssParser.parseDom(original);
        List selectorList = CajaCssUtils.descendants((CssTree)styleSheet, CssTree.SimpleSelector.class);
        CajaCssParserTest.assertEquals((int)1, (int)selectorList.size());
        CajaCssParserTest.assertSame(CssTree.SimpleSelector.class, ((CssTree.SimpleSelector)selectorList.get(0)).getClass());
    }

    public void testCajaParseDotInFunction() throws Exception {
        String original = ".iepngfix {behavior: expression(IEPNGFIX.fix(this)); }";
        this.cajaCssParser.parseDom(original);
        CssTree.StyleSheet styleSheet = this.cajaCssParser.parseDom(original);
        List selectorList = CajaCssUtils.descendants((CssTree)styleSheet, CssTree.SimpleSelector.class);
        CajaCssParserTest.assertEquals((int)1, (int)selectorList.size());
        CajaCssParserTest.assertSame(CssTree.SimpleSelector.class, ((CssTree.SimpleSelector)selectorList.get(0)).getClass());
    }
}

