/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.shindig.common.testing.TestExecutorService;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.preload.ConcurrentPreloaderService;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.Preloader;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentPreloaderServiceTest {
    private static final String PRELOAD_STRING_KEY = "key a";
    private static final String PRELOAD_NUMERIC_KEY = "key b";
    private static final String PRELOAD_MAP_KEY = "key c";
    private static final String PRELOAD_STRING_VALUE = "Some random string";
    private static final Integer PRELOAD_NUMERIC_VALUE = 5;
    private static final Map<String, String> PRELOAD_MAP_VALUE = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"blah");
    private final TestPreloader preloader = new TestPreloader();

    @Test
    public void preloadSingleService() throws Exception {
        this.preloader.tasks.add(new TestPreloadCallable(new DataPreload(PRELOAD_STRING_KEY, PRELOAD_STRING_VALUE)));
        ConcurrentPreloaderService service = new ConcurrentPreloaderService((ExecutorService)new TestExecutorService(), (Preloader)this.preloader);
        Collection preloads = service.preload((Gadget)null);
        Collection<Object> preloaded = this.getAll(preloads);
        Assert.assertEquals((Object)ImmutableMap.of((Object)PRELOAD_STRING_KEY, (Object)PRELOAD_STRING_VALUE), (Object)preloaded.iterator().next());
    }

    private Collection<Object> getAll(Collection<PreloadedData> preloads) throws PreloadException {
        ArrayList list = Lists.newArrayList();
        for (PreloadedData preloadCallable : preloads) {
            list.addAll(preloadCallable.toJson());
        }
        return list;
    }

    @Test
    public void preloadMultipleServices() throws PreloadException {
        this.preloader.tasks.add(new TestPreloadCallable(new DataPreload(PRELOAD_STRING_KEY, PRELOAD_STRING_VALUE)));
        this.preloader.tasks.add(new TestPreloadCallable(new DataPreload(PRELOAD_NUMERIC_KEY, PRELOAD_NUMERIC_VALUE)));
        this.preloader.tasks.add(new TestPreloadCallable(new DataPreload(PRELOAD_MAP_KEY, PRELOAD_MAP_VALUE)));
        ConcurrentPreloaderService service = new ConcurrentPreloaderService((ExecutorService)new TestExecutorService(), (Preloader)this.preloader);
        Collection preloads = service.preload((Gadget)null);
        Collection<Object> preloaded = this.getAll(preloads);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)PRELOAD_STRING_KEY, (Object)PRELOAD_STRING_VALUE), (Object)ImmutableMap.of((Object)PRELOAD_NUMERIC_KEY, (Object)PRELOAD_NUMERIC_VALUE), (Object)ImmutableMap.of((Object)PRELOAD_MAP_KEY, PRELOAD_MAP_VALUE)), preloaded);
    }

    @Test
    public void multiplePreloadsFiresJustOneInCurrentThread() throws Exception {
        TestPreloadCallable first = new TestPreloadCallable(new DataPreload(PRELOAD_STRING_KEY, PRELOAD_STRING_VALUE));
        TestPreloadCallable second = new TestPreloadCallable(new DataPreload(PRELOAD_NUMERIC_KEY, PRELOAD_MAP_VALUE));
        TestPreloadCallable third = new TestPreloadCallable(new DataPreload(PRELOAD_MAP_KEY, PRELOAD_NUMERIC_VALUE));
        this.preloader.tasks.add(first);
        this.preloader.tasks.add(second);
        this.preloader.tasks.add(third);
        ConcurrentPreloaderService service = new ConcurrentPreloaderService(Executors.newFixedThreadPool(5), (Preloader)this.preloader);
        service.preload((Gadget)null);
        TestPreloadCallable ranInSameThread = null;
        for (TestPreloadCallable preloadCallable : Lists.newArrayList((Object[])new TestPreloadCallable[]{first, second, third})) {
            if (preloadCallable.executedThread != Thread.currentThread()) continue;
            if (ranInSameThread != null) {
                Assert.fail((String)"More than one request ran in the current thread.");
            }
            ranInSameThread = preloadCallable;
        }
        Assert.assertNotNull((String)"No preloads executed in the current thread. ", ranInSameThread);
    }

    @Test
    public void singlePreloadExecutesInCurrentThread() throws Exception {
        TestPreloadCallable callable = new TestPreloadCallable(new DataPreload(PRELOAD_STRING_KEY, PRELOAD_STRING_VALUE));
        this.preloader.tasks.add(callable);
        ConcurrentPreloaderService service = new ConcurrentPreloaderService(Executors.newCachedThreadPool(), (Preloader)this.preloader);
        service.preload((Gadget)null);
        Assert.assertSame((String)"Single request not run in current thread", (Object)Thread.currentThread(), (Object)callable.executedThread);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataPreload
    implements PreloadedData {
        private final String key;
        private final Object data;

        public DataPreload(String key, Object data) {
            this.key = key;
            this.data = data;
        }

        public Collection<Object> toJson() {
            return ImmutableList.of((Object)ImmutableMap.of((Object)this.key, (Object)this.data));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestPreloadCallable
    implements Callable<PreloadedData> {
        private final PreloadedData preload;
        public Thread executedThread;

        public TestPreloadCallable(PreloadedData preload) {
            this.preload = preload;
        }

        @Override
        public PreloadedData call() throws Exception {
            this.executedThread = Thread.currentThread();
            if (this.preload == null) {
                throw new PreloadException("No preload for this test.");
            }
            return this.preload;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestPreloader
    implements Preloader {
        protected final Collection<Callable<PreloadedData>> tasks = Lists.newArrayList();

        protected TestPreloader() {
        }

        public Collection<Callable<PreloadedData>> createPreloadTasks(Gadget gadget) {
            return this.tasks;
        }
    }
}

