/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.shindig.common.JsonAssert;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.preload.HttpPreloader;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.PreloaderTestFixture;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPreloaderTest
extends PreloaderTestFixture {
    private static final String PRELOAD_HREF = "http://www.example.org/file";
    private static final String PRELOAD_HREF2 = "http://www.example.org/file-two";
    private static final String PRELOAD_CONTENT = "Preloaded data";
    protected static final Map<String, String> PRELOAD_METADATA = ImmutableMap.of((Object)"foo", (Object)"bar");
    protected final RecordingHttpFetcher plainFetcher = new RecordingHttpFetcher();
    protected final RecordingHttpFetcher oauthFetcher = new RecordingHttpFetcher();
    private final RequestPipeline requestPipeline = new RequestPipeline(){

        public HttpResponse execute(HttpRequest request) {
            if (request.getAuthType() == AuthType.NONE) {
                return HttpPreloaderTest.this.plainFetcher.fetch(request);
            }
            return HttpPreloaderTest.this.oauthFetcher.fetch(request);
        }

        public void normalizeProtocol(HttpRequest request) {
        }
    };

    private void checkRequest(HttpRequest request) {
        Assert.assertEquals((Object)this.context.getContainer(), (Object)request.getContainer());
        Assert.assertEquals((Object)GADGET_URL.toString(), (Object)request.getGadget().toString());
        Assert.assertEquals((Object)this.context.getToken().getAppId(), (Object)request.getSecurityToken().getAppId());
    }

    private static void checkResults(Object results, String url) throws Exception {
        HashMap expected = Maps.newHashMap();
        expected.put("body", PRELOAD_CONTENT);
        expected.put("rc", 200);
        expected.put("id", url);
        expected.put("headers", Collections.singletonMap("set-cookie", Arrays.asList("yo=momma")));
        expected.putAll(PRELOAD_METADATA);
        JsonAssert.assertObjectEquals((Object)expected, (Object)results);
    }

    private static void checkResults(Object results) throws Exception {
        HttpPreloaderTest.checkResults(results, PRELOAD_HREF);
    }

    @Test
    public void normalPreloads() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file'/></ModulePrefs><Content/></Module>";
        GadgetSpec spec = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.requestPipeline);
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("default"));
        Collection preloaded = preloader.createPreloadTasks(gadget);
        Assert.assertEquals((long)1L, (long)preloaded.size());
        PreloadedData data = (PreloadedData)((Callable)preloaded.iterator().next()).call();
        this.checkRequest(this.plainFetcher.requests.get(0));
        Assert.assertFalse((String)"request should not ignore cache", (boolean)this.plainFetcher.requests.get(0).getIgnoreCache());
        HttpPreloaderTest.checkResults(data.toJson().iterator().next());
    }

    @Test
    public void ignoreCachePreloads() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file' authz='signed' sign_viewer='false'/></ModulePrefs><Content/></Module>";
        GadgetSpec spec = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.requestPipeline);
        this.ignoreCache = true;
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("default"));
        Collection preloaded = preloader.createPreloadTasks(gadget);
        Assert.assertEquals((long)1L, (long)preloaded.size());
        ((Callable)preloaded.iterator().next()).call();
        HttpRequest request = this.oauthFetcher.requests.get(0);
        Assert.assertTrue((String)"request should ignore cache", (boolean)request.getIgnoreCache());
        this.checkRequest(request);
    }

    @Test
    public void signedPreloads() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file' authz='signed' sign_viewer='false'/></ModulePrefs><Content/></Module>";
        GadgetSpec spec = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.requestPipeline);
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("default"));
        Collection preloaded = preloader.createPreloadTasks(gadget);
        Assert.assertEquals((long)1L, (long)preloaded.size());
        PreloadedData data = (PreloadedData)((Callable)preloaded.iterator().next()).call();
        HttpRequest request = this.oauthFetcher.requests.get(0);
        this.checkRequest(request);
        Assert.assertTrue((boolean)request.getOAuthArguments().getSignOwner());
        Assert.assertFalse((boolean)request.getOAuthArguments().getSignViewer());
        HttpPreloaderTest.checkResults(data.toJson().iterator().next());
    }

    @Test
    public void oauthPreloads() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file' authz='oauth'/></ModulePrefs><Content/></Module>";
        GadgetSpec spec = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.requestPipeline);
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("default"));
        Collection preloaded = preloader.createPreloadTasks(gadget);
        Assert.assertEquals((long)1L, (long)preloaded.size());
        PreloadedData data = (PreloadedData)((Callable)preloaded.iterator().next()).call();
        HttpRequest request = this.oauthFetcher.requests.get(0);
        this.checkRequest(request);
        HttpPreloaderTest.checkResults(data.toJson().iterator().next());
    }

    @Test
    public void multiplePreloads() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file'/> <Preload href='http://www.example.org/file-two'/></ModulePrefs><Content/></Module>";
        GadgetSpec spec = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.requestPipeline);
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("default"));
        Collection preloaded = preloader.createPreloadTasks(gadget);
        Assert.assertEquals((long)2L, (long)preloaded.size());
        List<Object> list = this.getAll(preloaded);
        Assert.assertEquals((long)2L, (long)list.size());
        this.checkRequest(this.plainFetcher.requests.get(0));
        HttpPreloaderTest.checkResults(list.get(0));
        this.checkRequest(this.plainFetcher.requests.get(1));
        HttpPreloaderTest.checkResults(list.get(1), PRELOAD_HREF2);
    }

    private List<Object> getAll(Collection<Callable<PreloadedData>> preloaded) throws Exception {
        ArrayList list = Lists.newArrayList();
        for (Callable<PreloadedData> preloadCallable : preloaded) {
            list.addAll(preloadCallable.call().toJson());
        }
        return list;
    }

    @Test
    public void onlyPreloadForCorrectView() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file' views='foo,bar,baz'/> <Preload href='http://www.example.org/file-two' views='bar'/></ModulePrefs><Content/></Module>";
        GadgetSpec spec = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.requestPipeline);
        this.view = "foo";
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("default"));
        Collection preloaded = preloader.createPreloadTasks(gadget);
        List<Object> list = this.getAll(preloaded);
        Assert.assertEquals((long)1L, (long)list.size());
        this.checkRequest(this.plainFetcher.requests.get(0));
        HttpPreloaderTest.checkResults(list.get(0));
    }

    private static class RecordingHttpFetcher
    implements HttpFetcher {
        protected final List<HttpRequest> requests = Lists.newArrayList();

        protected RecordingHttpFetcher() {
        }

        public HttpResponse fetch(HttpRequest request) {
            this.requests.add(request);
            return new HttpResponseBuilder().setMetadata(PRELOAD_METADATA).setResponseString(HttpPreloaderTest.PRELOAD_CONTENT).addHeader("Set-Cookie", "yo=momma").create();
        }
    }
}

