/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.el.ELResolver;
import org.apache.shindig.common.JsonAssert;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.JsonUtil;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetELResolver;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.preload.PipelinedDataPreloader;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.PreloaderTestFixture;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.PipelinedData;
import org.easymock.EasyMock;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelinedDataPreloaderTest
extends PreloaderTestFixture {
    private ContainerConfig containerConfig;
    private final Expressions expressions = Expressions.forTesting();
    private static final String XML = "<Module xmlns:os=\"http://ns.opensocial.org/2008/markup\"><ModulePrefs title=\"Title\"/><Content href=\"http://example.org/proxied.php\" view=\"profile\">  <os:PeopleRequest key=\"p\" userIds=\"you\"/>  <os:PersonAppDataRequest key=\"a\" userId=\"she\"/></Content></Module>";
    private static final String HTTP_REQUEST_URL = "http://example.org/preload.html";
    private static final String PARAMS = "a=b&c=d";
    private static final String XML_PARAMS = "a=b&amp;c=d";
    private static final String XML_WITH_HTTP_REQUEST = "<Module xmlns:os=\"http://ns.opensocial.org/2008/markup\"><ModulePrefs title=\"Title\"/><Content href=\"http://example.org/proxied.php\" view=\"profile\">  <os:HttpRequest key=\"p\" href=\"http://example.org/preload.html\" refreshInterval=\"60\" method=\"POST\"/></Content></Module>";
    private static final String XML_WITH_HTTP_REQUEST_FOR_TEXT = "<Module xmlns:os=\"http://ns.opensocial.org/2008/markup\"><ModulePrefs title=\"Title\"/><Content href=\"http://example.org/proxied.php\" view=\"profile\">  <os:HttpRequest key=\"p\" format=\"text\" href=\"http://example.org/preload.html\" refreshInterval=\"60\" method=\"POST\"/></Content></Module>";
    private static final String XML_WITH_HTTP_REQUEST_AND_PARAMS = "<Module xmlns:os=\"http://ns.opensocial.org/2008/markup\"><ModulePrefs title=\"Title\"/><Content href=\"http://example.org/proxied.php\" view=\"profile\">  <os:HttpRequest key=\"p\" href=\"http://example.org/preload.html\"                   method=\"POST\" params=\"a=b&amp;c=d\"/></Content></Module>";
    private static final String XML_WITH_HTTP_REQUEST_AND_GET_PARAMS = "<Module xmlns:os=\"http://ns.opensocial.org/2008/markup\"><ModulePrefs title=\"Title\"/><Content href=\"http://example.org/proxied.php\" view=\"profile\">  <os:HttpRequest key=\"p\" href=\"http://example.org/preload.html\"                   method=\"GET\" params=\"a=b&amp;c=d\"/></Content></Module>";
    private static final String XML_IN_DEFAULT_CONTAINER = "<Module xmlns:os=\"http://ns.opensocial.org/2008/markup\"><ModulePrefs title=\"Title\"/><Content href=\"http://example.org/proxied.php\">  <os:PeopleRequest key=\"p\" userIds=\"you\"/>  <os:PersonAppDataRequest key=\"a\" userId=\"she\"/></Content></Module>";

    @Before
    public void createContainerConfig() {
        this.containerConfig = (ContainerConfig)EasyMock.createMock(ContainerConfig.class);
        EasyMock.expect((Object)this.containerConfig.getString("some-container", "gadgets.osDataUri")).andStubReturn((Object)"http://%host%/social/rpc");
        EasyMock.replay((Object[])new Object[]{this.containerConfig});
    }

    @Test
    public void testSocialPreload() throws Exception {
        GadgetSpec spec = new GadgetSpec(GADGET_URL, XML);
        String socialResult = "[{id:'p', data:1}, {id:'a', data:2}]";
        RecordingRequestPipeline pipeline = new RecordingRequestPipeline(socialResult);
        PipelinedDataPreloader preloader = new PipelinedDataPreloader((RequestPipeline)pipeline, this.containerConfig);
        this.view = "profile";
        this.contextParams.put("st", "token");
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("profile"));
        PipelinedData.Batch batch = this.getBatch(gadget);
        Collection tasks = preloader.createPreloadTasks(this.context, batch);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((long)0L, (long)pipeline.requests.size());
        Collection result = ((PreloadedData)((Callable)tasks.iterator().next()).call()).toJson();
        Assert.assertEquals((long)2L, (long)result.size());
        JSONObject resultWithKeyP = new JSONObject("{id: 'p', data: 1}");
        JSONObject resultWithKeyA = new JSONObject("{id: 'a', data: 2}");
        Map<String, String> resultsById = this.getResultsById(result);
        JsonAssert.assertJsonEquals((String)resultWithKeyA.toString(), (String)resultsById.get("a"));
        JsonAssert.assertJsonEquals((String)resultWithKeyP.toString(), (String)resultsById.get("p"));
        Assert.assertEquals((long)1L, (long)pipeline.requests.size());
        HttpRequest request = pipeline.requests.get(0);
        Assert.assertEquals((Object)("http://" + this.context.getHost() + "/social/rpc?st=token"), (Object)request.getUri().toString());
        Assert.assertEquals((Object)"POST", (Object)request.getMethod());
        Assert.assertTrue((boolean)request.getContentType().startsWith("application/json"));
    }

    @Test
    public void testSocialPreloadWithBatchError() throws Exception {
        GadgetSpec spec = new GadgetSpec(GADGET_URL, XML);
        String socialResult = "{code: 401, message: 'unauthorized'}";
        RecordingRequestPipeline pipeline = new RecordingRequestPipeline(socialResult);
        PipelinedDataPreloader preloader = new PipelinedDataPreloader((RequestPipeline)pipeline, this.containerConfig);
        this.view = "profile";
        this.contextParams.put("st", "token");
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("profile"));
        PipelinedData.Batch batch = this.getBatch(gadget);
        Collection tasks = preloader.createPreloadTasks(this.context, batch);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((long)0L, (long)pipeline.requests.size());
        Collection result = ((PreloadedData)((Callable)tasks.iterator().next()).call()).toJson();
        Assert.assertEquals((long)2L, (long)result.size());
        JSONObject resultWithKeyP = new JSONObject("{id: 'p', error: {code: 401, message: 'unauthorized'}}");
        JSONObject resultWithKeyA = new JSONObject("{id: 'a', error: {code: 401, message: 'unauthorized'}}");
        Map<String, String> resultsById = this.getResultsById(result);
        JsonAssert.assertJsonEquals((String)resultWithKeyA.toString(), (String)resultsById.get("a"));
        JsonAssert.assertJsonEquals((String)resultWithKeyP.toString(), (String)resultsById.get("p"));
    }

    @Test
    public void testSocialPreloadWithHttpError() throws Exception {
        GadgetSpec spec = new GadgetSpec(GADGET_URL, XML);
        HttpResponse httpError = new HttpResponseBuilder().setHttpStatusCode(500).create();
        RecordingRequestPipeline pipeline = new RecordingRequestPipeline(httpError);
        PipelinedDataPreloader preloader = new PipelinedDataPreloader((RequestPipeline)pipeline, this.containerConfig);
        this.view = "profile";
        this.contextParams.put("st", "token");
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("profile"));
        PipelinedData.Batch batch = this.getBatch(gadget);
        Collection tasks = preloader.createPreloadTasks(this.context, batch);
        Collection result = ((PreloadedData)((Callable)tasks.iterator().next()).call()).toJson();
        Assert.assertEquals((long)2L, (long)result.size());
        JSONObject resultWithKeyP = new JSONObject("{id: 'p', error: {code: 500}}");
        JSONObject resultWithKeyA = new JSONObject("{id: 'a', error: {code: 500}}");
        Map<String, String> resultsById = this.getResultsById(result);
        JsonAssert.assertJsonEquals((String)resultWithKeyA.toString(), (String)resultsById.get("a"));
        JsonAssert.assertJsonEquals((String)resultWithKeyP.toString(), (String)resultsById.get("p"));
    }

    @Test
    public void testSocialPreloadWithoutToken() throws Exception {
        GadgetSpec spec = new GadgetSpec(GADGET_URL, XML);
        RecordingRequestPipeline pipeline = new RecordingRequestPipeline("");
        PipelinedDataPreloader preloader = new PipelinedDataPreloader((RequestPipeline)pipeline, this.containerConfig);
        this.view = "profile";
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("profile"));
        PipelinedData.Batch batch = this.getBatch(gadget);
        Collection tasks = preloader.createPreloadTasks(this.context, batch);
        PreloadedData data = (PreloadedData)((Callable)tasks.iterator().next()).call();
        JSONObject resultWithKeyA = new JSONObject("{error:{code:403,data:{content:\"Security token missing\"}},id:\"a\"}");
        JSONObject resultWithKeyP = new JSONObject("{error:{code:403,data:{content:\"Security token missing\"}},id:\"p\"}");
        Collection result = data.toJson();
        Assert.assertEquals((long)2L, (long)result.size());
        Map<String, String> resultsById = this.getResultsById(result);
        JsonAssert.assertJsonEquals((String)resultWithKeyA.toString(), (String)resultsById.get("a"));
        JsonAssert.assertJsonEquals((String)resultWithKeyP.toString(), (String)resultsById.get("p"));
    }

    private Map<String, String> getResultsById(Collection<Object> result) {
        HashMap resultsById = Maps.newHashMap();
        for (Object o : result) {
            resultsById.put((String)JsonUtil.getProperty((Object)o, (String)"id"), JsonSerializer.serialize((Object)o));
        }
        return resultsById;
    }

    private PipelinedData.Batch getBatch(Gadget gadget) {
        return gadget.getCurrentView().getPipelinedData().getBatch(this.expressions, (ELResolver)new GadgetELResolver(gadget.getContext()));
    }

    @Test
    public void testHttpPreloadOfJsonObject() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setResponseString("{foo: 'bar'}").create();
        String expectedResult = "{data: {status: 200, content: {foo: 'bar'}}, id: 'p'}";
        this.verifyHttpPreload(response, expectedResult);
    }

    @Test
    public void testHttpPreloadOfJsonArrayWithHeaders() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setResponseString("[1, 2]").addHeader("content-type", "application/json").addHeader("set-cookie", "cookiecookie").addHeader("not-ok", "shouldn'tbehere").create();
        String expectedResult = "{data: {status: 200, headers:{'content-type': ['application/json; charset=UTF-8'], 'set-cookie': ['cookiecookie']},content: [1, 2]}, id: 'p'}";
        this.verifyHttpPreload(response, expectedResult);
    }

    @Test
    public void testHttpPreloadOfJsonWithErrorCode() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setResponseString("not found").addHeader("content-type", "text/html").setHttpStatusCode(404).create();
        String expectedResult = "{error: {code: 404, data:{headers: {'content-type': ['text/html; charset=UTF-8']},content: 'not found'}}, id: 'p'}";
        this.verifyHttpPreload(response, expectedResult);
    }

    @Test
    public void testHttpPreloadWithBadJson() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setResponseString("notjson").addHeader("content-type", "text/html").create();
        JSONObject result = new JSONObject(this.executeHttpPreload(response, XML_WITH_HTTP_REQUEST));
        Assert.assertFalse((boolean)result.has("data"));
        JSONObject error = result.getJSONObject("error");
        Assert.assertEquals((long)406L, (long)error.getInt("code"));
    }

    @Test
    public void testHttpPreloadOfText() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setResponseString("{foo: 'bar'}").addHeader("content-type", "application/json").create();
        String expectedResult = "{data: {status: 200, headers:{'content-type': ['application/json; charset=UTF-8']},content: '{foo: \\'bar\\'}'}, id: 'p'}";
        String resultString = this.executeHttpPreload(response, XML_WITH_HTTP_REQUEST_FOR_TEXT);
        JsonAssert.assertJsonEquals((String)expectedResult, (String)resultString);
    }

    private void verifyHttpPreload(HttpResponse response, String expectedJson) throws Exception {
        String resultString = this.executeHttpPreload(response, XML_WITH_HTTP_REQUEST);
        JsonAssert.assertJsonEquals((String)expectedJson, (String)resultString);
    }

    private String executeHttpPreload(HttpResponse response, String xml) throws Exception {
        GadgetSpec spec = new GadgetSpec(GADGET_URL, xml);
        RecordingRequestPipeline pipeline = new RecordingRequestPipeline(response);
        PipelinedDataPreloader preloader = new PipelinedDataPreloader((RequestPipeline)pipeline, this.containerConfig);
        this.view = "profile";
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("profile"));
        PipelinedData.Batch batch = this.getBatch(gadget);
        Collection tasks = preloader.createPreloadTasks(this.context, batch);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((long)0L, (long)pipeline.requests.size());
        Collection result = ((PreloadedData)((Callable)tasks.iterator().next()).call()).toJson();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)pipeline.requests.size());
        HttpRequest request = pipeline.requests.get(0);
        Assert.assertEquals((Object)HTTP_REQUEST_URL, (Object)request.getUri().toString());
        Assert.assertEquals((Object)"POST", (Object)request.getMethod());
        Assert.assertEquals((long)60L, (long)request.getCacheTtl());
        return result.iterator().next().toString();
    }

    @Test
    public void testHttpPreloadWithPostParams() throws Exception {
        GadgetSpec spec = new GadgetSpec(GADGET_URL, XML_WITH_HTTP_REQUEST_AND_PARAMS);
        String httpResult = "{foo: 'bar'}";
        RecordingRequestPipeline pipeline = new RecordingRequestPipeline(httpResult);
        PipelinedDataPreloader preloader = new PipelinedDataPreloader((RequestPipeline)pipeline, this.containerConfig);
        this.view = "profile";
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("profile"));
        PipelinedData.Batch batch = this.getBatch(gadget);
        Collection tasks = preloader.createPreloadTasks(this.context, batch);
        ((Callable)tasks.iterator().next()).call();
        Assert.assertEquals((long)1L, (long)pipeline.requests.size());
        HttpRequest request = pipeline.requests.get(0);
        Assert.assertEquals((Object)HTTP_REQUEST_URL, (Object)request.getUri().toString());
        Assert.assertEquals((Object)"POST", (Object)request.getMethod());
        Assert.assertEquals((Object)PARAMS, (Object)request.getPostBodyAsString());
    }

    @Test
    public void testHttpPreloadWithGetParams() throws Exception {
        GadgetSpec spec = new GadgetSpec(GADGET_URL, XML_WITH_HTTP_REQUEST_AND_GET_PARAMS);
        String httpResult = "{foo: 'bar'}";
        RecordingRequestPipeline pipeline = new RecordingRequestPipeline(httpResult);
        PipelinedDataPreloader preloader = new PipelinedDataPreloader((RequestPipeline)pipeline, this.containerConfig);
        this.view = "profile";
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("profile"));
        PipelinedData.Batch batch = this.getBatch(gadget);
        Collection tasks = preloader.createPreloadTasks(this.context, batch);
        ((Callable)tasks.iterator().next()).call();
        Assert.assertEquals((long)1L, (long)pipeline.requests.size());
        HttpRequest request = pipeline.requests.get(0);
        Assert.assertEquals((Object)"http://example.org/preload.html?a=b&c=d", (Object)request.getUri().toString());
        Assert.assertEquals((Object)"GET", (Object)request.getMethod());
    }

    @Test
    public void testSocialPreloadViewResolution() throws Exception {
        GadgetSpec spec = new GadgetSpec(GADGET_URL, XML_IN_DEFAULT_CONTAINER);
        String socialResult = "[{id:'p', data:1}, {id:'a', data:2}]";
        RecordingRequestPipeline pipeline = new RecordingRequestPipeline(socialResult);
        PipelinedDataPreloader preloader = new PipelinedDataPreloader((RequestPipeline)pipeline, this.containerConfig);
        this.view = "profile";
        this.contextParams.put("st", "token");
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("default"));
        PipelinedData.Batch batch = this.getBatch(gadget);
        Collection tasks = preloader.createPreloadTasks(this.context, batch);
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    private static class RecordingRequestPipeline
    implements RequestPipeline {
        public final List<HttpRequest> requests = Lists.newArrayList();
        private final HttpResponse response;

        public RecordingRequestPipeline(String content) {
            this(new HttpResponseBuilder().setResponseString(content).create());
        }

        public RecordingRequestPipeline(HttpResponse response) {
            this.response = response;
        }

        public HttpResponse execute(HttpRequest request) {
            this.requests.add(request);
            return this.response;
        }

        public void normalizeProtocol(HttpRequest request) throws GadgetException {
        }
    }
}

