/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizerTest;
import org.apache.shindig.gadgets.rewrite.image.GIFOptimizer;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;

public class GIFOptimizerTest
extends BaseOptimizerTest {
    public void testEfficientGIF() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/unanimated.gif", "image/gif");
        HttpResponse httpResponse = this.rewrite(resp);
        GIFOptimizerTest.assertSame((Object)resp, (Object)httpResponse);
    }

    public void testBadPaletteGIFToPNG() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/large.gif", "image/gif");
        HttpResponse httpResponse = this.rewrite(resp);
        GIFOptimizerTest.assertTrue((httpResponse.getContentLength() <= resp.getContentLength() ? 1 : 0) != 0);
        GIFOptimizerTest.assertEquals((String)httpResponse.getHeader("Content-Type"), (String)"image/png");
    }

    public void testDirectColorModelGif() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/directcolor.gif", "image/gif");
        HttpResponse httpResponse = this.rewrite(resp);
        GIFOptimizerTest.assertTrue((httpResponse.getContentLength() <= resp.getContentLength() ? 1 : 0) != 0);
        GIFOptimizerTest.assertEquals((String)httpResponse.getHeader("Content-Type"), (String)"image/gif");
    }

    protected HttpResponse rewrite(HttpResponse original) throws IOException, ImageReadException {
        return new GIFOptimizer(new OptimizerConfig(), original).rewrite(Sanselan.getBufferedImage((InputStream)original.getResponse()));
    }
}

