/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.el.ELResolver;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.RootELResolver;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.DefaultHtmlSerializer;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.SocialMarkupHtmlParser;
import org.apache.shindig.gadgets.render.SanitizingGadgetRewriter;
import org.apache.shindig.gadgets.templates.AbstractTagHandler;
import org.apache.shindig.gadgets.templates.DefaultTagRegistry;
import org.apache.shindig.gadgets.templates.DefaultTemplateProcessor;
import org.apache.shindig.gadgets.templates.TagHandler;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateContext;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultTemplateProcessorTest {
    private Expressions expressions;
    private TemplateContext context;
    private DefaultTemplateProcessor processor;
    private Map<String, Object> variables;
    private ELResolver resolver;
    private TagRegistry registry;
    private SocialMarkupHtmlParser parser;
    private static final String TEST_NS = "http://example.com";
    protected SingletonElementHandler singletonElementHandler;

    @Before
    public void setUp() throws Exception {
        this.expressions = Expressions.forTesting();
        this.variables = Maps.newHashMap();
        this.singletonElementHandler = new SingletonElementHandler();
        ImmutableSet handlers = ImmutableSet.of((Object[])new TagHandler[]{new TestTagHandler(), this.singletonElementHandler});
        this.registry = new DefaultTagRegistry((Set)handlers);
        this.processor = new DefaultTemplateProcessor(this.expressions);
        this.resolver = new RootELResolver();
        this.parser = new SocialMarkupHtmlParser(new ParseModule.DOMImplementationProvider().get());
        this.context = new TemplateContext(new Gadget(), this.variables);
        this.variables.put("foo", new JSONObject("{ title: 'bar' }"));
        this.variables.put("user", new JSONObject("{ id: '101', name: { first: 'John', last: 'Doe' }}"));
        this.variables.put("toys", new JSONObject("{ list: [{name: 'Ball'}, {name: 'Car'}]}"));
        this.variables.put("countries", new JSONArray("['Ireland','France']"));
        this.variables.put("xss", new JSONObject("{ script: '<script>alert();</script>',quote:'\"><script>alert();</script>'}"));
    }

    @Test
    public void testTextNode() throws Exception {
        String output = this.executeTemplate("${foo.title}");
        Assert.assertEquals((Object)"bar", (Object)output);
    }

    @Test
    public void testTopVariable() throws Exception {
        String output = this.executeTemplate("${Top.foo.title}");
        Assert.assertEquals((Object)"bar", (Object)output);
    }

    @Test
    public void testCurVariable() throws Exception {
        String output = this.executeTemplate("${Cur.foo.title}");
        Assert.assertEquals((Object)"bar", (Object)output);
    }

    @Test
    public void testMyVariable() throws Exception {
        String output = this.executeTemplate("${My.foo.title}");
        Assert.assertEquals((Object)"", (Object)output);
    }

    @Test
    public void testPlainText() throws Exception {
        String output = this.executeTemplate("<span>foo&amp;&bar</span>");
        Assert.assertEquals((Object)"<span>foo&amp;&bar</span>", (Object)output);
    }

    @Test
    public void testTextNodeEscaping() throws Exception {
        String output = this.executeTemplate("${xss.script}");
        Assert.assertFalse((String)("Escaping not performed: \"" + output + "\""), (boolean)output.contains("<script>alert("));
    }

    @Test
    public void testAppending() throws Exception {
        String output = this.executeTemplate("${user.id}${user.name.first}");
        Assert.assertEquals((Object)"101John", (Object)output);
        output = this.executeTemplate("foo${user.id}bar${user.name.first}baz");
        Assert.assertEquals((Object)"foo101barJohnbaz", (Object)output);
        output = this.executeTemplate("foo${user.nope}bar${user.nor}baz");
        Assert.assertEquals((Object)"foobarbaz", (Object)output);
    }

    @Test
    public void testEscapedExpressions() throws Exception {
        String output = this.executeTemplate("\\${escaped}");
        Assert.assertEquals((Object)"${escaped}", (Object)output);
        output = this.executeTemplate("foo\\${escaped}bar");
        Assert.assertEquals((Object)"foo${escaped}bar", (Object)output);
    }

    @Test
    public void testElement() throws Exception {
        String output = this.executeTemplate("<span title=\"${user.id}\">${user.name.first} baz</span>");
        Assert.assertEquals((Object)"<span title=\"101\">John baz</span>", (Object)output);
    }

    @Test
    public void testAttributeEscaping() throws Exception {
        String output = this.executeTemplate("<span title=\"${xss.quote}\">${user.name.first} baz</span>");
        Assert.assertFalse((boolean)output.contains("\"><script>alert("));
    }

    @Test
    public void testRepeat() throws Exception {
        String output = this.executeTemplate("<span repeat=\"${toys}\">${name}</span>");
        Assert.assertEquals((Object)"<span>Ball</span><span>Car</span>", (Object)output);
    }

    @Test
    public void testRepeatScalar() throws Exception {
        String output = this.executeTemplate("<span repeat=\"${countries}\">${Cur}</span>");
        Assert.assertEquals((Object)"<span>Ireland</span><span>France</span>", (Object)output);
    }

    @Test
    public void testCurAttribute() throws Exception {
        String output = this.executeTemplate("<span cur=\"${user.name}\">${first}</span>");
        Assert.assertEquals((Object)"<span>John</span>", (Object)output);
    }

    @Test
    public void testConditional() throws Exception {
        String output = this.executeTemplate("<span repeat=\"${toys}\"><span if=\"${name == 'Car'}\">Car</span><span if=\"${name != 'Car'}\">Not Car</span></span>");
        Assert.assertEquals((Object)"<span><span>Not Car</span></span><span><span>Car</span></span>", (Object)output);
    }

    @Test
    public void testCustomTag() throws Exception {
        String output = this.executeTemplate("<test:Foo text='${foo.title}' data='${user}'/>", "xmlns:test='http://example.com'");
        Assert.assertEquals((Object)"<b>BAR</b>", (Object)output);
    }

    @Test
    public void testBooleanAttributes() throws Exception {
        String output = this.executeTemplate("<input class=\"${1 == 2}\" readonly=\"${1 == 2}\"disabled=\"${1 == 1}\">");
        Assert.assertEquals((Object)"<input class=\"false\" disabled=\"disabled\">", (Object)output);
    }

    @Test
    public void testOnCreate() throws Exception {
        String output = this.executeTemplate("<span oncreate=\"foo\"></span>");
        Assert.assertEquals((Object)"<span id=\"ostid0\"></span><script type=\"text/javascript\">(function(){foo}).apply(document.getElementById('ostid0'));</script>", (Object)output);
        output = this.executeTemplate("<span x-oncreate=\"foo\"></span>");
        Assert.assertEquals((Object)"<span id=\"ostid1\"></span><script type=\"text/javascript\">(function(){foo}).apply(document.getElementById('ostid1'));</script>", (Object)output);
        output = this.executeTemplate("<span id=\"bar\" oncreate=\"foo\"></span>");
        Assert.assertEquals((Object)"<span id=\"bar\"></span><script type=\"text/javascript\">(function(){foo}).apply(document.getElementById('bar'));</script>", (Object)output);
    }

    @Test
    public void testSafeCrossDocumentCloning() throws Exception {
        String template = "<test:Bar text='${foo.title}' data='${user}'/>";
        this.executeTemplate(template, "xmlns:test='http://example.com'");
        this.executeTemplate(template, "xmlns:test='http://example.com'");
        Document doc = this.singletonElementHandler.elem.getOwnerDocument();
        Class<?> docClass = doc.getClass();
        Field userDataField = null;
        while (userDataField == null) {
            try {
                userDataField = docClass.getDeclaredField("userData");
            }
            catch (NoSuchFieldException nsfe) {
                // empty catch block
            }
            docClass = docClass.getSuperclass();
        }
        userDataField.setAccessible(true);
        Hashtable userDataMap = (Hashtable)userDataField.get(doc);
        Assert.assertEquals((long)1L, (long)userDataMap.size());
    }

    private String executeTemplate(String markup) throws Exception {
        return this.executeTemplate(markup, "");
    }

    private String executeTemplate(String markup, String extra) throws Exception {
        Element template = this.prepareTemplate(markup, extra);
        DocumentFragment result = this.processor.processTemplate(template, this.context, this.resolver, this.registry);
        return this.serialize(result);
    }

    private Element prepareTemplate(String markup, String extra) throws GadgetException {
        String content = "<script type=\"text/os-template\"" + extra + ">" + markup + "</script>";
        Document document = this.parser.parseDom(content);
        return (Element)document.getElementsByTagName("script").item(0);
    }

    private String serialize(Node node) throws IOException {
        StringBuilder sb = new StringBuilder();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            new DefaultHtmlSerializer().serialize(child, (Appendable)sb);
        }
        return sb.toString();
    }

    private static class SingletonElementHandler
    extends AbstractTagHandler {
        Element elem = XmlUtil.parseSilent((String)"<wrapper><div><a>out</a></div></wrapper>");

        public SingletonElementHandler() {
            super(DefaultTemplateProcessorTest.TEST_NS, "Bar");
            SanitizingGadgetRewriter.bypassSanitization((Element)((Element)this.elem.getFirstChild()), (boolean)true);
        }

        public void process(Node result, Element tag, TemplateProcessor processor) {
            processor.processChildNodes(result, (Node)this.elem);
        }
    }

    private static class TestTagHandler
    extends AbstractTagHandler {
        public TestTagHandler() {
            super(DefaultTemplateProcessorTest.TEST_NS, "Foo");
        }

        public void process(Node result, Element tag, TemplateProcessor processor) {
            Object data = this.getValueFromTag(tag, "data", processor, Object.class);
            Assert.assertTrue((boolean)(data instanceof JSONObject));
            Assert.assertEquals((Object)"101", (Object)((JSONObject)data).optString("id"));
            String text = (String)this.getValueFromTag(tag, "text", processor, String.class);
            text = text.toUpperCase();
            Document doc = result.getOwnerDocument();
            Element b = doc.createElement("b");
            b.appendChild(doc.createTextNode(text));
            result.appendChild(b);
        }
    }
}

