/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.variables.Substitutions;

public class SubstitutionsTest
extends TestCase {
    private Substitutions subst;

    public void setUp() throws Exception {
        super.setUp();
        this.subst = new Substitutions();
    }

    public void testMessages() throws Exception {
        String msg = "Hello, __MSG_world__!";
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "world", "planet");
        SubstitutionsTest.assertEquals((String)"Hello, planet!", (String)this.subst.substituteString(msg));
    }

    public void testBidi() throws Exception {
        String msg = "Hello, __BIDI_DIR__-world!";
        this.subst.addSubstitution(Substitutions.Type.BIDI, "DIR", "rtl");
        SubstitutionsTest.assertEquals((String)"Hello, rtl-world!", (String)this.subst.substituteString(msg));
    }

    public void testUserPref() throws Exception {
        String msg = "__UP_hello__, world!";
        this.subst.addSubstitution(Substitutions.Type.USER_PREF, "hello", "Greetings");
        SubstitutionsTest.assertEquals((String)"Greetings, world!", (String)this.subst.substituteString(msg));
    }

    public void testCorrectOrder() throws Exception {
        String msg = "__UP_hello__, __MSG_world__!";
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "world", "planet __BIDI_DIR__-__UP_planet__");
        this.subst.addSubstitution(Substitutions.Type.BIDI, "DIR", "rtl");
        this.subst.addSubstitution(Substitutions.Type.USER_PREF, "hello", "Greetings");
        this.subst.addSubstitution(Substitutions.Type.USER_PREF, "planet", "Earth");
        SubstitutionsTest.assertEquals((String)"Greetings, planet rtl-Earth!", (String)this.subst.substituteString(msg));
    }

    public void testIncorrectOrder() throws Exception {
        String msg = "__UP_hello__, __MSG_world__";
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "world", "planet __MSG_earth____UP_punc__");
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "earth", "Earth");
        this.subst.addSubstitution(Substitutions.Type.USER_PREF, "punc", "???");
        this.subst.addSubstitution(Substitutions.Type.USER_PREF, "hello", "Greetings __MSG_foo____UP_bar__");
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "foo", "FOO!!!");
        this.subst.addSubstitution(Substitutions.Type.USER_PREF, "bar", "BAR!!!");
        SubstitutionsTest.assertEquals((String)"Greetings __MSG_foo____UP_bar__, planet __MSG_earth__???", (String)this.subst.substituteString(msg));
    }

    public void testDanglingUnderScoresAreIgnored() throws Exception {
        String msg = "__MSG_hello__, var_msg + '__' + 'world __MSG_world__";
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "hello", "Hello");
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "world", "World");
        SubstitutionsTest.assertEquals((String)"Hello, var_msg + '__' + 'world World", (String)this.subst.substituteString(msg));
    }

    public void testComplexUnderscores() throws Exception {
        String msg = "__MSG_hello____________ten____________MSG_world______";
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "hello", "Hello");
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "world", "World");
        SubstitutionsTest.assertEquals((String)"Hello__________ten__________World____", (String)this.subst.substituteString(msg));
    }

    public void testMessageId() throws Exception {
        String msg = "Hello, __MODULE_ID__!";
        this.subst.addSubstitution(Substitutions.Type.MODULE, "ID", "123");
        SubstitutionsTest.assertEquals((String)"Hello, 123!", (String)this.subst.substituteString(msg));
    }

    public void testOddNumberOfPrecedingUnderscores() throws Exception {
        String msg = "<div id='div___MODULE_ID__'/>";
        this.subst.addSubstitution(Substitutions.Type.MODULE, "ID", "123");
        SubstitutionsTest.assertEquals((String)"<div id='div_123'/>", (String)this.subst.substituteString(msg));
    }

    public void testOddUnderscoresWithInvalidSubstFollowedByValidSubst() throws Exception {
        String msg = "<div id='div___HI_THERE__MODULE_ID___'/>";
        this.subst.addSubstitution(Substitutions.Type.MODULE, "ID", "123");
        SubstitutionsTest.assertEquals((String)"<div id='div___HI_THERE123_'/>", (String)this.subst.substituteString(msg));
    }

    public void loadTest() throws Exception {
        String msg = "Random text and __UP_hello__, amongst other words __MSG_world__ stuff __weeeeee";
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "world", "planet __MSG_earth____UP_punc__");
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "earth", "Earth");
        this.subst.addSubstitution(Substitutions.Type.USER_PREF, "punc", "???");
        this.subst.addSubstitution(Substitutions.Type.USER_PREF, "hello", "Greetings __MSG_foo____UP_bar__");
        this.subst.addSubstitution(Substitutions.Type.MESSAGE, "foo", "FOO!!!");
        this.subst.addSubstitution(Substitutions.Type.USER_PREF, "bar", "BAR!!!");
        msg = msg + StringUtils.repeat((String)"foo ", (int)1000);
        String message = StringUtils.repeat((String)msg, (int)1000);
        long now = System.nanoTime();
        int cnt = 1000;
        for (int i = 0; i < cnt; ++i) {
            this.subst.substituteString(message);
        }
        long duration = System.nanoTime() - now;
        System.out.println("Duration: " + duration + " avg: " + duration / (long)cnt);
    }
}

