/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.SoftExpiringCache;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.spec.ApplicationManifest;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultGadgetSpecFactory
implements GadgetSpecFactory {
    public static final String CACHE_NAME = "gadgetSpecs";
    static final String VERSION_PARAM = "version";
    static final String LABEL_PARAM = "label";
    static final String DEFAULT_LABEL = "production";
    static final String RAW_GADGETSPEC_XML_PARAM_NAME = "rawxml";
    static final Uri RAW_GADGET_URI = Uri.parse((String)"http://localhost/raw.xml");
    private final Logger logger = Logger.getLogger(DefaultGadgetSpecFactory.class.getName());
    private final ExecutorService executor;
    private final RequestPipeline pipeline;
    final SoftExpiringCache<Uri, Object> cache;
    private final long refresh;

    @Inject
    public DefaultGadgetSpecFactory(ExecutorService executor, RequestPipeline pipeline, CacheProvider cacheProvider, @Named(value="shindig.cache.xml.refreshInterval") long refresh) {
        this.executor = executor;
        this.pipeline = pipeline;
        Cache baseCache = cacheProvider.createCache(CACHE_NAME);
        this.cache = new SoftExpiringCache(baseCache);
        this.refresh = refresh;
    }

    @Override
    public GadgetSpec getGadgetSpec(GadgetContext context) throws GadgetException {
        String rawxml = context.getParameter(RAW_GADGETSPEC_XML_PARAM_NAME);
        if (rawxml != null) {
            try {
                return new GadgetSpec(RAW_GADGET_URI, XmlUtil.parse((String)rawxml), rawxml);
            }
            catch (XmlException e) {
                throw new SpecParserException(e);
            }
        }
        return this.fetchObject(context.getUrl(), context, false);
    }

    private GadgetSpec getSpecFromManifest(ApplicationManifest manifest, GadgetContext context) throws GadgetException {
        String label;
        String version = context.getParameter(VERSION_PARAM);
        if (version == null && (version = manifest.getVersion(label = DefaultGadgetSpecFactory.firstNonNull(context.getParameter(LABEL_PARAM), DEFAULT_LABEL))) == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Unable to find a suitable version for the given manifest.");
        }
        Uri specUri = manifest.getGadget(version);
        if (specUri == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "No gadget spec available for the given version.");
        }
        return this.fetchObject(specUri, context, true);
    }

    private GadgetSpec fetchObject(Uri uri, GadgetContext context, boolean noManifests) throws GadgetException {
        SoftExpiringCache.CachedObject cached;
        Object obj = null;
        if (!context.getIgnoreCache() && (cached = this.cache.getElement((Object)uri)) != null) {
            obj = cached.obj;
            if (cached.isExpired) {
                this.cache.addElement((Object)uri, obj, this.refresh);
                this.executor.execute(new ObjectUpdater(uri, context, obj));
            }
        }
        if (obj == null) {
            try {
                obj = this.fetchFromNetwork(uri, context);
            }
            catch (GadgetException e) {
                obj = e;
            }
            this.cache.addElement((Object)uri, obj, this.refresh);
        }
        if (obj instanceof GadgetSpec) {
            return (GadgetSpec)obj;
        }
        if (obj instanceof ApplicationManifest) {
            if (noManifests) {
                throw new SpecParserException("Manifests may not reference other manifests.");
            }
            return this.getSpecFromManifest((ApplicationManifest)obj, context);
        }
        if (obj instanceof GadgetException) {
            throw (GadgetException)obj;
        }
        throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Unknown object type stored for input URI " + uri);
    }

    private Object fetchFromNetwork(Uri uri, GadgetContext context) throws GadgetException {
        HttpRequest request = new HttpRequest(uri).setIgnoreCache(context.getIgnoreCache()).setGadget(uri).setContainer(context.getContainer());
        request.setCacheTtl((int)(this.refresh / 1000L));
        HttpResponse response = this.pipeline.execute(request);
        if (response.getHttpStatusCode() != 200) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unable to retrieve gadget xml. HTTP error " + response.getHttpStatusCode());
        }
        try {
            String content = response.getResponseAsString();
            Element element = XmlUtil.parse((String)content);
            if ("http://ns.opensocial.org/2008/application".equals(element.getNamespaceURI())) {
                return new ApplicationManifest(uri, element);
            }
            return new GadgetSpec(uri, element, content);
        }
        catch (XmlException e) {
            throw new SpecParserException(e);
        }
    }

    private static <T> T firstNonNull(T first, T second) {
        return (T)(first != null ? first : Preconditions.checkNotNull(second));
    }

    private class ObjectUpdater
    implements Runnable {
        private final Uri uri;
        private final GadgetContext context;
        private final Object old;

        public ObjectUpdater(Uri uri, GadgetContext context, Object old) {
            this.uri = uri;
            this.context = context;
            this.old = old;
        }

        public void run() {
            try {
                Object newObject = DefaultGadgetSpecFactory.this.fetchFromNetwork(this.uri, this.context);
                DefaultGadgetSpecFactory.this.cache.addElement((Object)this.uri, newObject, DefaultGadgetSpecFactory.this.refresh);
            }
            catch (GadgetException e) {
                if (this.old != null) {
                    DefaultGadgetSpecFactory.this.logger.info("Failed to update " + this.uri + ". Using cached version.");
                    DefaultGadgetSpecFactory.this.cache.addElement((Object)this.uri, this.old, DefaultGadgetSpecFactory.this.refresh);
                }
                DefaultGadgetSpecFactory.this.logger.info("Failed to update " + this.uri + ". Applying negative cache.");
                DefaultGadgetSpecFactory.this.cache.addElement((Object)this.uri, (Object)e, DefaultGadgetSpecFactory.this.refresh);
            }
        }
    }
}

