/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gadget {
    private GadgetFeatureRegistry gadgetFeatureRegistry;
    private GadgetContext context;
    private GadgetSpec spec;
    private Collection<PreloadedData> preloads;
    private View currentView;
    private Set<String> addedFeatures;
    private Set<String> removedFeatures;
    private List<String> allGadgetFeatures;

    public Gadget setContext(GadgetContext context) {
        this.context = context;
        return this;
    }

    public GadgetContext getContext() {
        return this.context;
    }

    public Gadget setGadgetFeatureRegistry(GadgetFeatureRegistry registry) {
        this.gadgetFeatureRegistry = registry;
        return this;
    }

    public Gadget setSpec(GadgetSpec spec) {
        this.spec = spec;
        return this;
    }

    public GadgetSpec getSpec() {
        return this.spec;
    }

    public Gadget setPreloads(Collection<PreloadedData> preloads) {
        this.preloads = preloads;
        return this;
    }

    public Collection<PreloadedData> getPreloads() {
        return this.preloads;
    }

    public synchronized List<String> getAllFeatures() {
        if (this.allGadgetFeatures == null) {
            if (this.gadgetFeatureRegistry != null) {
                this.allGadgetFeatures = Lists.newArrayList();
                for (GadgetFeature gadgetFeature : this.gadgetFeatureRegistry.getFeatures(this.spec.getModulePrefs().getFeatures().keySet())) {
                    this.allGadgetFeatures.add(gadgetFeature.getName());
                }
                Collections.reverse(this.allGadgetFeatures);
            } else {
                throw new IllegalStateException("setGadgetFeatureRegistry must be called before Gadget.getAllFeatures()");
            }
        }
        return this.allGadgetFeatures;
    }

    public Gadget setCurrentView(View currentView) {
        this.currentView = currentView;
        return this;
    }

    public View getCurrentView() {
        return this.currentView;
    }

    public LocaleSpec getLocale() {
        return this.spec.getModulePrefs().getLocale(this.context.getLocale());
    }

    public void addFeature(String name) {
        if (this.addedFeatures == null) {
            this.addedFeatures = Sets.newHashSet();
        }
        this.addedFeatures.add(name);
    }

    public void removeFeature(String name) {
        if (this.removedFeatures == null) {
            this.removedFeatures = Sets.newHashSet();
        }
        this.removedFeatures.add(name);
    }

    public Set<String> getAddedFeatures() {
        if (this.addedFeatures == null) {
            return Collections.emptySet();
        }
        return this.addedFeatures;
    }

    public Set<String> getRemovedFeatures() {
        if (this.removedFeatures == null) {
            return Collections.emptySet();
        }
        return this.removedFeatures;
    }

    public boolean sanitizeOutput() {
        return this.getCurrentView() != null && this.getCurrentView().getType() == View.ContentType.HTML_SANITIZED || "1".equals(this.getContext().getParameter("sanitize"));
    }
}

