/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Set;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.xerces.xni.QName;
import org.cyberneko.html.HTMLEntities;
import org.w3c.dom.Document;

public class HtmlSerialization {
    private static final String KEY = "serializer";
    private static final String ORIGINAL_LENGTH = "original-length";
    public static final Set<String> URL_ATTRIBUTES = ImmutableSet.of((Object[])new String[]{"href", "src"});

    static void attach(Document doc, HtmlSerializer serializer, String originalContent) {
        doc.setUserData(KEY, serializer, null);
        if (originalContent != null) {
            doc.setUserData(ORIGINAL_LENGTH, originalContent.length(), null);
        }
    }

    static void copySerializer(Document from, Document to) {
        Integer length = (Integer)from.getUserData(ORIGINAL_LENGTH);
        if (length != null) {
            to.setUserData(ORIGINAL_LENGTH, length, null);
        }
        to.setUserData(KEY, from.getUserData(KEY), null);
    }

    private static int getOriginalLength(Document doc) {
        Integer length = (Integer)doc.getUserData(ORIGINAL_LENGTH);
        if (length == null) {
            return -1;
        }
        return length;
    }

    protected static StringWriter createWriter(Document doc) {
        int originalLength = HtmlSerialization.getOriginalLength(doc);
        if (originalLength == -1) {
            return new StringWriter(8192);
        }
        return new StringWriter(originalLength * 11 / 10);
    }

    public static String serialize(Document doc) {
        return ((HtmlSerializer)doc.getUserData(KEY)).serialize(doc);
    }

    public static void printEscapedText(CharSequence text, Appendable output) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            String entity = HTMLEntities.get((int)c);
            if (entity != null) {
                output.append('&').append(entity).append(";");
                continue;
            }
            output.append(c);
        }
    }

    public static boolean isUrlAttribute(QName name, String attributeName) {
        return name.uri == null && URL_ATTRIBUTES.contains(attributeName);
    }
}

