/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.caja.util.Join;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import junitx.framework.StringAssert;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.DefaultUrlGenerator;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.easymock.EasyMock;

public class DefaultUrlGeneratorTest
extends EasyMockTestCase {
    private static final String IFR_BASE = "/gadgets/eye-frame";
    private static final String JS_BASE = "http://%host%/get-together/livescript/%js%";
    private static final String SPEC_URL = "http://example.org/gadget.xml";
    private static final String TYPE_URL_HREF_HOST = "opensocial.org";
    private static final String TYPE_URL_HREF_PATH = "/app/foo";
    private static final String TYPE_URL_HREF_QUERY = "foo=bar&bar=baz";
    private static final String TYPE_URL_HREF = "http://opensocial.org/app/foo?foo=bar&bar=baz";
    private static final String UP_NAME = "user-pref-name";
    private static final String UP_VALUE = "user-pref-value";
    private static final String CONTAINER = "shindig";
    private static final String VIEW = "canvas";
    private static final int MODULE_ID = 3435;
    private final GadgetContext context = (GadgetContext)this.mock(GadgetContext.class);
    private final LockedDomainService lockedDomainService = (LockedDomainService)this.mock(LockedDomainService.class);
    private final GadgetFeatureRegistry registry = (GadgetFeatureRegistry)this.mock(GadgetFeatureRegistry.class);
    private final FakeContainerConfig config = new FakeContainerConfig();
    private UrlGenerator urlGenerator;

    public void setUp() throws Exception {
        super.setUp();
        EasyMock.expect((Object)this.context.getContainer()).andReturn((Object)CONTAINER).anyTimes();
        EasyMock.expect((Object)this.context.getUrl()).andReturn((Object)Uri.parse((String)SPEC_URL)).anyTimes();
        HashMap prefMap = Maps.newHashMap();
        prefMap.put(UP_NAME, UP_VALUE);
        UserPrefs prefs = new UserPrefs((Map)prefMap);
        EasyMock.expect((Object)this.context.getUserPrefs()).andReturn((Object)prefs).anyTimes();
        EasyMock.expect((Object)this.context.getLocale()).andReturn((Object)Locale.getDefault()).anyTimes();
        EasyMock.expect((Object)this.context.getModuleId()).andReturn((Object)3435).anyTimes();
        EasyMock.expect((Object)this.context.getView()).andReturn((Object)VIEW).anyTimes();
        ArrayList features = Lists.newArrayList();
        EasyMock.expect((Object)this.registry.getAllFeatures()).andReturn((Object)features);
        this.config.properties.put("gadgets.iframeBaseUri", IFR_BASE);
        this.config.properties.put("gadgets.jsUriTemplate", JS_BASE);
        this.replay(this.registry);
        this.urlGenerator = new DefaultUrlGenerator((ContainerConfig)this.config, this.lockedDomainService, this.registry);
        this.reset(this.registry);
    }

    public void testGetBundledJsParamWithGoodFeatureName() throws Exception {
        ImmutableList features = ImmutableList.of((Object)"ABCDEFGHIJKLMNOPQRSTUVWXYZ", (Object)"abcdefghijklmnopqrstuvwxyz", (Object)"0123456789", (Object)"_.-");
        EasyMock.expect((Object)this.context.getDebug()).andReturn((Object)true);
        this.replay();
        String jsParam = this.urlGenerator.getBundledJsParam((Collection)features, this.context);
        DefaultUrlGeneratorTest.assertTrue((boolean)jsParam.matches(Join.join((CharSequence)":", (Iterable)features) + "\\.js\\?v=[0-9a-zA-Z]*&container=" + CONTAINER + "&debug=1"));
    }

    public void testGetBundledJsParamWithBadFeatureName() throws Exception {
        ArrayList features = Lists.newArrayList();
        features.add("foo!");
        features.add("bar");
        EasyMock.expect((Object)this.context.getDebug()).andReturn((Object)true);
        this.replay();
        String jsParam = this.urlGenerator.getBundledJsParam((Collection)features, this.context);
        DefaultUrlGeneratorTest.assertTrue((boolean)jsParam.matches("bar\\.js\\?v=[0-9a-zA-Z]*&container=shindig&debug=1"));
    }

    public void testGetBundledJsParamWithNoFeatures() throws Exception {
        ArrayList features = Lists.newArrayList();
        EasyMock.expect((Object)this.context.getDebug()).andReturn((Object)false);
        this.replay();
        String jsParam = this.urlGenerator.getBundledJsParam((Collection)features, this.context);
        DefaultUrlGeneratorTest.assertTrue((boolean)jsParam.matches("core\\.js\\?v=[0-9a-zA-Z]*&container=shindig&debug=0"));
    }

    public void testGetBundledJsUrl() throws Exception {
        List<String> features = Arrays.asList("foo", "bar");
        EasyMock.expect((Object)this.context.getDebug()).andReturn((Object)false);
        EasyMock.expect((Object)this.context.getHost()).andReturn((Object)"example.org");
        this.replay();
        String jsParam = this.urlGenerator.getBundledJsUrl(features, this.context);
        Uri uri = Uri.parse((String)jsParam);
        DefaultUrlGeneratorTest.assertEquals((String)"example.org", (String)uri.getAuthority());
        DefaultUrlGeneratorTest.assertEquals((String)"/get-together/livescript/foo:bar.js", (String)uri.getPath());
        DefaultUrlGeneratorTest.assertTrue((String)"Missing checksum.", (boolean)uri.getQueryParameter("v").matches("[0-9a-zA-Z]*"));
        DefaultUrlGeneratorTest.assertEquals((String)CONTAINER, (String)uri.getQueryParameter("container"));
        DefaultUrlGeneratorTest.assertEquals((String)"0", (String)uri.getQueryParameter("debug"));
    }

    public void testGetIframeUrlTypeHtml() throws Exception {
        String xml = "<Module> <ModulePrefs title='test'/> <Content type='html'/> <UserPref name='user-pref-name' datatype='string'/></Module>";
        GadgetSpec spec = new GadgetSpec(Uri.parse((String)SPEC_URL), xml);
        this.replay();
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("default"));
        Uri iframeUrl = Uri.parse((String)this.urlGenerator.getIframeUrl(gadget));
        DefaultUrlGeneratorTest.assertEquals((String)IFR_BASE, (String)iframeUrl.getPath());
        DefaultUrlGeneratorTest.assertEquals((String)CONTAINER, (String)iframeUrl.getQueryParameter("container"));
        DefaultUrlGeneratorTest.assertEquals((String)UP_VALUE, (String)iframeUrl.getQueryParameter("up_user-pref-name"));
        DefaultUrlGeneratorTest.assertEquals((String)Integer.toString(3435), (String)iframeUrl.getQueryParameter("mid"));
        DefaultUrlGeneratorTest.assertEquals((String)VIEW, (String)iframeUrl.getQueryParameter("view"));
    }

    public void testGetIframeUrlTypeHtmlWithLockedDomain() throws Exception {
        String xml = "<Module> <ModulePrefs title='test'/> <Content type='html'/> <UserPref name='user-pref-name' datatype='string'/></Module>";
        GadgetSpec spec = new GadgetSpec(Uri.parse((String)SPEC_URL), xml);
        EasyMock.expect((Object)this.lockedDomainService.getLockedDomainForGadget((Gadget)EasyMock.isA(Gadget.class), (String)EasyMock.eq((Object)CONTAINER))).andReturn((Object)"locked.example.org");
        this.replay();
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("default"));
        Uri iframeUrl = Uri.parse((String)this.urlGenerator.getIframeUrl(gadget));
        DefaultUrlGeneratorTest.assertEquals((String)"locked.example.org", (String)iframeUrl.getAuthority());
        DefaultUrlGeneratorTest.assertEquals((String)IFR_BASE, (String)iframeUrl.getPath());
        DefaultUrlGeneratorTest.assertEquals((String)CONTAINER, (String)iframeUrl.getQueryParameter("container"));
        DefaultUrlGeneratorTest.assertEquals((String)UP_VALUE, (String)iframeUrl.getQueryParameter("up_user-pref-name"));
        DefaultUrlGeneratorTest.assertEquals((String)Integer.toString(3435), (String)iframeUrl.getQueryParameter("mid"));
        DefaultUrlGeneratorTest.assertEquals((String)VIEW, (String)iframeUrl.getQueryParameter("view"));
    }

    public void testGetIframeUrlTypeUrl() throws Exception {
        String xml = "<Module> <ModulePrefs title='test'/> <Content type='url' href='" + StringEscapeUtils.escapeHtml((String)TYPE_URL_HREF) + "'/>" + " <UserPref name='" + UP_NAME + "' datatype='string'/>" + "</Module>";
        GadgetSpec spec = new GadgetSpec(Uri.parse((String)SPEC_URL), xml);
        this.replay();
        Gadget gadget = new Gadget().setContext(this.context).setSpec(spec).setCurrentView(spec.getView("default"));
        URI iframeUrl = URI.create(this.urlGenerator.getIframeUrl(gadget));
        DefaultUrlGeneratorTest.assertEquals((String)TYPE_URL_HREF_HOST, (String)iframeUrl.getAuthority());
        DefaultUrlGeneratorTest.assertEquals((String)TYPE_URL_HREF_PATH, (String)iframeUrl.getPath());
        StringAssert.assertContains((String)TYPE_URL_HREF_QUERY, (String)iframeUrl.getQuery());
        StringAssert.assertContains((String)"container=shindig", (String)iframeUrl.getQuery());
        StringAssert.assertContains((String)"up_user-pref-name=user-pref-value", (String)iframeUrl.getQuery());
        StringAssert.assertContains((String)"mid=3435", (String)iframeUrl.getQuery());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeContainerConfig
    extends AbstractContainerConfig {
        protected final Map<String, String> properties = Maps.newHashMap();

        private FakeContainerConfig() {
        }

        public Object getProperty(String container, String property) {
            return this.properties.get(property);
        }

        public Collection<String> getContainers() {
            return Arrays.asList(DefaultUrlGeneratorTest.CONTAINER);
        }
    }
}

