/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import junitx.framework.ArrayAssert;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.http.EchoServer;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractHttpFetcherTest {
    private static final int ECHO_PORT = 9003;
    private static final Uri BASE_URL = Uri.parse((String)"http://localhost:9003/");
    private static EchoServer server;
    protected HttpFetcher fetcher = null;

    @BeforeClass
    public static void setUpOnce() throws Exception {
        server = new EchoServer();
        server.start(9003);
    }

    @AfterClass
    public static void tearDownOnce() throws Exception {
        if (server != null) {
            server.stop();
        }
    }

    @Test
    public void testHttpFetch() throws Exception {
        String content = "Hello, world!";
        Uri uri = new UriBuilder(BASE_URL).addQueryParameter("body", content).toUri();
        HttpRequest request = new HttpRequest(uri);
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((long)200L, (long)response.getHttpStatusCode());
        Assert.assertEquals((Object)content, (Object)response.getResponseAsString());
    }

    @Test
    public void testHttp404() throws Exception {
        String content = "Hello, world!";
        Uri uri = new UriBuilder(BASE_URL).addQueryParameter("body", content).addQueryParameter("status", "404").toUri();
        HttpRequest request = new HttpRequest(uri);
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((long)404L, (long)response.getHttpStatusCode());
        Assert.assertEquals((Object)content, (Object)response.getResponseAsString());
    }

    @Test
    public void testHttp403() throws Exception {
        String content = "Hello, world!";
        Uri uri = new UriBuilder(BASE_URL).addQueryParameter("body", content).addQueryParameter("status", "403").addQueryParameter("header", "WWW-Authenticate=some auth data").toUri();
        HttpRequest request = new HttpRequest(uri);
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((long)403L, (long)response.getHttpStatusCode());
        Assert.assertEquals((Object)content, (Object)response.getResponseAsString());
        Assert.assertEquals((Object)"some auth data", (Object)response.getHeader("WWW-Authenticate"));
    }

    @Test
    public void testHttp403NoBody() throws Exception {
        String content = "";
        Uri uri = new UriBuilder(BASE_URL).addQueryParameter("body", content).addQueryParameter("status", "403").addQueryParameter("header", "WWW-Authenticate=some auth data").toUri();
        HttpRequest request = new HttpRequest(uri);
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((long)403L, (long)response.getHttpStatusCode());
        Assert.assertEquals((Object)content, (Object)response.getResponseAsString());
        Assert.assertEquals((Object)"some auth data", (Object)response.getHeader("WWW-Authenticate"));
    }

    @Test
    public void testHttp401NoBody() throws Exception {
        String content = "";
        Uri uri = new UriBuilder(BASE_URL).addQueryParameter("body", content).addQueryParameter("status", "401").addQueryParameter("header", "WWW-Authenticate=some auth data").toUri();
        HttpRequest request = new HttpRequest(uri);
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((long)401L, (long)response.getHttpStatusCode());
        Assert.assertEquals((Object)content, (Object)response.getResponseAsString());
        Assert.assertEquals((Object)"some auth data", (Object)response.getHeader("WWW-Authenticate"));
    }

    @Test
    public void testDelete() throws Exception {
        HttpRequest request = new HttpRequest(BASE_URL).setMethod("DELETE");
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((Object)"DELETE", (Object)response.getHeader("x-method"));
    }

    @Test
    public void testPost_noBody() throws Exception {
        HttpRequest request = new HttpRequest(BASE_URL).setMethod("POST");
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((Object)"POST", (Object)response.getHeader("x-method"));
        Assert.assertEquals((Object)"", (Object)response.getResponseAsString());
    }

    @Test
    public void testPost_withBody() throws Exception {
        byte[] body = new byte[5000];
        for (int i = 0; i < body.length; ++i) {
            body[i] = (byte)(i % 255);
        }
        HttpRequest request = new HttpRequest(BASE_URL).setMethod("POST").setPostBody(body).addHeader("content-type", "application/octet-stream");
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((Object)"POST", (Object)response.getHeader("x-method"));
        ArrayAssert.assertEquals((byte[])body, (byte[])response.getResponseAsBytes());
    }

    @Test
    public void testPut_noBody() throws Exception {
        HttpRequest request = new HttpRequest(BASE_URL).setMethod("PUT");
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((Object)"PUT", (Object)response.getHeader("x-method"));
        Assert.assertEquals((Object)"", (Object)response.getResponseAsString());
    }

    @Test
    public void testPut_withBody() throws Exception {
        byte[] body = new byte[5000];
        for (int i = 0; i < body.length; ++i) {
            body[i] = (byte)i;
        }
        HttpRequest request = new HttpRequest(BASE_URL).setMethod("PUT").setPostBody(body).addHeader("content-type", "application/octet-stream");
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((Object)"PUT", (Object)response.getHeader("x-method"));
        ArrayAssert.assertEquals((byte[])body, (byte[])response.getResponseAsBytes());
    }

    @Test
    public void testHugeBody() throws Exception {
        byte[] body = new byte[0x100000];
        for (int i = 0; i < body.length; ++i) {
            body[i] = (byte)i;
        }
        HttpRequest request = new HttpRequest(BASE_URL).setMethod("POST").setPostBody(body).addHeader("content-type", "application/octet-stream");
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((Object)"POST", (Object)response.getHeader("x-method"));
        ArrayAssert.assertEquals((byte[])body, (byte[])response.getResponseAsBytes());
    }

    @Test
    public void testFollowRedirects() throws Exception {
        String content = "";
        Uri uri = new UriBuilder(BASE_URL).addQueryParameter("body", content).addQueryParameter("status", "302").addQueryParameter("header", "Location=" + BASE_URL.toString() + "?body=redirected").toUri();
        HttpRequest request = new HttpRequest(uri);
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((long)200L, (long)response.getHttpStatusCode());
        Assert.assertEquals((Object)"redirected", (Object)response.getResponseAsString());
    }

    @Test
    public void testNoFollowRedirects() throws Exception {
        String content = "";
        Uri uri = new UriBuilder(BASE_URL).addQueryParameter("body", content).addQueryParameter("status", "302").addQueryParameter("header", "Location=" + BASE_URL.toString() + "?body=redirected").toUri();
        HttpRequest request = new HttpRequest(uri).setFollowRedirects(false);
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((long)302L, (long)response.getHttpStatusCode());
        Assert.assertEquals((Object)content, (Object)response.getResponseAsString());
        Assert.assertEquals((Object)(BASE_URL.toString() + "?body=redirected"), (Object)response.getHeader("Location"));
    }
}

