/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import java.util.List;
import junit.framework.TestCase;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.gadgets.parse.caja.CajaCssLexerParser;

public class CajaCssLexerParserTest
extends TestCase {
    private CajaCssLexerParser cajaCssParser;
    private static final String CSS = "@import url('www.example.org/someother.css');\n.xyz { background-image : url(http://www.example.org/someimage.gif); }\nA { color : #7f7f7f }\n";

    protected void setUp() throws Exception {
        super.setUp();
        this.cajaCssParser = new CajaCssLexerParser();
    }

    public void testBasicCssParse() throws Exception {
        String css = ".xyz { font : bold; } A { color : #7f7f7f }";
        List styleSheet = this.cajaCssParser.parse(css);
        CajaCssLexerParserTest.assertEquals((String)this.cajaCssParser.serialize(styleSheet), (String)css);
    }

    public void testClone() throws Exception {
        this.cajaCssParser.setCacheProvider((CacheProvider)new LruCacheProvider(100));
        List styleSheet = this.cajaCssParser.parseImpl(CSS);
        List styleSheet2 = this.cajaCssParser.parse(CSS);
        CajaCssLexerParserTest.assertEquals((String)this.cajaCssParser.serialize(styleSheet), (String)this.cajaCssParser.serialize(styleSheet2));
    }

    public void testCache() throws Exception {
        this.cajaCssParser.setCacheProvider((CacheProvider)new LruCacheProvider(100));
        List styleSheet = this.cajaCssParser.parse(CSS);
        List styleSheet2 = this.cajaCssParser.parse(CSS);
        CajaCssLexerParserTest.assertFalse((boolean)((Object)styleSheet).equals(styleSheet2));
        CajaCssLexerParserTest.assertEquals((String)this.cajaCssParser.serialize(styleSheet), (String)this.cajaCssParser.serialize(styleSheet2));
    }
}

