/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import junit.framework.TestCase;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.Icon;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;

public class IconTest
extends TestCase {
    public void testBasicIcon() throws Exception {
        String xml = "<Icon type=\"foo\" mode=\"base64\">helloWorld</Icon>";
        Icon icon = new Icon(XmlUtil.parse((String)xml));
        IconTest.assertEquals((String)"foo", (String)icon.getType());
        IconTest.assertEquals((String)"base64", (String)icon.getMode());
        IconTest.assertEquals((String)"helloWorld", (String)icon.getContent());
    }

    public void testInvalidMode() throws Exception {
        String xml = "<Icon type=\"foo\" mode=\"broken\"/>";
        try {
            new Icon(XmlUtil.parse((String)xml));
            IconTest.fail((String)"No exception thrown when an invalid mode attribute is passed.");
        }
        catch (SpecParserException specParserException) {
            // empty catch block
        }
    }

    public void testSubstitutions() throws Exception {
        String xml = "<Icon>http://__MSG_domain__/icon.png</Icon>";
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "domain", "example.org");
        Icon icon = new Icon(XmlUtil.parse((String)xml)).substitute(substituter);
        IconTest.assertEquals((String)"http://example.org/icon.png", (String)icon.getContent());
    }
}

