/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;

public class MessageBundleTest {
    private static final Uri BUNDLE_URL = Uri.parse((String)"http://example.org/m.xml");
    private static final String LOCALE = "<Locale lang='en' country='US' messages='" + BUNDLE_URL + "'/>";
    private static final String PARENT_LOCALE = "<Locale lang='en' country='ALL' language_direction='rtl'> <msg name='one'>VALUE</msg> <msg name='foo'>adfdfdf</msg></Locale>";
    private static final Map<String, String> MESSAGES = Maps.newHashMap();
    private static final String XML;
    private LocaleSpec locale;

    @Before
    public void setUp() throws Exception {
        this.locale = new LocaleSpec(XmlUtil.parse((String)LOCALE), Uri.parse((String)"http://example.org/gadget"));
    }

    @Test
    public void normalMessageBundleParsesOk() throws Exception {
        MessageBundle bundle = new MessageBundle(this.locale, XML);
        Assert.assertEquals(MESSAGES, (Object)bundle.getMessages());
    }

    @Test
    public void duplicateKeyIgnored() throws Exception {
        String duplicateKeyXml = "<messagebundle>  <msg name='key'>value</msg>  <msg name='key'>value</msg></messagebundle>";
        MessageBundle bundle = new MessageBundle(this.locale, duplicateKeyXml);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"key", (Object)"value"), (Object)bundle.getMessages());
    }

    @Test
    public void containsCdataSection() throws Exception {
        String cdataXml = "<messagebundle>  <msg name='key'><![CDATA[<span id='foo'>data</span>]]></msg></messagebundle>";
        MessageBundle bundle = new MessageBundle(this.locale, cdataXml);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"key", (Object)"<span id='foo'>data</span>"), (Object)bundle.getMessages());
    }

    @Test(expected=SpecParserException.class)
    public void missingNameThrows() throws SpecParserException {
        String xml = "<messagebundle><msg>foo</msg></messagebundle>";
        new MessageBundle(this.locale, xml);
    }

    @Test(expected=SpecParserException.class)
    public void malformedXmlThrows() throws SpecParserException {
        String xml = "</messagebundle>";
        new MessageBundle(this.locale, xml);
    }

    @Test
    public void extractFromElement() throws Exception {
        Element element = XmlUtil.parse((String)XML);
        MessageBundle bundle = new MessageBundle(element);
        Assert.assertEquals(MESSAGES, (Object)bundle.getMessages());
    }

    @Test
    public void extractFromElementWithLanguageDir() throws Exception {
        Element element = XmlUtil.parse((String)PARENT_LOCALE);
        MessageBundle bundle = new MessageBundle(element);
        Assert.assertEquals((Object)"rtl", (Object)bundle.getLanguageDirection());
    }

    @Test(expected=SpecParserException.class)
    public void extractFromElementsWithNoName() throws Exception {
        String xml = "<messagebundle><msg>foo</msg></messagebundle>";
        Element element = XmlUtil.parse((String)xml);
        new MessageBundle(element);
    }

    @Test
    public void extractNestedTagsVerbatim() throws Exception {
        String xml = "<messagebundle><msg name='key'>This is <x>nested</x> content</msg></messagebundle>";
        Element element = XmlUtil.parse((String)xml);
        MessageBundle bundle = new MessageBundle(element);
        Assert.assertEquals((Object)"This is <x>nested</x> content", bundle.getMessages().get("key"));
    }

    @Test
    public void merge() throws Exception {
        MessageBundle parent = new MessageBundle(XmlUtil.parse((String)PARENT_LOCALE));
        MessageBundle child = new MessageBundle(XmlUtil.parse((String)XML));
        MessageBundle bundle = new MessageBundle(parent, child);
        Assert.assertEquals((Object)"ltr", (Object)bundle.getLanguageDirection());
        Assert.assertEquals((Object)"VALUE", bundle.getMessages().get("one"));
        Assert.assertEquals((Object)"bar", bundle.getMessages().get("foo"));
    }

    @Test
    public void toStringIsSane() throws Exception {
        MessageBundle b0 = new MessageBundle(this.locale, XML);
        MessageBundle b1 = new MessageBundle(this.locale, b0.toString());
        Assert.assertEquals((Object)b0.getMessages(), (Object)b1.getMessages());
    }

    private static void assertJsonEquals(JSONObject left, JSONObject right) throws JSONException {
        Assert.assertEquals((long)left.length(), (long)right.length());
        for (String key : JSONObject.getNames((JSONObject)left)) {
            Assert.assertEquals((Object)left.get(key), (Object)right.get(key));
        }
    }

    @Test
    public void toJSONStringMatchesValues() throws Exception {
        MessageBundle simple = new MessageBundle(XmlUtil.parse((String)PARENT_LOCALE));
        JSONObject fromString = new JSONObject(simple.toJSONString());
        JSONObject fromMap = new JSONObject(simple.getMessages());
        MessageBundleTest.assertJsonEquals(fromString, fromMap);
    }

    @Test
    public void toJSONStringMatchesValuesLocaleCtor() throws Exception {
        MessageBundle bundle = new MessageBundle(this.locale, XML);
        JSONObject fromString = new JSONObject(bundle.toJSONString());
        JSONObject fromMap = new JSONObject(bundle.getMessages());
        MessageBundleTest.assertJsonEquals(fromString, fromMap);
    }

    @Test
    public void toJSONStringMatchesValuesWithChild() throws Exception {
        MessageBundle parent = new MessageBundle(XmlUtil.parse((String)PARENT_LOCALE));
        MessageBundle child = new MessageBundle(XmlUtil.parse((String)XML));
        MessageBundle bundle = new MessageBundle(parent, child);
        JSONObject fromString = new JSONObject(bundle.toJSONString());
        JSONObject fromMap = new JSONObject(bundle.getMessages());
        MessageBundleTest.assertJsonEquals(fromString, fromMap);
    }

    static {
        MESSAGES.put("hello", "world");
        MESSAGES.put("foo", "bar");
        StringBuilder buf = new StringBuilder();
        buf.append("<messagebundle>");
        for (Map.Entry<String, String> entry : MESSAGES.entrySet()) {
            buf.append("<msg name='").append(entry.getKey()).append("'>").append(entry.getValue()).append("</msg>");
        }
        buf.append("</messagebundle>");
        XML = buf.toString();
    }
}

