/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.templates.AbstractTagHandler;
import org.apache.shindig.gadgets.templates.DefaultTagRegistry;
import org.apache.shindig.gadgets.templates.TagHandler;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultTagRegistryTest {
    public static final String TEST_NAMESPACE = "#test";
    public static final String TEST_NAME = "Tag";
    private TagHandler tag;
    private DefaultTagRegistry registry;

    @Before
    public void setUp() {
        this.tag = new AbstractTagHandler(TEST_NAMESPACE, TEST_NAME){

            public void process(Node result, Element tag, TemplateProcessor processor) {
            }
        };
        this.registry = new DefaultTagRegistry((Set)ImmutableSet.of((Object)this.tag));
    }

    @Test
    public void getHandlerForWithElement() {
        Element el = XmlUtil.parseSilent((String)"<Tag xmlns='#test'/>");
        Assert.assertSame((Object)this.tag, (Object)this.registry.getHandlerFor(el));
    }

    @Test
    public void getHandlerForUsesNamespace() {
        Element el = XmlUtil.parseSilent((String)"<Tag xmlns='#nottest'/>");
        Assert.assertNull((Object)this.registry.getHandlerFor(el));
    }

    @Test
    public void getHandlerIsCaseSensitive() {
        Element el = XmlUtil.parseSilent((String)"<tag xmlns='#test'/>");
        Assert.assertNull((Object)this.registry.getHandlerFor(el));
    }

    @Test
    public void getHandlerForWithNSName() {
        TagRegistry.NSName nsName = new TagRegistry.NSName(TEST_NAMESPACE, TEST_NAME);
        Assert.assertSame((Object)this.tag, (Object)this.registry.getHandlerFor(nsName));
    }
}

