/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.templates.MessageELResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageELResolverTest {
    private static final String MESSAGE_BUNDLE = "<messagebundle><msg name='hello'>world</msg><msg name='number'>${1+1}</msg><msg name='concat'>${Msg.hello} ${Msg.number}</msg><msg name='multiLevel'>${Msg.concat} ${Msg.concat}</msg><msg name='recurse'>${Msg.recurse}</msg><msg name='mutual1'>${Msg.mutual2}</msg><msg name='mutual2'>${Msg.mutual1}</msg></messagebundle>";
    private MessageBundle messageBundle;
    private Expressions expressions;
    private ELContext context;

    @Before
    public void setUp() throws Exception {
        this.messageBundle = new MessageBundle(XmlUtil.parse((String)MESSAGE_BUNDLE));
        this.expressions = Expressions.forTesting();
        this.context = this.expressions.newELContext(new ELResolver[]{new MessageELResolver(this.expressions, this.messageBundle)});
    }

    @Test
    public void basicExpression() {
        Assert.assertEquals((Object)"world", (Object)this.expressions.parse("${Msg.hello}", String.class).getValue(this.context));
    }

    @Test
    public void nullForMissingProperty() {
        Assert.assertNull((Object)this.expressions.parse("${Msg.notThere}", Object.class).getValue(this.context));
    }

    @Test
    public void innerEvaluation() {
        Assert.assertEquals((Object)2, (Object)this.expressions.parse("${Msg.number}", Integer.class).getValue(this.context));
    }

    @Test
    public void recursiveEvaluation() {
        Assert.assertEquals((Object)"world 2", (Object)this.expressions.parse("${Msg.concat}", String.class).getValue(this.context));
    }

    @Test
    public void multiLevelRecursiveEvaluation() {
        Assert.assertEquals((Object)"world 2 world 2", (Object)this.expressions.parse("${Msg.multiLevel}", String.class).getValue(this.context));
    }

    @Test(expected=ELException.class)
    public void failsInsteadOfInfiniteRecursion() {
        this.expressions.parse("${Msg.recurse}", String.class).getValue(this.context);
    }

    @Test(expected=ELException.class)
    public void failsInsteadOfMutualInfiniteRecursion() {
        this.expressions.parse("${Msg.mutual1}", String.class).getValue(this.context);
    }
}

