/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.config;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.config.ConfigContributor;
import org.apache.shindig.gadgets.render.RpcServiceLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class OsapiServicesConfigContributor
implements ConfigContributor {
    protected final RpcServiceLookup rpcServiceLookup;

    @Inject
    public OsapiServicesConfigContributor(RpcServiceLookup rpcServiceLookup) {
        this.rpcServiceLookup = rpcServiceLookup;
    }

    @Override
    public void contribute(Map<String, Object> config, Gadget gadget) {
        GadgetContext ctx = gadget.getContext();
        this.addServicesConfig(config, ctx.getContainer(), ctx.getHost());
    }

    @Override
    public void contribute(Map<String, Object> config, String container, String host) {
        this.addServicesConfig(config, container, host);
    }

    private void addServicesConfig(Map<String, Object> config, String container, String host) {
        if (this.rpcServiceLookup != null) {
            Multimap<String, String> endpoints = this.rpcServiceLookup.getServicesFor(container, host);
            config.put("osapi.services", endpoints);
        }
    }
}

