/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.ConcatUriManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatVisitor
implements DomWalker.Visitor {
    private final ConcatUriManager uriManager;
    private final ConcatUriManager.Type type;
    private final ContentRewriterFeature.Config config;
    private final boolean split;

    private ConcatVisitor(ContentRewriterFeature.Config config, ConcatUriManager uriManager, ConcatUriManager.Type type) {
        this.uriManager = uriManager;
        this.type = type;
        this.config = config;
        this.split = type == ConcatUriManager.Type.JS && config.isSplitJsEnabled();
    }

    @Override
    public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
        if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase(this.type.getTagName())) {
            return DomWalker.Visitor.VisitStatus.BYPASS;
        }
        Element element = (Element)node;
        if (this.isRewritableExternData(element) && (this.split || this.isRewritableExternData(this.getSibling(element, true)) || this.isRewritableExternData(this.getSibling(element, false)))) {
            return DomWalker.Visitor.VisitStatus.RESERVE_NODE;
        }
        return DomWalker.Visitor.VisitStatus.BYPASS;
    }

    @Override
    public boolean revisit(Gadget gadget, List<Node> nodes) throws RewritingException {
        LinkedList concatBuckets = Lists.newLinkedList();
        LinkedList curBucket = Lists.newLinkedList();
        Iterator<Node> nodeIter = nodes.iterator();
        Element cur = (Element)nodeIter.next();
        curBucket.add(cur);
        while (nodeIter.hasNext()) {
            Element next = (Element)nodeIter.next();
            if (!this.split && cur != this.getSibling(next, true) || this.type == ConcatUriManager.Type.CSS && !this.areLinkNodesBucketable(cur, next)) {
                concatBuckets.add(curBucket);
                curBucket = Lists.newLinkedList();
            }
            curBucket.add(next);
            cur = next;
        }
        concatBuckets.add(curBucket);
        LinkedList concatBatches = Lists.newLinkedList();
        Iterator batchesIter = concatBuckets.iterator();
        while (batchesIter.hasNext()) {
            this.splitBatchOnMedia((List)batchesIter.next(), concatBatches);
        }
        LinkedList uriBatches = Lists.newLinkedList();
        batchesIter = concatBatches.iterator();
        while (batchesIter.hasNext()) {
            List batch = (List)batchesIter.next();
            LinkedList uris = Lists.newLinkedList();
            if (batch.isEmpty() || !this.getUris(this.type, batch, uris)) {
                batchesIter.remove();
                continue;
            }
            uriBatches.add(uris);
        }
        if (uriBatches.isEmpty()) {
            return false;
        }
        List<ConcatUriManager.ConcatData> concatUris = this.uriManager.make(ConcatUriManager.ConcatUri.fromList(gadget, uriBatches, this.type), !this.split);
        Iterator elemBatchIt = concatBatches.iterator();
        Iterator uriBatchIt = uriBatches.iterator();
        for (ConcatUriManager.ConcatData concatUri : concatUris) {
            List sourceBatch = (List)elemBatchIt.next();
            List sourceUris = (List)uriBatchIt.next();
            Element firstElem = (Element)sourceBatch.get(0);
            Element elemConcat = (Element)firstElem.cloneNode(true);
            elemConcat.setAttribute(this.type.getSrcAttrib(), concatUri.getUri().toString());
            firstElem.getParentNode().insertBefore(elemConcat, firstElem);
            Iterator uriIt = sourceUris.iterator();
            for (Element elem : sourceBatch) {
                Uri elemOrigUri = (Uri)uriIt.next();
                String snippet = concatUri.getSnippet(elemOrigUri);
                if (!StringUtils.isEmpty((String)snippet)) {
                    Element scriptNode = elem.getOwnerDocument().createElement("script");
                    scriptNode.setTextContent(snippet);
                    elem.getParentNode().insertBefore(scriptNode, elem);
                }
                elem.getParentNode().removeChild(elem);
            }
        }
        return true;
    }

    private void splitBatchOnMedia(List<Element> elements, List<List<Element>> output) {
        LinkedHashMultimap mediaBatchMap = LinkedHashMultimap.create();
        for (Element element : elements) {
            String mediaType = element.getAttribute("media");
            mediaBatchMap.put((Object)(StringUtils.isEmpty((String)mediaType) ? "screen" : mediaType), (Object)element);
        }
        Set mediaTypes = mediaBatchMap.keySet();
        for (String mediaType : mediaTypes) {
            Collection elems = mediaBatchMap.get((Object)mediaType);
            output.add(new LinkedList(elems));
        }
    }

    private boolean isRewritableExternData(Element elem) {
        String uriStr;
        String string = uriStr = elem != null ? elem.getAttribute(this.type.getSrcAttrib()) : null;
        if (StringUtils.isEmpty(uriStr) || !this.config.shouldRewriteURL(uriStr)) {
            return false;
        }
        if (this.type == ConcatUriManager.Type.CSS) {
            return "stylesheet".equalsIgnoreCase(elem.getAttribute("rel")) && "text/css".equalsIgnoreCase(elem.getAttribute("type"));
        }
        return true;
    }

    private Element getSibling(Element root, boolean isPrev) {
        Node cur = root;
        while ((cur = this.getNext(cur, isPrev)) != null && (cur.getNodeType() == 3 || cur.getNodeType() == 8 && !this.isConditionalComment(cur))) {
        }
        if (cur != null && cur.getNodeType() == 1) {
            return (Element)cur;
        }
        return null;
    }

    private Node getNext(Node node, boolean isPrev) {
        return isPrev ? node.getPreviousSibling() : node.getNextSibling();
    }

    private boolean getUris(ConcatUriManager.Type type, List<Element> elems, List<Uri> uris) {
        for (Element elem : elems) {
            String uriStr = elem.getAttribute(type.getSrcAttrib());
            try {
                uris.add(Uri.parse((String)uriStr));
            }
            catch (Uri.UriException e) {
                return false;
            }
        }
        return true;
    }

    private boolean areLinkNodesBucketable(Element current, Element next) {
        boolean areLinkNodesCompatible = false;
        String currMediaType = current.getAttribute("media");
        String nextMediaType = next.getAttribute("media");
        if ("all".equalsIgnoreCase(currMediaType) && "all".equalsIgnoreCase(nextMediaType) || !"all".equalsIgnoreCase(currMediaType) && !"all".equalsIgnoreCase(nextMediaType)) {
            areLinkNodesCompatible = true;
        }
        return areLinkNodesCompatible && current.getAttribute("title").equals(next.getAttribute("title"));
    }

    private boolean isConditionalComment(Node node) {
        return node.getNodeValue().trim().startsWith("[if");
    }

    public static class Css
    extends ConcatVisitor {
        public Css(ContentRewriterFeature.Config config, ConcatUriManager uriManager) {
            super(config, uriManager, ConcatUriManager.Type.CSS);
        }
    }

    public static class Js
    extends ConcatVisitor {
        public Js(ContentRewriterFeature.Config config, ConcatUriManager uriManager) {
            super(config, uriManager, ConcatUriManager.Type.JS);
        }
    }
}

