/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.concurrent.ExecutorService;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.common.cache.SoftExpiringCache;
import org.apache.shindig.common.testing.TestExecutorService;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.DefaultGadgetSpecFactory;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DefaultGadgetSpecFactoryTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final String LOCAL_CONTENT = "Hello, local content!";
    private static final String ALT_LOCAL_CONTENT = "Hello, local content!";
    private static final String RAWXML_CONTENT = "Hello, rawxml content!";
    private static final String LOCAL_SPEC_XML = "<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>";
    private static final String ALT_LOCAL_SPEC_XML = "<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>";
    private static final String RAWXML_SPEC_XML = "<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, rawxml content!</Content></Module>";
    private static final GadgetContext RAWXML_GADGET_CONTEXT = new GadgetContext(){

        public boolean getIgnoreCache() {
            return false;
        }

        public Uri getUrl() {
            return SPEC_URL;
        }

        public String getParameter(String param) {
            if (param.equals("rawxml")) {
                return DefaultGadgetSpecFactoryTest.RAWXML_SPEC_XML;
            }
            return null;
        }
    };
    private static final int MAX_AGE = 10000;
    private final CountingExecutor executor = new CountingExecutor();
    private final RequestPipeline pipeline = (RequestPipeline)EasyMock.createNiceMock(RequestPipeline.class);
    private final CacheProvider cacheProvider = new LruCacheProvider(5);
    private final DefaultGadgetSpecFactory specFactory = new DefaultGadgetSpecFactory((ExecutorService)((Object)this.executor), this.pipeline, this.cacheProvider, 10000L);

    private static HttpRequest createIgnoreCacheRequest() {
        return new HttpRequest(SPEC_URL).setIgnoreCache(true).setGadget(SPEC_URL).setContainer("default");
    }

    private static HttpRequest createCacheableRequest() {
        return new HttpRequest(SPEC_URL).setGadget(SPEC_URL).setContainer("default");
    }

    private static GadgetContext createContext(final Uri uri, final boolean ignoreCache) {
        return new GadgetContext(){

            public Uri getUrl() {
                return uri;
            }

            public boolean getIgnoreCache() {
                return ignoreCache;
            }
        };
    }

    @Test
    public void specFetched() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        HttpResponse response = new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        GadgetSpec spec = this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
    }

    @Test
    public void specFetchedWithBom() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        HttpResponse response = new HttpResponse("&#xFEFF;<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        GadgetSpec spec = this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
    }

    @Test(expected=GadgetException.class)
    public void specFetchedEmptyContent() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        HttpResponse response = new HttpResponse("");
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
    }

    @Test(expected=GadgetException.class)
    public void malformedGadgetSpecIsCachedAndThrows2() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)new HttpResponse("")).once();
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
    }

    @Test
    public void specFetchedWithBomChar() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        HttpResponse response = new HttpResponse("\ufeff<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        GadgetSpec spec = this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
    }

    @Test
    public void specRefetchedAsync() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createCacheableRequest();
        HttpResponse response = new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.specFactory.cache.addElement((Object)SPEC_URL, (Object)new GadgetSpec(SPEC_URL, "<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>"), -1L);
        GadgetSpec spec = this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, false));
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
        spec = this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, false));
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
        Assert.assertEquals((long)1L, (long)this.executor.runnableCount);
    }

    @Test
    public void specFetchedFromParam() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        HttpResponse response = new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        GadgetSpec spec = this.specFactory.getGadgetSpec(RAWXML_GADGET_CONTEXT);
        Assert.assertEquals((Object)RAWXML_CONTENT, (Object)spec.getView("default").getContent());
        Assert.assertEquals((Object)DefaultGadgetSpecFactory.RAW_GADGET_URI, (Object)spec.getUrl());
    }

    @Test
    public void staleSpecIsRefetched() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        HttpRequest retriedRequest = DefaultGadgetSpecFactoryTest.createCacheableRequest();
        HttpResponse expiredResponse = new HttpResponseBuilder().addHeader("Pragma", "no-cache").setResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>".getBytes("UTF-8")).create();
        HttpResponse updatedResponse = new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)expiredResponse).once();
        EasyMock.expect((Object)this.pipeline.execute(retriedRequest)).andReturn((Object)updatedResponse).once();
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
        SoftExpiringCache.CachedObject inCache = this.specFactory.cache.getElement((Object)SPEC_URL);
        this.specFactory.cache.addElement((Object)SPEC_URL, inCache.obj, -1L);
        GadgetSpec spec = this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, false));
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
    }

    @Test
    public void staleSpecReturnedFromCacheOnError() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        HttpRequest retriedRequest = DefaultGadgetSpecFactoryTest.createCacheableRequest();
        HttpResponse expiredResponse = new HttpResponseBuilder().setResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>".getBytes("UTF-8")).addHeader("Pragma", "no-cache").create();
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)expiredResponse);
        EasyMock.expect((Object)this.pipeline.execute(retriedRequest)).andReturn((Object)HttpResponse.notFound()).once();
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
        SoftExpiringCache.CachedObject inCache = this.specFactory.cache.getElement((Object)SPEC_URL);
        this.specFactory.cache.addElement((Object)SPEC_URL, inCache.obj, -1L);
        GadgetSpec spec = this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, false));
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
    }

    @Test
    public void ttlPropagatesToPipeline() throws Exception {
        CapturingPipeline capturingPipeline = new CapturingPipeline();
        DefaultGadgetSpecFactory forcedCacheFactory = new DefaultGadgetSpecFactory((ExecutorService)new TestExecutorService(), (RequestPipeline)capturingPipeline, this.cacheProvider, 10000L);
        forcedCacheFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, false));
        Assert.assertEquals((long)10L, (long)capturingPipeline.request.getCacheTtl());
    }

    @Test(expected=GadgetException.class)
    public void badFetchThrows() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)HttpResponse.error());
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
    }

    public void badFetchThrowsExceptionOverridingCache() throws Exception {
        HttpRequest firstRequest = DefaultGadgetSpecFactoryTest.createCacheableRequest();
        EasyMock.expect((Object)this.pipeline.execute(firstRequest)).andReturn((Object)new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>")).times(2);
        HttpRequest secondRequest = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        EasyMock.expect((Object)this.pipeline.execute(secondRequest)).andReturn((Object)HttpResponse.error()).once();
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, false));
        try {
            this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, false));
    }

    @Test(expected=GadgetException.class)
    public void malformedGadgetSpecThrows() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)new HttpResponse("malformed junk"));
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
    }

    @Test(expected=GadgetException.class)
    public void malformedGadgetSpecIsCachedAndThrows() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createCacheableRequest();
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)new HttpResponse("malformed junk")).once();
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, false));
    }

    @Test(expected=GadgetException.class)
    public void throwingPipelineRethrows() throws Exception {
        HttpRequest request = DefaultGadgetSpecFactoryTest.createIgnoreCacheRequest();
        EasyMock.expect((Object)this.pipeline.execute(request)).andThrow((Throwable)new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT));
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, true));
    }

    @Test(expected=SpecParserException.class)
    public void negativeCachingEnforced() throws Exception {
        this.specFactory.cache.addElement((Object)SPEC_URL, (Object)new SpecParserException("broken"), 1000L);
        this.specFactory.getGadgetSpec(DefaultGadgetSpecFactoryTest.createContext(SPEC_URL, false));
    }

    private static class CapturingPipeline
    implements RequestPipeline {
        HttpRequest request;

        private CapturingPipeline() {
        }

        public HttpResponse execute(HttpRequest request) {
            this.request = request;
            return new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        }
    }

    private static class CountingExecutor
    extends TestExecutorService {
        int runnableCount = 0;

        private CountingExecutor() {
        }

        public void execute(Runnable r) {
            ++this.runnableCount;
            r.run();
        }
    }
}

