/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.junit.Assert;
import org.junit.Test;

public class HttpRequestTest {
    private static final String POST_BODY = "Hello, world!";
    private static final String CONTENT_TYPE = "text/plain";
    private static final String TEST_HEADER_KEY = "X-Test-Header";
    private static final String TEST_HEADER_VALUE = "Hello!";
    private static final String TEST_HEADER_VALUE2 = "Goodbye.";
    private static final Uri DEFAULT_URI = Uri.parse((String)"http://example.org/");

    @Test
    public void dosPreventionHeaderAdded() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        Assert.assertNotNull((String)"DoS prevention header not present in request.", (Object)request.getHeader("X-shindig-dos"));
    }

    @Test
    public void postBodyCopied() throws Exception {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setPostBody(POST_BODY.getBytes());
        Assert.assertEquals((long)POST_BODY.length(), (long)request.getPostBodyLength());
        Assert.assertEquals((Object)POST_BODY, (Object)IOUtils.toString((InputStream)request.getPostBody(), (String)"UTF-8"));
        Assert.assertEquals((Object)POST_BODY, (Object)request.getPostBodyAsString());
    }

    @Test
    public void contentTypeExtraction() throws Exception {
        HttpRequest request = new HttpRequest(DEFAULT_URI).addHeader("Content-Type", CONTENT_TYPE);
        Assert.assertEquals((Object)CONTENT_TYPE, (Object)request.getContentType());
    }

    @Test
    public void getHeader() throws Exception {
        HashMap headers = Maps.newHashMap();
        headers.put(TEST_HEADER_KEY, Arrays.asList(TEST_HEADER_VALUE));
        HttpRequest request = new HttpRequest(DEFAULT_URI).addHeader(TEST_HEADER_KEY, TEST_HEADER_VALUE);
        Assert.assertEquals((Object)TEST_HEADER_VALUE, (Object)request.getHeader(TEST_HEADER_KEY));
    }

    @Test
    public void getHeaders() throws Exception {
        HttpRequest request = new HttpRequest(DEFAULT_URI).addHeader(TEST_HEADER_KEY, TEST_HEADER_VALUE).addHeader(TEST_HEADER_KEY, TEST_HEADER_VALUE2);
        List<String> expected = Arrays.asList(TEST_HEADER_VALUE, TEST_HEADER_VALUE2);
        Assert.assertTrue((boolean)request.getHeaders(TEST_HEADER_KEY).containsAll(expected));
    }

    @Test
    public void ignoreCacheAddsPragmaHeader() throws Exception {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setIgnoreCache(true);
        Assert.assertTrue((String)"Pragma: no-cache not added when ignoreCache == true", (boolean)request.getHeaders("Pragma").contains("no-cache"));
    }

    @Test
    public void testDefaultIsFollowRedirects() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        Assert.assertTrue((boolean)request.getFollowRedirects());
    }

    @Test
    public void copyCtorCopiesAllFields() {
        OAuthArguments oauthArguments = new OAuthArguments();
        oauthArguments.setSignOwner(false);
        oauthArguments.setSignViewer(true);
        HttpRequest request = new HttpRequest(DEFAULT_URI).setCacheTtl(100).addHeader(TEST_HEADER_KEY, TEST_HEADER_VALUE).setContainer("container").setGadget(DEFAULT_URI).setMethod("POST").setPostBody(POST_BODY.getBytes()).setRewriteMimeType("text/fake").setSecurityToken((SecurityToken)new AnonymousSecurityToken()).setOAuthArguments(oauthArguments).setAuthType(AuthType.OAUTH).setFollowRedirects(false);
        HttpRequest request2 = new HttpRequest(request).setUri(Uri.parse((String)"http://example.org/foo"));
        Assert.assertEquals((long)request.getCacheTtl(), (long)request2.getCacheTtl());
        Assert.assertEquals((Object)request.getHeaders(), (Object)request2.getHeaders());
        Assert.assertEquals((Object)request.getContainer(), (Object)request2.getContainer());
        Assert.assertEquals((Object)request.getGadget(), (Object)request2.getGadget());
        Assert.assertEquals((Object)request.getMethod(), (Object)request2.getMethod());
        Assert.assertEquals((Object)request.getPostBodyAsString(), (Object)request2.getPostBodyAsString());
        Assert.assertEquals((Object)request.getRewriteMimeType(), (Object)request2.getRewriteMimeType());
        Assert.assertEquals((Object)request.getSecurityToken(), (Object)request2.getSecurityToken());
        Assert.assertEquals((Object)request.getOAuthArguments().getSignOwner(), (Object)request2.getOAuthArguments().getSignOwner());
        Assert.assertEquals((Object)request.getOAuthArguments().getSignViewer(), (Object)request2.getOAuthArguments().getSignViewer());
        Assert.assertEquals((Object)AuthType.OAUTH, (Object)request.getAuthType());
        Assert.assertFalse((boolean)request.getFollowRedirects());
    }
}

