/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import name.fraser.neil.plaintext.diff_match_patch;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.junit.Assert;
import org.w3c.dom.Document;

public abstract class AbstractParsingTestBase {
    private static final String EOL = System.getProperty("line.separator");

    protected String loadFile(String path) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        return IOUtils.toString((InputStream)is);
    }

    protected void parseAndCompareBalanced(String content, String expected, GadgetHtmlParser parser) throws Exception {
        Document document = parser.parseDom(content);
        expected = expected.replace(EOL, "\n");
        String serialized = HtmlSerialization.serialize((Document)document);
        this.assertHtmlEquals(expected, serialized);
    }

    private void assertHtmlEquals(String expected, String serialized) {
        diff_match_patch dmp = new diff_match_patch();
        LinkedList diffs = dmp.diff_main(expected, serialized);
        while (!diffs.isEmpty()) {
            diff_match_patch.Diff cur = (diff_match_patch.Diff)diffs.removeFirst();
            switch (cur.operation) {
                case DELETE: {
                    if (StringUtils.isBlank((String)cur.text) || "amp;".equalsIgnoreCase(cur.text)) break;
                    if (diffs.isEmpty()) {
                        Assert.assertEquals((Object)expected, (Object)serialized);
                    }
                    diff_match_patch.Diff next = (diff_match_patch.Diff)diffs.removeFirst();
                    if (next.operation != diff_match_patch.Operation.INSERT) {
                        Assert.assertEquals((Object)expected, (Object)serialized);
                    }
                    if (this.equivalentEntities(cur.text, next.text) || cur.text.equalsIgnoreCase(next.text)) break;
                    Assert.assertEquals((Object)expected, (Object)serialized);
                    break;
                }
                case INSERT: {
                    if (StringUtils.isBlank((String)cur.text) || "amp;".equalsIgnoreCase(cur.text)) break;
                    Assert.assertEquals((Object)expected, (Object)serialized);
                    break;
                }
            }
        }
    }

    private boolean equivalentEntities(String prev, String cur) {
        if (!prev.endsWith(";") && !cur.endsWith(";")) {
            return false;
        }
        String prevEnt = StringEscapeUtils.unescapeHtml((String)prev);
        String curEnt = StringEscapeUtils.unescapeHtml((String)cur);
        return prevEnt.equals(curEnt);
    }
}

