/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.caja.CajaHtmlParser;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ParseTreeSerializerBenchmark {
    private int numRuns;
    private String content;
    private GadgetHtmlParser nekoSimpleParser = new NekoSimplifiedHtmlParser(DOCUMENT_PROVIDER);
    private GadgetHtmlParser cajaParser = new CajaHtmlParser(DOCUMENT_PROVIDER);
    private boolean warmup;
    private static final DOMImplementation DOCUMENT_PROVIDER = new ParseModule.DOMImplementationProvider().get();

    private ParseTreeSerializerBenchmark(String file, int numRuns) throws Exception {
        File inputFile = new File(file);
        if (!inputFile.exists() || !inputFile.canRead()) {
            System.err.println("Input file: " + file + " not found or can't be read.");
            System.exit(1);
        }
        this.content = new String(IOUtils.toByteArray((InputStream)new FileInputStream(file)));
        this.numRuns = 10;
        this.warmup = true;
        this.runCaja();
        this.runNekoSimple();
        Thread.sleep(10000L);
        this.numRuns = numRuns;
        this.warmup = false;
        this.runCaja();
        this.runNekoSimple();
    }

    private void runNekoSimple() throws Exception {
        this.output("NekoSimple-----------------");
        this.timeParseDom(this.nekoSimpleParser);
        this.timeParseDomSerialize(this.nekoSimpleParser);
    }

    private void runCaja() throws Exception {
        this.output("Caja-----------------");
        this.timeParseDom(this.cajaParser);
        this.timeParseDomSerialize(this.cajaParser);
    }

    private void output(String string) {
        if (!this.warmup) {
            System.out.println(string);
        }
    }

    private void timeParseDom(GadgetHtmlParser parser) throws GadgetException {
        long parseStart = System.currentTimeMillis();
        for (int i = 0; i < this.numRuns; ++i) {
            parser.parseDom(this.content);
        }
        long parseMillis = System.currentTimeMillis() - parseStart;
        this.output("Parsing W3C DOM [" + parseMillis + " ms total: " + (double)parseMillis / (double)this.numRuns + "ms/run]");
    }

    private void timeParseDomSerialize(GadgetHtmlParser parser) throws GadgetException {
        Document document = parser.parseDom(this.content);
        try {
            long parseStart = System.currentTimeMillis();
            for (int i = 0; i < this.numRuns; ++i) {
                HtmlSerialization.serialize((Document)document);
            }
            long parseMillis = System.currentTimeMillis() - parseStart;
            this.output("Serializing [" + parseMillis + " ms total: " + (double)parseMillis / (double)this.numRuns + "ms/run]");
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, (Throwable)e);
        }
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("method", "html");
            long parseStart = System.currentTimeMillis();
            for (int i = 0; i < this.numRuns; ++i) {
                StringWriter sw = new StringWriter(this.content.length() * 11 / 10);
                t.transform(new DOMSource(document), new StreamResult(sw));
                sw.toString();
            }
            long parseMillis = System.currentTimeMillis() - parseStart;
            this.output("Serializing DOM Transformer [" + parseMillis + " ms total: " + (double)parseMillis / (double)this.numRuns + "ms/run]");
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, (Throwable)e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Args: <input-file> <num-runs>");
            System.exit(1);
        }
        String fileArg = args[0];
        String runsArg = args[1];
        int numRuns = -1;
        try {
            numRuns = Integer.parseInt(runsArg);
        }
        catch (Exception e) {
            System.err.println("Invalid num-runs argument: " + runsArg + ", reason: " + e);
        }
        try {
            new ParseTreeSerializerBenchmark(fileArg, numRuns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

