/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.caja.util.Join;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.common.JsonAssert;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.config.CoreUtilConfigContributor;
import org.apache.shindig.gadgets.config.XhrwrapperConfigContributor;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.render.FakeMessageBundleFactory;
import org.apache.shindig.gadgets.render.RenderingGadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingGadgetRewriterTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final String BODY_CONTENT = "Some body content";
    static final Pattern DOCUMENT_SPLIT_PATTERN = Pattern.compile("(.*)<head>(.*?)<\\/head>(?:.*)<body(.*?)>(.*?)<\\/body>(?:.*)", 34);
    static final int BEFORE_HEAD_GROUP = 1;
    static final int HEAD_GROUP = 2;
    static final int BODY_ATTRIBUTES_GROUP = 3;
    static final int BODY_GROUP = 4;
    private final FakeMessageBundleFactory messageBundleFactory = new FakeMessageBundleFactory();
    private final FakeContainerConfig config = new FakeContainerConfig();
    private final JsUriManager jsUriManager = new FakeJsUriManager();
    private final MapGadgetContext context = new MapGadgetContext();
    private FeatureRegistry featureRegistry;
    private RenderingGadgetRewriter rewriter;
    private GadgetHtmlParser parser;

    @Before
    public void setUp() throws Exception {
        this.featureRegistry = (FeatureRegistry)EasyMock.createMock(FeatureRegistry.class);
        ImmutableMap configContributors = ImmutableMap.of((Object)"core.util", (Object)new CoreUtilConfigContributor(this.featureRegistry), (Object)"shindig.xhrwrapper", (Object)new XhrwrapperConfigContributor());
        this.rewriter = new RenderingGadgetRewriter((MessageBundleFactory)this.messageBundleFactory, (ContainerConfig)this.config, this.featureRegistry, this.jsUriManager, (Map)configContributors);
        Injector injector = Guice.createInjector((Module[])new Module[]{new ParseModule(), new PropertiesModule()});
        this.parser = (GadgetHtmlParser)injector.getInstance(GadgetHtmlParser.class);
    }

    private Gadget makeGadgetWithSpec(String gadgetXml) throws GadgetException {
        GadgetSpec spec = new GadgetSpec(SPEC_URL, gadgetXml);
        Gadget gadget = new Gadget().setContext((GadgetContext)this.context).setPreloads((Collection)ImmutableList.of()).setSpec(spec).setGadgetFeatureRegistry(this.featureRegistry);
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), (List<FeatureResource>)ImmutableList.of());
        return gadget;
    }

    private Gadget makeDefaultGadget() throws GadgetException {
        String defaultXml = "<Module><ModulePrefs title=''/><Content type='html'/></Module>";
        return this.makeGadgetWithSpec(defaultXml);
    }

    private String rewrite(Gadget gadget, String content) throws Exception {
        MutableContent mc = new MutableContent(this.parser, content);
        this.rewriter.rewrite(gadget, mc);
        return mc.getContent();
    }

    @Test
    public void defaultOutput() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(rewritten);
        Assert.assertTrue((String)"Output is not valid HTML.", (boolean)matcher.matches());
        Assert.assertTrue((String)"Missing opening html tag", (boolean)matcher.group(1).toLowerCase().contains("<html>"));
        Assert.assertTrue((String)"Default CSS missing.", (boolean)matcher.group(2).contains("body,td,div,span,p{font-family:arial,sans-serif;}a {color:#0000cc;}a:visited {color:#551a8b;}a:active {color:#ff0000;}body{margin: 0px;padding: 0px;background-color:white;}"));
        Assert.assertTrue((String)"Default javascript not included.", (boolean)matcher.group(2).contains("<script>"));
        Assert.assertTrue((String)"Original document not preserved.", (boolean)matcher.group(4).contains(BODY_CONTENT));
        Assert.assertTrue((String)"gadgets.util.runOnLoadHandlers not invoked.", (boolean)matcher.group(4).contains("gadgets.util.runOnLoadHandlers();"));
    }

    @Test
    public void completeDocument() throws Exception {
        String docType = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
        String head = "<script src=\"foo.js\"></script><style type=\"text/css\">body{color:red;}</style>";
        String bodyAttr = " onload=\"foo();\"";
        String body = "hello, world.";
        String doc = docType + "<html><head>" + head + "</head><body" + bodyAttr + '>' + body + "</body></html>";
        GadgetContext context = new GadgetContext(){

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return "foo";
                }
                return null;
            }
        };
        Gadget gadget = this.makeDefaultGadget().setContext(context);
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"foo"), (List<FeatureResource>)ImmutableList.of((Object)this.inline("blah", "n/a")));
        String rewritten = this.rewrite(gadget, doc);
        Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(rewritten);
        Assert.assertTrue((String)"Output is not valid HTML.", (boolean)matcher.matches());
        Assert.assertTrue((String)"DOCTYPE not preserved", (boolean)matcher.group(1).contains(docType));
        Assert.assertTrue((String)"Missing opening html tag", (boolean)matcher.group(1).contains("<html>"));
        Assert.assertTrue((String)"IsGadget beacon not included.", (boolean)matcher.group(2).contains("<script>window['__isgadget']=true;</script>"));
        Assert.assertTrue((String)"Forced javascript not included.", (boolean)matcher.group(2).contains("<script src=\"/js/foo\">"));
        Assert.assertFalse((String)"Default styling was injected when a doctype was specified.", (boolean)matcher.group(2).contains("body,td,div,span,p{font-family:arial,sans-serif;}a {color:#0000cc;}a:visited {color:#551a8b;}a:active {color:#ff0000;}body{margin: 0px;padding: 0px;background-color:white;}"));
        Assert.assertTrue((String)"Custom body attributes missing.", (boolean)matcher.group(3).contains(bodyAttr));
        Assert.assertTrue((String)"Original document not preserved.", (boolean)matcher.group(4).contains(body));
        Assert.assertTrue((String)"gadgets.util.runOnLoadHandlers not invoked.", (boolean)matcher.group(4).contains("gadgets.util.runOnLoadHandlers();"));
    }

    @Test
    public void bidiSettings() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Locale language_direction='rtl'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        String rewritten = this.rewrite(gadget, "");
        Assert.assertTrue((String)"Bi-directional locale settings not preserved.", (boolean)rewritten.contains("<body dir=\"rtl\">"));
    }

    private Set<String> getInjectedScript(String content) {
        Pattern featurePattern = Pattern.compile("(?:.*)<script src=\"\\/js\\/(.*?)\"><\\/script>(?:.*)", 32);
        Matcher matcher = featurePattern.matcher(content);
        Assert.assertTrue((String)"Forced scripts not injected.", (boolean)matcher.matches());
        return Sets.newHashSet((Object[])matcher.group(1).split(":"));
    }

    @Test
    public void forcedFeaturesInjectedExternal() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        ImmutableSortedSet libs = ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"bar"), (Comparable)((Object)"baz"));
        GadgetContext context = new GadgetContext((Set)libs){
            final /* synthetic */ Set val$libs;
            {
                this.val$libs = set;
            }

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return Join.join((CharSequence)":", (Iterable)this.val$libs);
                }
                return null;
            }
        };
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml).setContext(context);
        FeatureResource fooResource = this.inline("foo-content", "foo-debug");
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of((Object)fooResource), (Set<String>)libs, (List<FeatureResource>)ImmutableList.of((Object)fooResource, (Object)this.inline("bar-c", "bar-d"), (Object)this.inline("baz-c", "baz-d")));
        String rewritten = this.rewrite(gadget, "");
        Set<String> actual = this.getInjectedScript(rewritten);
        ImmutableSortedSet expected = ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"bar"), (Comparable)((Object)"baz"));
        Assert.assertEquals((Object)expected, actual);
    }

    @Test
    public void inlinedFeaturesWhenNothingForced() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of((Object)this.inline("foo_content();", "foo_content_debug();")), (Set<String>)ImmutableSet.of(), (List<FeatureResource>)ImmutableList.of());
        String rewritten = this.rewrite(gadget, "");
        Assert.assertTrue((String)"Requested scripts not inlined.", (boolean)rewritten.contains("foo_content();"));
    }

    @Test
    public void featuresNotInjectedWhenRemoved() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        gadget.removeFeature("foo");
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), (List<FeatureResource>)ImmutableList.of());
        String rewritten = this.rewrite(gadget, "");
        Assert.assertFalse((String)"Removed script still inlined.", (boolean)rewritten.contains("foo_content();"));
    }

    @Test
    public void featuresInjectedWhenAdded() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        gadget.addFeature("foo");
        gadget.addFeature("do-not-exists");
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of((Object)this.inline("foo_content();", "foo_content_dbg();")), (Set<String>)ImmutableSet.of(), (List<FeatureResource>)ImmutableList.of());
        String rewritten = this.rewrite(gadget, "");
        Assert.assertTrue((String)"Added script not inlined.", (boolean)rewritten.contains("foo_content();"));
    }

    @Test
    public void mixedExternalAndInline() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        ImmutableSet libs = ImmutableSet.of((Object)"bar", (Object)"baz");
        GadgetContext context = new GadgetContext((Set)libs){
            final /* synthetic */ Set val$libs;
            {
                this.val$libs = set;
            }

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return Join.join((CharSequence)":", (Iterable)this.val$libs);
                }
                return null;
            }
        };
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml).setContext(context);
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of((Object)this.inline("foo_content();", "foo_content_debug();")), (Set<String>)libs, (List<FeatureResource>)ImmutableList.of((Object)this.inline("bar-c", "bar-d"), (Object)this.inline("baz-c", "baz-d")));
        String rewritten = this.rewrite(gadget, "");
        Set<String> actual = this.getInjectedScript(rewritten);
        ImmutableSortedSet expected = ImmutableSortedSet.of((Comparable)((Object)"bar"), (Comparable)((Object)"baz"));
        Assert.assertEquals((Object)expected, actual);
        Assert.assertTrue((String)"Requested scripts not inlined.", (boolean)rewritten.contains("foo_content();"));
    }

    @Test
    public void featuresInjectedBeforeExistingScript() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        String rewritten = this.rewrite(gadget, "<html><head><script src=\"foo.js\"></script></head><body>hello</body></html>");
        Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(rewritten);
        Assert.assertTrue((String)"Output is not valid HTML.", (boolean)matcher.matches());
        String headContent = matcher.group(2);
        int userPosition = headContent.indexOf("<script src=\"foo.js\"></script>");
        int ourPosition = headContent.indexOf("<script>");
    }

    @Test
    public void featuresDeclaredBeforeUsed() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of((Object)this.inline("foo_content();", "foo_content_debug();")), (Set<String>)ImmutableSet.of(), (List<FeatureResource>)ImmutableList.of());
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(rewritten);
        Assert.assertTrue((String)"Output is not valid HTML.", (boolean)matcher.matches());
        String headContent = matcher.group(2);
        int declaredPosition = headContent.indexOf("foo_content();");
        Assert.assertTrue((declaredPosition >= 0 ? 1 : 0) != 0);
        int usedPosition = headContent.indexOf("gadgets.Prefs.setMessages_");
        Assert.assertTrue((usedPosition >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Inline JS needs to exist before it is used.", (declaredPosition < usedPosition ? 1 : 0) != 0);
    }

    @Test
    public void urlFeaturesForcedExternal() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/>  <Require feature='bar'/></ModulePrefs><Content type='html'/></Module>";
        GadgetContext context = new GadgetContext(){

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return "baz";
                }
                return null;
            }
        };
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml).setContext(context);
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of((Object)this.inline("foo_content();", "foo_content_debug();"), (Object)this.extern("http://example.org/external.js", "dbg")), (Set<String>)ImmutableSet.of((Object)"baz"), (List<FeatureResource>)ImmutableList.of((Object)this.inline("does-not-matter", "dbg")));
        String rewritten = this.rewrite(gadget, "");
        Set<String> actual = this.getInjectedScript(rewritten);
        ImmutableSortedSet expected = ImmutableSortedSet.of((Comparable)((Object)"baz"));
        Assert.assertEquals((Object)expected, actual);
        Assert.assertTrue((String)"Requested scripts not inlined.", (boolean)rewritten.contains("foo_content();"));
        Assert.assertTrue((String)"Forced external file not forced.", (boolean)rewritten.contains("<script src=\"http://example.org/external.js\">"));
    }

    private JSONObject getConfigJson(String content) throws JSONException {
        Pattern prefsPattern = Pattern.compile("(?:.*)gadgets\\.config\\.init\\((.*)\\);(?:.*)", 32);
        Matcher matcher = prefsPattern.matcher(content);
        Assert.assertTrue((String)"gadgets.config.init not invoked.", (boolean)matcher.matches());
        return new JSONObject(matcher.group(1));
    }

    @Test
    public void featureConfigurationInjected() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of((Object)this.inline("foo", "dbg")), (Set<String>)ImmutableSet.of(), (List<FeatureResource>)ImmutableList.of());
        this.config.data.put("gadgets.features", ImmutableMap.of((Object)"foo", (Object)"blah"));
        String rewritten = this.rewrite(gadget, "");
        JSONObject json = this.getConfigJson(rewritten);
        Assert.assertEquals((Object)"blah", (Object)json.get("foo"));
    }

    @Test
    public void featureConfigurationForced() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        GadgetContext context = new GadgetContext(){

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return "bar";
                }
                return null;
            }
        };
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml).setContext(context);
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of((Object)this.inline("foo", "foo-dbg")), (Set<String>)ImmutableSet.of((Object)"bar"), (List<FeatureResource>)ImmutableList.of((Object)this.inline("bar", "bar-dbg")));
        this.config.data.put("gadgets.features", ImmutableMap.of((Object)"foo", (Object)"blah", (Object)"bar", (Object)"baz"));
        String rewritten = this.rewrite(gadget, "");
        JSONObject json = this.getConfigJson(rewritten);
        Assert.assertEquals((Object)"blah", (Object)json.get("foo"));
        Assert.assertEquals((Object)"baz", (Object)json.get("bar"));
    }

    @Test
    public void gadgetsUtilConfigInjected() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='core.util'/>  <Require feature='foo'>    <Param name='bar'>baz</Param>  </Require>  <Require feature='foo2'>    <Param name='bar'>baz</Param>    <Param name='bar'>bop</Param>  </Require>  <Require feature='unsupported'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.expectFeatureCalls(gadget, (List<FeatureResource>)ImmutableList.of((Object)this.inline("foo", "foo-dbg"), (Object)this.inline("foo2", "foo2-dbg")), (Set<String>)ImmutableSet.of(), (List<FeatureResource>)ImmutableList.of());
        this.config.data.put("gadgets.features", ImmutableMap.of((Object)"foo", (Object)"blah"));
        String rewritten = this.rewrite(gadget, "");
        JSONObject json = this.getConfigJson(rewritten);
        Assert.assertEquals((Object)"blah", (Object)json.get("foo"));
        JSONObject util = json.getJSONObject("core.util");
        JSONObject foo = util.getJSONObject("foo");
        Assert.assertEquals((Object)"baz", (Object)foo.get("bar"));
        JSONObject foo2 = util.getJSONObject("foo2");
        JsonAssert.assertObjectEquals((Object)ImmutableList.of((Object)"baz", (Object)"bop"), (Object)foo2.get("bar"));
        Assert.assertTrue((!util.has("unsupported") ? 1 : 0) != 0);
    }

    @Test
    public void userPrefsInitializationInjected() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Locale>    <msg name='one'>foo</msg>    <msg name='two'>bar</msg>  </Locale></ModulePrefs><UserPref name='pref_one' default_value='default_one'/><UserPref name='pref_two'/><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        String rewritten = this.rewrite(gadget, "");
        Pattern prefsPattern = Pattern.compile("(?:.*)gadgets\\.Prefs\\.setMessages_\\((.*)\\);(?:.*)", 32);
        Matcher matcher = prefsPattern.matcher(rewritten);
        Assert.assertTrue((String)"gadgets.Prefs.setMessages_ not invoked.", (boolean)matcher.matches());
        JSONObject json = new JSONObject(matcher.group(1));
        Assert.assertEquals((Object)"foo", (Object)json.get("one"));
        Assert.assertEquals((Object)"bar", (Object)json.get("two"));
        Pattern defaultsPattern = Pattern.compile("(?:.*)gadgets\\.Prefs\\.setDefaultPrefs_\\((.*)\\);(?:.*)", 32);
        Matcher defaultsMatcher = defaultsPattern.matcher(rewritten);
        Assert.assertTrue((String)"gadgets.Prefs.setDefaultPrefs_ not invoked.", (boolean)defaultsMatcher.matches());
        JSONObject defaultsJson = new JSONObject(defaultsMatcher.group(1));
        Assert.assertEquals((long)2L, (long)defaultsJson.length());
        Assert.assertEquals((Object)"default_one", (Object)defaultsJson.get("pref_one"));
        Assert.assertEquals((Object)"", (Object)defaultsJson.get("pref_two"));
    }

    @Test
    public void xhrWrapperConfigurationInjected() throws Exception {
        this.checkXhrWrapperConfigurationInjection("No shindig.xhrwrapper configuration present in rewritten HTML.", null, null, null);
        this.checkXhrWrapperConfigurationInjection("No shindig.xhrwrapper.authorization=signed configuration present in rewritten HTML.", "signed", null, null);
        this.checkXhrWrapperConfigurationInjection("No shindig.xhrwrapper.oauthService configuration present in rewritten HTML.", "oauth", "serviceName", null);
        this.checkXhrWrapperConfigurationInjection("No shindig.xhrwrapper.oauthTokenName configuration present in rewritten HTML.", "oauth", "serviceName", "tokenName");
    }

    private void checkXhrWrapperConfigurationInjection(String message, String auth, String oauthService, String oauthToken) throws Exception {
        String oAuthBlock = "";
        String authzAttr = "";
        if (auth != null) {
            authzAttr = " authz='" + auth + '\'';
            if ("oauth".equals(auth)) {
                if (oauthService != null) {
                    oAuthBlock = "<OAuth><Service name='" + oauthService + "'>" + "<Access url='http://foo' method='GET' />" + "<Request url='http://bar' method='GET' />" + "<Authorization url='http://baz' />" + "</Service></OAuth>";
                    authzAttr = authzAttr + " oauth_service_name='" + oauthService + '\'';
                }
                if (oauthToken != null) {
                    authzAttr = authzAttr + " oauth_token_name='" + oauthToken + '\'';
                }
            }
        }
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='shindig.xhrwrapper' />" + oAuthBlock + "</ModulePrefs>" + "<Content type='html' href='http://foo.com/bar/baz.html'" + authzAttr + " />" + "</Module>";
        String expected = '{' + (oauthService == null ? "" : "\"oauthService\":\"serviceName\",") + "\"contentUrl\":\"http://foo.com/bar/baz.html\"" + (auth == null ? "" : ",\"authorization\":\"" + auth + '\"') + (oauthToken == null ? "" : ",\"oauthTokenName\":\"tokenName\"") + '}';
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        gadget.setCurrentView(gadget.getSpec().getView("default"));
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        this.assertXhrConfigContains(message, expected, rewritten);
    }

    private void assertXhrConfigContains(String message, String expected, String content) throws Exception {
        String prefix = "gadgets.config.init(";
        int configIdx = content.indexOf(prefix);
        Assert.assertTrue((String)"gadgets.config.init not found in rewritten content", (configIdx != -1 ? 1 : 0) != 0);
        int endIdx = content.indexOf(41, configIdx + prefix.length());
        Assert.assertTrue((String)"unexpected error, gadgets.config.init not closed", (endIdx != -1 ? 1 : 0) != 0);
        String configJson = content.substring(configIdx + prefix.length(), endIdx);
        JSONObject config = new JSONObject(configJson);
        JSONObject xhrConfig = config.getJSONObject("shindig.xhrwrapper");
        JSONObject expectedJson = new JSONObject(expected);
        Assert.assertEquals((String)message, (Object)xhrConfig.toString(), (Object)expectedJson.toString());
    }

    @Test
    public void xhrWrapperConfigurationNotInjectedIfUnnecessary() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title='' /><Content type='html' href='http://foo.com/bar/baz.html' /></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        gadget.setCurrentView(gadget.getSpec().getView("default"));
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        boolean containsConfig = rewritten.contains("\"shindig.xhrwrapper\"");
        Assert.assertFalse((String)"shindig.xhrwrapper configuration present in rewritten HTML.", (boolean)containsConfig);
    }

    @Test(expected=RewritingException.class)
    public void unsupportedFeatureThrows() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        EasyMock.reset((Object[])new Object[]{this.featureRegistry});
        EasyMock.expect((Object)this.featureRegistry.getFeatureResources((GadgetContext)EasyMock.same((Object)gadget.getContext()), (Collection)EasyMock.eq((Object)ImmutableSet.of()), (List)EasyMock.eq((Object)Lists.newArrayList()))).andReturn((Object)ImmutableList.of());
        EasyMock.expect((Object)this.featureRegistry.getFeatureResources((GadgetContext)EasyMock.same((Object)gadget.getContext()), (Collection)EasyMock.eq((Object)ImmutableList.of((Object)"foo", (Object)"core")), (List)EasyMock.eq((Object)Lists.newArrayList()))).andAnswer((IAnswer)new IAnswer<List<FeatureResource>>(){

            public List<FeatureResource> answer() throws Throwable {
                List unsupported = (List)EasyMock.getCurrentArguments()[2];
                unsupported.add("foo");
                return Lists.newArrayList();
            }
        });
        EasyMock.replay((Object[])new Object[]{this.featureRegistry});
        this.rewrite(gadget, "");
    }

    @Test
    public void unsupportedExternFeatureDoesNotThrow() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''></ModulePrefs><Content type='html'/></Module>";
        GadgetContext context = new GadgetContext(){

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return "bar";
                }
                return null;
            }
        };
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml).setContext(context);
        EasyMock.reset((Object[])new Object[]{this.featureRegistry});
        EasyMock.expect((Object)this.featureRegistry.getFeatureResources((GadgetContext)EasyMock.same((Object)gadget.getContext()), (Collection)EasyMock.eq((Object)ImmutableSet.of((Object)"bar")), (List)EasyMock.eq((Object)Lists.newArrayList()))).andAnswer((IAnswer)new IAnswer<List<FeatureResource>>(){

            public List<FeatureResource> answer() throws Throwable {
                List unsupported = (List)EasyMock.getCurrentArguments()[2];
                unsupported.add("bar");
                return Lists.newArrayList();
            }
        });
        EasyMock.expect((Object)this.featureRegistry.getFeatureResources((GadgetContext)EasyMock.same((Object)gadget.getContext()), (Collection)EasyMock.eq((Object)ImmutableList.of((Object)"core")), (List)EasyMock.eq((Object)Lists.newArrayList()))).andReturn((Object)ImmutableList.of());
        EasyMock.expect((Object)this.featureRegistry.getFeatures((Collection)EasyMock.eq((Object)ImmutableList.of((Object)"core", (Object)"bar")))).andReturn((Object)ImmutableList.of((Object)"core"));
        EasyMock.expect((Object)this.featureRegistry.getFeatures((Collection)EasyMock.eq((Object)ImmutableList.of((Object)"core")))).andReturn((Object)ImmutableList.of((Object)"core"));
        EasyMock.replay((Object[])new Object[]{this.featureRegistry});
        this.rewrite(gadget, "");
    }

    @Test
    public void unsupportedOptionalFeatureDoesNotThrow() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Optional feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.rewrite(gadget, "");
    }

    @Test
    public void multipleUnsupportedOptionalFeaturesDoNotThrow() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Optional feature='foo'/>  <Optional feature='bar'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.rewrite(gadget, "");
    }

    private JSONArray getPreloadedJson(String content) throws JSONException {
        Pattern preloadPattern = Pattern.compile("(?:.*)gadgets\\.io\\.preloaded_=\\[(.*?)\\];(?:.*)", 32);
        Matcher matcher = preloadPattern.matcher(content);
        Assert.assertTrue((String)"gadgets.io.preloaded not set.", (boolean)matcher.matches());
        return new JSONArray('[' + matcher.group(1) + ']');
    }

    @Test
    public void preloadsInjected() throws Exception {
        ImmutableList someData = ImmutableList.of((Object)"string", (Object)99, (Object)4343434.345345);
        PreloadedData preloadedData = new PreloadedData((Collection)someData){
            final /* synthetic */ Collection val$someData;
            {
                this.val$someData = collection;
            }

            public Collection<Object> toJson() throws PreloadException {
                return this.val$someData;
            }
        };
        Gadget gadget = this.makeDefaultGadget().setPreloads((Collection)ImmutableList.of((Object)preloadedData));
        String rewritten = this.rewrite(gadget, "");
        JSONArray json = this.getPreloadedJson(rewritten);
        int i = 0;
        for (Object entry : someData) {
            Assert.assertEquals(entry, (Object)json.get(i++));
        }
    }

    @Test
    public void failedPreloadHandledGracefully() throws Exception {
        PreloadedData preloadedData = new PreloadedData(){

            public Collection<Object> toJson() throws PreloadException {
                throw new PreloadException("test");
            }
        };
        Gadget gadget = this.makeDefaultGadget().setPreloads((Collection)ImmutableList.of((Object)preloadedData));
        String rewritten = this.rewrite(gadget, "");
        JSONArray json = this.getPreloadedJson(rewritten);
        Assert.assertEquals((long)0L, (long)json.length());
    }

    private String getBaseElement(String content) {
        Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(content);
        Assert.assertTrue((String)"Output is not valid HTML.", (boolean)matcher.matches());
        Pattern baseElementPattern = Pattern.compile("^<base href=\"(.*?)\">(?:.*)", 32);
        Matcher baseElementMatcher = baseElementPattern.matcher(matcher.group(2));
        Assert.assertTrue((String)"Base element does not exist at the beginning of the head element.", (boolean)baseElementMatcher.matches());
        return baseElementMatcher.group(1);
    }

    @Test
    public void baseElementInsertedWhenContentIsInline() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        this.config.data.put("gadgets.insertBaseElement", true);
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        String base = this.getBaseElement(rewritten);
        Assert.assertEquals((Object)SPEC_URL.toString(), (Object)base);
    }

    @Test
    public void baseElementInsertedWhenContentIsProxied() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        String viewUrl = "http://example.org/view.html";
        String xml = "<Content href='" + viewUrl + "'/>";
        View fakeView = new View("foo", Arrays.asList(XmlUtil.parse((String)xml)), SPEC_URL);
        gadget.setCurrentView(fakeView);
        this.config.data.put("gadgets.insertBaseElement", true);
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        String base = this.getBaseElement(rewritten);
        Assert.assertEquals((Object)viewUrl, (Object)base);
    }

    @Test
    public void baseElementNotInsertedWhenConfigDoesNotAllowIt() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        this.config.data.put("gadgets.insertBaseElement", false);
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        Assert.assertFalse((String)"Base element injected incorrectly.", (boolean)rewritten.contains("<base"));
    }

    @Test
    public void doesNotRewriteWhenSanitizeEquals1() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        this.context.params.put("sanitize", "1");
        Assert.assertEquals((Object)BODY_CONTENT, (Object)this.rewrite(gadget, BODY_CONTENT));
    }

    @Test
    public void doesRewriteWhenSanitizeEquals0() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        this.context.params.put("sanitize", "0");
        Assert.assertFalse((String)"Didn't rewrite when sanitize was '0'.", (boolean)BODY_CONTENT.equals(this.rewrite(gadget, BODY_CONTENT)));
    }

    private void expectFeatureCalls(Gadget gadget, List<FeatureResource> gadgetResources, Set<String> externLibs, List<FeatureResource> externResources) {
        EasyMock.reset((Object[])new Object[]{this.featureRegistry});
        GadgetContext gadgetContext = gadget.getContext();
        ArrayList gadgetFeatures = Lists.newArrayList((Iterable)gadget.getDirectFeatureDeps());
        ArrayList allFeatures = Lists.newArrayList((Iterable)gadgetFeatures);
        ArrayList allFeaturesAndLibs = Lists.newArrayList((Iterable)gadgetFeatures);
        allFeaturesAndLibs.addAll(externLibs);
        ArrayList emptyList = Lists.newArrayList();
        EasyMock.expect((Object)this.featureRegistry.getFeatureResources((GadgetContext)EasyMock.same((Object)gadgetContext), (Collection)EasyMock.eq(externLibs), (List)EasyMock.eq((Object)emptyList))).andReturn(externResources);
        EasyMock.expect((Object)this.featureRegistry.getFeatureResources((GadgetContext)EasyMock.same((Object)gadgetContext), (Collection)EasyMock.eq((Object)gadgetFeatures), (List)EasyMock.eq((Object)emptyList))).andReturn(gadgetResources);
        EasyMock.expect((Object)this.featureRegistry.getFeatures((Collection)EasyMock.eq((Object)allFeatures))).andReturn((Object)allFeatures);
        EasyMock.expect((Object)this.featureRegistry.getFeatures((Collection)EasyMock.eq((Object)allFeaturesAndLibs))).andReturn((Object)allFeaturesAndLibs);
        EasyMock.expect((Object)this.featureRegistry.getAllFeatureNames()).andReturn((Object)ImmutableSet.of((Object)"foo", (Object)"foo2", (Object)"core.util")).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.featureRegistry});
    }

    private FeatureResource inline(String content, String debugContent) {
        return new FeatureResource.Simple(content, debugContent);
    }

    private FeatureResource extern(String content, String debugContent) {
        return new FeatureResource.Simple(content, debugContent){

            public boolean isExternal() {
                return true;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeJsUriManager
    implements JsUriManager {
        private FakeJsUriManager() {
        }

        public Uri makeExternJsUri(Gadget gadget, Collection<String> extern) {
            return Uri.parse((String)("/js/" + Join.join((CharSequence)":", extern)));
        }

        public JsUriManager.JsUri processExternJsUri(Uri uri) {
            throw new UnsupportedOperationException();
        }
    }

    private static class FakeContainerConfig
    extends AbstractContainerConfig {
        protected final Map<String, Object> data = Maps.newHashMap();

        private FakeContainerConfig() {
        }

        public Object getProperty(String container, String name) {
            return this.data.get(name);
        }
    }

    public static class MapGadgetContext
    extends GadgetContext {
        protected final Map<String, String> params = Maps.newHashMap();

        public String getParameter(String name) {
            return this.params.get(name);
        }
    }
}

