/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRewriterTestCase {
    public static final Uri SPEC_URL = Uri.parse((String)"http://www.example.org/dir/g.xml");
    public static final String DEFAULT_PROXY_BASE = "http://www.test.com/dir/proxy?url=";
    public static final String DEFAULT_CONCAT_BASE = "http://www.test.com/dir/concat?";
    public static final String MOCK_CONTAINER = "mock";
    public static final String MOCK_PROXY_BASE = BaseRewriterTestCase.replaceDefaultWithMockServer("http://www.test.com/dir/proxy?url=");
    public static final String MOCK_CONCAT_BASE = BaseRewriterTestCase.replaceDefaultWithMockServer("http://www.test.com/dir/concat?");
    protected final String TAGS = "embed,img,script,link,style";
    protected Set<String> tags;
    protected ContentRewriterFeature.Config defaultRewriterFeature;
    protected ContentRewriterFeature.Factory rewriterFeatureFactory;
    protected GadgetHtmlParser parser;
    protected Injector injector;
    protected HttpResponseBuilder fakeResponse;
    protected IMocksControl control;

    @Before
    public void setUp() throws Exception {
        this.rewriterFeatureFactory = new ContentRewriterFeature.Factory(null, new ContentRewriterFeature.DefaultConfig(".*", "", "86400", "embed,img,script,link,style", false, false));
        this.defaultRewriterFeature = this.rewriterFeatureFactory.getDefault();
        this.tags = this.defaultRewriterFeature.getIncludedTags();
        this.injector = Guice.createInjector((Module[])new Module[]{this.getParseModule(), new PropertiesModule(), new TestModule()});
        this.parser = (GadgetHtmlParser)this.injector.getInstance(GadgetHtmlParser.class);
        this.fakeResponse = new HttpResponseBuilder().setHeader("Content-Type", "unknown").setResponse(new byte[]{-2, -1});
        this.control = EasyMock.createControl();
    }

    private Module getParseModule() {
        return Modules.override((Module[])new Module[]{new ParseModule()}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(GadgetHtmlParser.class).to(BaseRewriterTestCase.this.getParserClass());
            }
        }});
    }

    protected Class<? extends GadgetHtmlParser> getParserClass() {
        return NekoSimplifiedHtmlParser.class;
    }

    public static GadgetSpec createSpecWithRewrite(String include, String exclude, String expires, Set<String> tags) throws GadgetException {
        StringBuilder xml = new StringBuilder();
        xml.append("<Module>");
        xml.append("<ModulePrefs title=\"title\">");
        xml.append("<Optional feature=\"content-rewrite\">\n");
        if (expires != null) {
            xml.append("      <Param name=\"expires\">" + expires + "</Param>\n");
        }
        if (include != null) {
            xml.append("      <Param name=\"include-urls\">" + include + "</Param>\n");
        }
        if (exclude != null) {
            xml.append("      <Param name=\"exclude-urls\">" + exclude + "</Param>\n");
        }
        if (tags != null) {
            xml.append("      <Param name=\"include-tags\">" + StringUtils.join(tags, (String)",") + "</Param>\n");
        }
        xml.append("</Optional>");
        xml.append("</ModulePrefs>");
        xml.append("<Content type=\"html\">Hello!</Content>");
        xml.append("</Module>");
        return new GadgetSpec(SPEC_URL, xml.toString());
    }

    public static GadgetSpec createSpecWithRewriteOS9(String[] includes, String[] excludes, String expires, Set<String> tags) throws GadgetException {
        StringBuilder xml = new StringBuilder();
        xml.append("<Module>");
        xml.append("<ModulePrefs title=\"title\">");
        xml.append("<Optional feature=\"content-rewrite\">\n");
        if (expires != null) {
            xml.append("      <Param name=\"expires\">" + expires + "</Param>\n");
        }
        if (includes != null) {
            for (String include : includes) {
                xml.append("      <Param name=\"include-url\">" + include + "</Param>\n");
            }
        }
        if (excludes != null) {
            for (String exclude : excludes) {
                xml.append("      <Param name=\"exclude-url\">" + exclude + "</Param>\n");
            }
        }
        if (tags != null) {
            xml.append("      <Param name=\"include-tags\">" + StringUtils.join(tags, (String)",") + "</Param>\n");
        }
        xml.append("</Optional>");
        xml.append("</ModulePrefs>");
        xml.append("<Content type=\"html\">Hello!</Content>");
        xml.append("</Module>");
        return new GadgetSpec(SPEC_URL, xml.toString());
    }

    public static GadgetSpec createSpecWithoutRewrite() throws GadgetException {
        String xml = "<Module><ModulePrefs title=\"title\"></ModulePrefs><Content type=\"html\">Hello!</Content></Module>";
        return new GadgetSpec(SPEC_URL, xml);
    }

    public static String replaceDefaultWithMockServer(String originalText) {
        return originalText.replace("test.com", "mock.com");
    }

    protected ContentRewriterFeature.Factory mockContentRewriterFeatureFactory(ContentRewriterFeature.Config feature) {
        return new FakeRewriterFeatureFactory(feature);
    }

    String rewriteHelper(GadgetRewriter rewriter, String s) throws Exception {
        MutableContent mc = this.rewriteContent(rewriter, s, null);
        String rewrittenContent = mc.getContent();
        int htmlTagIndex = rewrittenContent.indexOf("<HTML>");
        if (htmlTagIndex != -1) {
            return rewrittenContent.substring(htmlTagIndex + 6, rewrittenContent.lastIndexOf("</HTML>"));
        }
        return rewrittenContent;
    }

    protected MutableContent rewriteContent(GadgetRewriter rewriter, String s, String container) throws Exception {
        return this.rewriteContent(rewriter, s, container, false, false);
    }

    protected MutableContent rewriteContent(GadgetRewriter rewriter, String s, final String container, final boolean debug, final boolean ignoreCache) throws Exception {
        MutableContent mc = new MutableContent(this.parser, s);
        GadgetSpec spec = new GadgetSpec(SPEC_URL, "<Module><ModulePrefs title=''/><Content><![CDATA[" + s + "]]></Content></Module>");
        GadgetContext context = new GadgetContext(){

            public Uri getUrl() {
                return SPEC_URL;
            }

            public String getContainer() {
                return container;
            }

            public boolean getDebug() {
                return debug;
            }

            public boolean getIgnoreCache() {
                return ignoreCache;
            }
        };
        Gadget gadget = new Gadget().setContext(context).setSpec(spec);
        rewriter.rewrite(gadget, mc);
        return mc;
    }

    private static class TestModule
    extends AbstractModule {
        private TestModule() {
        }

        protected void configure() {
            this.bind(RequestPipeline.class).toInstance((Object)new RequestPipeline(){

                public HttpResponse execute(HttpRequest request) {
                    return null;
                }
            });
            this.bind(GadgetSpecFactory.class).toInstance((Object)new GadgetSpecFactory(){

                public GadgetSpec getGadgetSpec(GadgetContext context) {
                    return null;
                }
            });
        }
    }

    private static class FakeRewriterFeatureFactory
    extends ContentRewriterFeature.Factory {
        private final ContentRewriterFeature.Config feature;

        public FakeRewriterFeatureFactory(ContentRewriterFeature.Config feature) {
            super(null, new ContentRewriterFeature.DefaultConfig(".*", "", "HTTP", "", false, false));
            this.feature = feature;
        }

        public ContentRewriterFeature.Config get(GadgetSpec spec) {
            return this.feature;
        }

        public ContentRewriterFeature.Config get(HttpRequest request) {
            return this.feature;
        }
    }
}

