/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.CssResponseRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterTestBase;
import org.apache.shindig.gadgets.uri.DefaultProxyUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CssResponseRewriterTest
extends RewriterTestBase {
    private CssResponseRewriter rewriter;
    private CssResponseRewriter rewriterNoOverrideExpires;
    private Uri dummyUri;
    private GadgetContext gadgetContext;
    private ProxyUriManager proxyUriManager;
    private ContentRewriterFeature.Factory factory;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        final ContentRewriterFeature.Config overrideFeatureNoOverrideExpires = this.rewriterFeatureFactory.get(CssResponseRewriterTest.createSpecWithRewrite(".*", ".*exclude.*", null, this.tags));
        ContentRewriterFeature.Factory factoryNoOverrideExpires = new ContentRewriterFeature.Factory(null, null){

            public ContentRewriterFeature.Config get(HttpRequest req) {
                return overrideFeatureNoOverrideExpires;
            }
        };
        FakeContainerConfig config = new FakeContainerConfig();
        this.proxyUriManager = new DefaultProxyUriManager((ContainerConfig)config, null);
        this.rewriterNoOverrideExpires = new CssResponseRewriter(new CajaCssParser(), this.proxyUriManager, factoryNoOverrideExpires);
        final ContentRewriterFeature.Config overrideFeature = this.rewriterFeatureFactory.get(CssResponseRewriterTest.createSpecWithRewrite(".*", ".*exclude.*", "3600", this.tags));
        this.factory = new ContentRewriterFeature.Factory(null, null){

            public ContentRewriterFeature.Config get(HttpRequest req) {
                return overrideFeature;
            }
        };
        this.rewriter = new CssResponseRewriter(new CajaCssParser(), this.proxyUriManager, this.factory);
        this.dummyUri = Uri.parse((String)"http://www.w3c.org");
        this.gadgetContext = new GadgetContext(){

            public Uri getUrl() {
                return CssResponseRewriterTest.this.dummyUri;
            }
        };
    }

    @Test
    public void testCssBasic() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic.css"));
        String expected = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic-expected.css"));
        HttpRequest request = new HttpRequest(Uri.parse((String)"http://www.example.org/path/rewritebasic.css"));
        request.setMethod("GET");
        request.setGadget(SPEC_URL);
        HttpResponseBuilder response = new HttpResponseBuilder().setHeader("Content-Type", "text/css").setResponseString(content);
        this.rewriter.rewrite(request, response);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)response.getContent()));
    }

    @Test
    public void testCssBasicNoOverrideExpires() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic.css"));
        String expected = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic-expected.css"));
        expected = expected.replace("refresh=3600", "refresh=86400");
        HttpRequest request = new HttpRequest(Uri.parse((String)"http://www.example.org/path/rewritebasic.css"));
        request.setMethod("GET");
        request.setGadget(SPEC_URL);
        HttpResponseBuilder response = new HttpResponseBuilder().setHeader("Content-Type", "text/css").setResponseString(content);
        this.rewriterNoOverrideExpires.rewrite(request, response);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)response.getContent()));
    }

    @Test
    public void testCssBasicNoCache() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic.css"));
        String expected = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic-expected.css"));
        expected = expected.replace("nocache=0", "nocache=1");
        HttpRequest request = new HttpRequest(Uri.parse((String)"http://www.example.org/path/rewritebasic.css"));
        request.setMethod("GET");
        request.setGadget(SPEC_URL);
        request.setIgnoreCache(true);
        HttpResponseBuilder response = new HttpResponseBuilder().setHeader("Content-Type", "text/css").setResponseString(content);
        this.rewriter.rewrite(request, response);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)response.getContent()));
    }

    @Test
    public void testCssWithContainerProxy() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic.css"));
        String expected = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic-expected.css"));
        expected = CssResponseRewriterTest.replaceDefaultWithMockServer(expected);
        expected = expected.replace("container=default", "container=mock");
        this.rewriter = new CssResponseRewriter(new CajaCssParser(), this.proxyUriManager, this.factory);
        HttpRequest request = new HttpRequest(Uri.parse((String)"http://www.example.org/path/rewritebasic.css"));
        request.setMethod("GET");
        request.setGadget(SPEC_URL);
        request.setContainer("mock");
        HttpResponseBuilder response = new HttpResponseBuilder().setHeader("Content-Type", "text/css").setResponseString(content);
        this.rewriter.rewrite(request, response);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)response.getContent()));
    }

    @Test
    public void testNoRewriteUnknownMimeType() throws Exception {
        HttpRequest req = (HttpRequest)this.control.createMock(HttpRequest.class);
        EasyMock.expect((Object)req.getRewriteMimeType()).andReturn((Object)"unknown");
        this.control.replay();
        int changesBefore = this.fakeResponse.getNumChanges();
        this.rewriter.rewrite(req, this.fakeResponse);
        Assert.assertEquals((long)changesBefore, (long)this.fakeResponse.getNumChanges());
        this.control.verify();
    }

    private void validateRewritten(String content, Uri base, String expected) throws Exception {
        HttpResponseBuilder response = new HttpResponseBuilder().setHeader("Content-Type", "text/css");
        response.setContent(content);
        HttpRequest request = new HttpRequest(base);
        this.rewriter.rewrite(request, response);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)response.getContent()));
    }

    private void validateRewritten(String content, String expected) throws Exception {
        this.validateRewritten(content, this.dummyUri, expected);
    }

    @Test
    public void testUrlDeclarationRewrite() throws Exception {
        String original = "div {list-style-image:url('http://a.b.com/bullet.gif');list-style-position:outside;margin:5px;padding:0}\n.someid {background-image:url(http://a.b.com/bigimg.png);float:right;width:165px;height:23px;margin-top:4px;margin-left:5px}";
        String rewritten = "div {list-style-image:url('//www.test.com/dir/proxy?container=default&gadget=http%3A%2F%2Fwww.w3c.org&debug=0&nocache=0&url=http%3A%2F%2Fa.b.com%2Fbullet.gif');\nlist-style-position:outside;margin:5px;padding:0}\n.someid {background-image:url('//www.test.com/dir/proxy?container=default&gadget=http%3A%2F%2Fwww.w3c.org&debug=0&nocache=0&url=http%3A%2F%2Fa.b.com%2Fbigimg.png');\nfloat:right;width:165px;height:23px;margin-top:4px;margin-left:5px}";
        this.validateRewritten(original, rewritten);
    }

    @Test
    public void testExtractImports() throws Exception {
        String original = " @import url(www.example.org/some.css);\n@import url('www.example.org/someother.css');\n@import url(\"www.example.org/another.css\");\n div { color: blue; }\n p { color: black; }\n span { color: red; }";
        String expected = " div { color: blue; }\n p { color: black; }\n span { color: red; }";
        StringWriter sw = new StringWriter();
        List stringList = this.rewriter.rewrite((Reader)new StringReader(original), this.dummyUri, CssResponseRewriter.uriMaker((ProxyUriManager)this.proxyUriManager, (ContentRewriterFeature.Config)this.defaultRewriterFeature), (Writer)sw, true, this.gadgetContext);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)sw.toString()));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"www.example.org/some.css", "www.example.org/someother.css", "www.example.org/another.css"}), (Object)stringList);
    }

    @Test
    public void testMalformedImport() throws Exception {
        String original = " @import \"www.example.org/some.css\";\n span { color: red; }";
        String expected = " span { color: red; }";
        StringWriter sw = new StringWriter();
        List stringList = this.rewriter.rewrite((Reader)new StringReader(original), this.dummyUri, CssResponseRewriter.uriMaker((ProxyUriManager)this.proxyUriManager, (ContentRewriterFeature.Config)this.defaultRewriterFeature), (Writer)sw, true, this.gadgetContext);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)sw.toString()));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"www.example.org/some.css"}), (Object)stringList);
    }

    private static class FakeContainerConfig
    extends AbstractContainerConfig {
        private Map<String, Map<String, Object>> containers = new HashMap<String, Map<String, Object>>();

        private FakeContainerConfig() {
            this.containers.put("default", (Map<String, Object>)ImmutableMap.builder().put((Object)"gadgets.uri.proxy.host", (Object)"www.test.com").put((Object)"gadgets.uri.proxy.path", (Object)"/dir/proxy").build());
            this.containers.put("mock", (Map<String, Object>)ImmutableMap.builder().put((Object)"gadgets.uri.proxy.host", (Object)"www.mock.com").build());
        }

        public Object getProperty(String container, String name) {
            Map<String, Object> data = this.containers.get(container);
            if (!data.containsKey(name)) {
                data = this.containers.get("default");
            }
            return data.get(name);
        }
    }
}

