/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.easymock.EasyMock;
import org.junit.Before;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomWalkerTestBase {
    protected static final Uri GADGET_URI = Uri.parse((String)"http://example.com/gadget.xml");
    protected static final String CONTAINER = "container";
    protected Document doc;

    @Before
    public void setUp() {
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new ParseModule()}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"shindig.cache.lru.default.capacity")).toInstance((Object)0);
            }
        }})});
        DOMImplementation domImpl = (DOMImplementation)injector.getInstance(DOMImplementation.class);
        this.doc = domImpl.createDocument(null, null, null);
    }

    protected Element elem(String tag, String ... attrStrs) {
        Element elem = this.doc.createElement(tag);
        for (int i = 0; attrStrs != null && i < attrStrs.length; i += 2) {
            Attr attr = this.doc.createAttribute(attrStrs[i]);
            attr.setValue(attrStrs[i + 1]);
            elem.setAttributeNode(attr);
        }
        return elem;
    }

    protected Element htmlDoc(Node[] headNodes, Node ... bodyNodes) {
        while (this.doc.hasChildNodes()) {
            this.doc.removeChild(this.doc.getFirstChild());
        }
        Element html = this.elem("html", new String[0]);
        Element head = this.elem("head", new String[0]);
        this.appendAll(head, headNodes);
        Element body = this.elem("body", new String[0]);
        this.appendAll(body, bodyNodes);
        html.appendChild(head);
        html.appendChild(body);
        this.doc.appendChild(html);
        return html;
    }

    private void appendAll(Node parent, Node[] children) {
        if (children == null || children.length == 0) {
            return;
        }
        for (Node child : children) {
            parent.appendChild(child);
        }
    }

    protected Gadget gadget() {
        return this.gadget(false, false);
    }

    protected Gadget gadget(boolean debug, boolean ignoreCache) {
        return this.gadget(debug, ignoreCache, null);
    }

    protected Gadget gadget(boolean debug, boolean ignoreCache, Uri curviewHref) {
        GadgetSpec spec = (GadgetSpec)EasyMock.createMock(GadgetSpec.class);
        EasyMock.expect((Object)spec.getUrl()).andReturn((Object)GADGET_URI).anyTimes();
        Gadget gadget = (Gadget)EasyMock.createMock(Gadget.class);
        EasyMock.expect((Object)gadget.getSpec()).andReturn((Object)spec).anyTimes();
        GadgetContext ctx = (GadgetContext)EasyMock.createMock(GadgetContext.class);
        EasyMock.expect((Object)ctx.getParameter(UriCommon.Param.REFRESH.getKey())).andReturn(null).anyTimes();
        EasyMock.expect((Object)ctx.getDebug()).andReturn((Object)debug).anyTimes();
        EasyMock.expect((Object)ctx.getIgnoreCache()).andReturn((Object)ignoreCache).anyTimes();
        EasyMock.expect((Object)ctx.getContainer()).andReturn((Object)CONTAINER).anyTimes();
        EasyMock.expect((Object)gadget.getContext()).andReturn((Object)ctx).anyTimes();
        View currentView = (View)EasyMock.createMock(View.class);
        EasyMock.expect((Object)currentView.getHref()).andReturn((Object)curviewHref).anyTimes();
        EasyMock.expect((Object)gadget.getCurrentView()).andReturn((Object)currentView).anyTimes();
        EasyMock.replay((Object[])new Object[]{ctx, spec, currentView, gadget});
        return gadget;
    }
}

