/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Arrays;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.OsTemplateXmlLoaderRewriter;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.easymock.EasyMock;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OsTemplateXmlLoaderRewriterTest {
    private GadgetHtmlParser parser;
    private DOMImplementation domImpl;
    private Document doc;
    private OsTemplateXmlLoaderRewriter.Converter converter;

    @Before
    public void setUp() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ParseModule(), new PropertiesModule()});
        this.parser = (GadgetHtmlParser)injector.getInstance(GadgetHtmlParser.class);
        this.domImpl = (DOMImplementation)injector.getInstance(DOMImplementation.class);
        this.doc = this.domImpl.createDocument(null, null, null);
        this.converter = new OsTemplateXmlLoaderRewriter.Converter(this.parser, this.domImpl);
    }

    @Test
    public void convertSingleElement() throws Exception {
        String xml = "<os:elem id=\"id\" foo=\"bar\">String value</os:elem>";
        Assert.assertEquals((Object)new JSONObject("{n:\"template\",a:[],c:[{n:\"os:elem\",a:[{n:\"foo\",v:\"bar\"},{n:\"id\",v:\"id\"}],c:[\"String value\"]}]}").toString(), (Object)this.converter.domToJson(xml));
    }

    @Test
    public void convertMixedTreeWithIgnorables() throws Exception {
        String xml = "<b>Some ${viewer} content</b>  <img/><!-- comment --><os:Html/>";
        Assert.assertEquals((Object)new JSONObject("{n:\"template\",a:[],c:[{n:\"b\",a:[],c:[\"Some ${viewer} content\"]},\"  \",{n:\"img\",a:[],c:[]},{n:\"os:Html\",a:[],c:[]}]}").toString(), (Object)this.converter.domToJson(xml));
    }

    @Test
    public void visitNonElement() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(this.doc.createTextNode("text")));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(this.doc.createAttribute("foo")));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(this.doc.createComment("comment")));
    }

    @Test
    public void visitDivSansType() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(this.doc.createElement("div")));
    }

    @Test
    public void visitDivMismatchingType() throws Exception {
        Element div = this.doc.createElement("div");
        div.setAttribute("id", "id");
        div.setAttribute("type", "os/template-but-not");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(div));
    }

    @Test
    public void visitDivMatchingTypeNoId() throws Exception {
        Element div = this.doc.createElement("div");
        div.setAttribute("type", "os/template");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(div));
    }

    @Test
    public void visitDivMatchingTypeBlankIdAndName() throws Exception {
        Element div = this.doc.createElement("div");
        div.setAttribute("id", "");
        div.setAttribute("name", "");
        div.setAttribute("type", "os/template");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(div));
    }

    @Test
    public void visitDivMatchingTypeWithId() throws Exception {
        Element div = this.createRewritableDiv();
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.visit(div));
    }

    @Test
    public void visitDivMatchingCaseMixedWithId() throws Exception {
        Element div = this.doc.createElement("dIv");
        div.setAttribute("id", "id");
        div.setAttribute("type", "os/template".toUpperCase());
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.visit(div));
    }

    @Test
    public void visitDivMatchingTypeWithName() throws Exception {
        Element div = this.doc.createElement("div");
        div.setAttribute("name", "id");
        div.setAttribute("type", "os/template");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.visit(div));
    }

    @Test
    public void visitDivMatchingCaseMixedWithName() throws Exception {
        Element div = this.doc.createElement("dIv");
        div.setAttribute("name", "id");
        div.setAttribute("type", "os/template".toUpperCase());
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.visit(div));
    }

    private DomWalker.Visitor.VisitStatus visit(Node node) throws Exception {
        return new OsTemplateXmlLoaderRewriter.GadgetHtmlVisitor(null).visit(null, node);
    }

    @Test
    public void revisitWithoutOsTemplates() throws Exception {
        Assert.assertFalse((boolean)this.revisit(this.mockGadget("foo", "bar"), null, new Node[0]));
    }

    @Test(expected=RewritingException.class)
    public void revisitWithoutValidDocument() throws Exception {
        this.revisit(this.mockGadget("opensocial-templates", "foo"), null, this.createRewritableDiv());
    }

    @Test(expected=RewritingException.class)
    public void revisitWithoutHeadNode() throws Exception {
        Element html = this.doc.createElement("html");
        html.appendChild(this.doc.createElement("body"));
        this.doc.appendChild(html);
        this.revisit(this.mockGadget("opensocial-templates", "foo"), null, this.createRewritableDiv());
    }

    @Test
    public void revisitWithIdDivSingle() throws Exception {
        Element tpl = this.createRewritableDiv("tpl_id");
        this.checkRevisitSingle(tpl, "tpl_id");
    }

    @Test
    public void revisitWithNameDivSingle() throws Exception {
        Element tpl = this.createRewritableDiv();
        tpl.removeAttribute("id");
        tpl.setAttribute("name", "otherid");
        this.checkRevisitSingle(tpl, "otherid");
    }

    @Test
    public void revisitWithBothLabeledDivSingle() throws Exception {
        Element tpl = this.createRewritableDiv();
        tpl.setAttribute("name", "otherid");
        this.checkRevisitSingle(tpl, "otherid");
    }

    private void checkRevisitSingle(Element tpl, String id) throws Exception {
        Gadget gadget = this.mockGadget("opensocial-templates", "another");
        String xmlVal = "xml";
        OsTemplateXmlLoaderRewriter.Converter converter = this.mockConverter(xmlVal, "{thejson}", 1);
        tpl.setTextContent(xmlVal);
        this.completeDocAsHtml(tpl);
        Assert.assertTrue((boolean)this.revisit(gadget, converter, tpl));
        EasyMock.verify((Object[])new Object[]{gadget});
        EasyMock.verify((Object[])new Object[]{converter});
        Node head = DomUtil.getFirstNamedChildNode((Node)this.doc.getDocumentElement(), (String)"head");
        Assert.assertNotNull((Object)head);
        Assert.assertEquals((long)2L, (long)head.getChildNodes().getLength());
        Node addedScript = head.getChildNodes().item(1);
        Assert.assertEquals((long)1L, (long)addedScript.getNodeType());
        Assert.assertEquals((Object)"script", (Object)addedScript.getNodeName());
        Assert.assertEquals((Object)("gadgets.jsondom.preload_('" + id + "',{thejson});"), (Object)addedScript.getTextContent());
    }

    @Test
    public void revisitMultiples() throws Exception {
        Element tplId = this.createRewritableDiv("tpl_id");
        Element tplName = this.createRewritableDiv();
        tplName.removeAttribute("id");
        tplName.setAttribute("name", "otherid");
        Gadget gadget = this.mockGadget("opensocial-templates", "another");
        String xmlVal = "thexml";
        OsTemplateXmlLoaderRewriter.Converter converter = this.mockConverter(xmlVal, "{thejson}", 2);
        tplId.setTextContent(xmlVal);
        tplName.setTextContent(xmlVal);
        this.completeDocAsHtml(tplId, tplName);
        Assert.assertTrue((boolean)this.revisit(gadget, converter, tplId, tplName));
        EasyMock.verify((Object[])new Object[]{gadget});
        EasyMock.verify((Object[])new Object[]{converter});
        Node head = DomUtil.getFirstNamedChildNode((Node)this.doc.getDocumentElement(), (String)"head");
        Assert.assertNotNull((Object)head);
        Assert.assertEquals((long)2L, (long)head.getChildNodes().getLength());
        Node addedScript = head.getChildNodes().item(1);
        Assert.assertEquals((long)1L, (long)addedScript.getNodeType());
        Assert.assertEquals((Object)"script", (Object)addedScript.getNodeName());
        Assert.assertEquals((Object)"gadgets.jsondom.preload_('tpl_id',{thejson});gadgets.jsondom.preload_('otherid',{thejson});", (Object)addedScript.getTextContent());
    }

    private boolean revisit(Gadget gadget, OsTemplateXmlLoaderRewriter.Converter converter, Node ... nodes) throws Exception {
        return new OsTemplateXmlLoaderRewriter.GadgetHtmlVisitor(converter).revisit(gadget, Arrays.asList(nodes));
    }

    private Gadget mockGadget(String ... features) {
        Gadget gadget = (Gadget)EasyMock.createMock(Gadget.class);
        EasyMock.expect((Object)gadget.getAllFeatures()).andReturn(Arrays.asList(features)).once();
        EasyMock.replay((Object[])new Object[]{gadget});
        return gadget;
    }

    private OsTemplateXmlLoaderRewriter.Converter mockConverter(String xml, String result, int times) {
        OsTemplateXmlLoaderRewriter.Converter converter = (OsTemplateXmlLoaderRewriter.Converter)EasyMock.createMock(OsTemplateXmlLoaderRewriter.Converter.class);
        EasyMock.expect((Object)converter.domToJson(xml)).andReturn((Object)result).times(times);
        EasyMock.replay((Object[])new Object[]{converter});
        return converter;
    }

    private Element createRewritableDiv() {
        return this.createRewritableDiv("id");
    }

    private Element createRewritableDiv(String id) {
        Element div = this.doc.createElement("div");
        div.setAttribute("type", "os/template");
        div.setAttribute("id", id);
        return div;
    }

    private void completeDocAsHtml(Node ... nodes) {
        Element html = this.doc.createElement("html");
        Element head = this.doc.createElement("head");
        Element headScript = this.doc.createElement("script");
        head.appendChild(headScript);
        Element body = this.doc.createElement("body");
        for (Node node : nodes) {
            body.appendChild(node);
        }
        html.appendChild(head);
        html.appendChild(body);
        while (this.doc.hasChildNodes()) {
            this.doc.removeChild(this.doc.getFirstChild());
        }
        this.doc.appendChild(html);
    }

    @Test
    public void rewriteHttpNoMime() throws Exception {
        this.checkRewriteHttp(null, null, false);
    }

    @Test
    public void rewriteHttpMismatchedMime() throws Exception {
        this.checkRewriteHttp("os/template-not!", null, false);
    }

    @Test
    public void rewriteHttpMimeMatchOverride() throws Exception {
        this.checkRewriteHttp("os/template", "os/template-not!", true);
    }

    @Test
    public void rewriteHttpMimeMatchOriginal() throws Exception {
        this.checkRewriteHttp(null, "os/template", true);
    }

    @Test
    public void rewriteHttpMimeMatchOverrideMismatchOriginal() throws Exception {
        this.checkRewriteHttp("foo", "os/template", false);
    }

    private void checkRewriteHttp(String reqMime, String origMime, boolean expectRewrite) throws Exception {
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://dummy.com")).setRewriteMimeType(reqMime);
        HttpResponse resp = new HttpResponseBuilder().setHeader("Content-Type", origMime).create();
        String inXml = "thexml";
        String outJson = "{thejson}";
        OsTemplateXmlLoaderRewriter.Converter converter = this.mockConverter(inXml, outJson, 1);
        MutableContent mc = (MutableContent)EasyMock.createMock(MutableContent.class);
        if (expectRewrite) {
            EasyMock.expect((Object)mc.getContent()).andReturn((Object)inXml).once();
            mc.setContent(outJson);
            EasyMock.expectLastCall().once();
        }
        EasyMock.replay((Object[])new Object[]{mc});
        boolean result = new OsTemplateXmlLoaderRewriter(converter).rewrite(req, resp, mc);
        Assert.assertEquals((Object)expectRewrite, (Object)result);
        EasyMock.verify((Object[])new Object[]{mc});
        if (expectRewrite) {
            EasyMock.verify((Object[])new Object[]{converter});
        }
    }
}

