/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import javax.el.ELResolver;
import org.apache.shindig.common.JsonAssert;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.RootELResolver;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.apache.shindig.gadgets.preload.ConcurrentPreloaderService;
import org.apache.shindig.gadgets.preload.PipelineExecutor;
import org.apache.shindig.gadgets.preload.PipelinedDataPreloader;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.PreloaderService;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.PipelineDataGadgetRewriter;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.PipelinedData;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IMocksControl;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineDataGadgetRewriterTest {
    private IMocksControl control;
    private PipelinedDataPreloader preloader;
    private PreloaderService preloaderService;
    private PipelineDataGadgetRewriter rewriter;
    private GadgetSpec gadgetSpec;
    private Gadget gadget;
    private MutableContent content;
    private static final Uri GADGET_URI = Uri.parse((String)"http://example.org/gadget.php");
    private static final String CONTENT = "<script xmlns:os=\"http://ns.opensocial.org/2008/markup\" type=\"text/os-data\">  <os:PeopleRequest key=\"me\" userId=\"canonical\"/>  <os:HttpRequest key=\"json\" href=\"test.json\"/></script>";
    private static final String BLOCKED_FIRST_BATCH_CONTENT = "<script xmlns:os=\"http://ns.opensocial.org/2008/markup\" type=\"text/os-data\">  <os:PeopleRequest key=\"me\" userId=\"${json.user}\"/></script>";
    private static final String XML_WITHOUT_FEATURE = "<Module><ModulePrefs title=\"Title\"></ModulePrefs><Content>    <![CDATA[<script xmlns:os=\"http://ns.opensocial.org/2008/markup\" type=\"text/os-data\">  <os:PeopleRequest key=\"me\" userId=\"canonical\"/>  <os:HttpRequest key=\"json\" href=\"test.json\"/></script>]]></Content></Module>";
    private static final String XML_WITHOUT_PIPELINE = "<Module><ModulePrefs title=\"Title\"><Require feature=\"opensocial-data\"/></ModulePrefs><Content/></Module>";

    @Before
    public void setUp() throws Exception {
        this.control = EasyMock.createStrictControl();
        this.preloader = (PipelinedDataPreloader)this.control.createMock(PipelinedDataPreloader.class);
        this.preloaderService = new ConcurrentPreloaderService(Executors.newSingleThreadExecutor(), null);
        this.rewriter = new PipelineDataGadgetRewriter(new PipelineExecutor(this.preloader, this.preloaderService, Expressions.forTesting()));
    }

    private void setupGadget(String gadgetXml) throws SpecParserException {
        this.gadgetSpec = new GadgetSpec(GADGET_URI, gadgetXml);
        this.gadget = new Gadget();
        this.gadget.setSpec(this.gadgetSpec);
        this.gadget.setContext(new GadgetContext(){});
        this.gadget.setCurrentView(this.gadgetSpec.getView("default"));
        this.content = new MutableContent((GadgetHtmlParser)new NekoSimplifiedHtmlParser(new ParseModule.DOMImplementationProvider().get()), this.gadget.getCurrentView().getContent());
    }

    @Test
    public void rewrite() throws Exception {
        this.setupGadget(PipelineDataGadgetRewriterTest.getGadgetXml(CONTENT));
        Capture batchCapture = new Capture();
        Callable<PreloadedData> callable = this.createPreloadTask("key", "{result: {foo: 'bar'}}");
        EasyMock.expect((Object)this.preloader.createPreloadTasks((GadgetContext)EasyMock.same((Object)this.gadget.getContext()), (PipelinedData.Batch)EasyMock.and((Object)this.eqBatch(1, 1), (Object)EasyMock.capture((Capture)batchCapture)))).andReturn((Object)ImmutableList.of(callable));
        this.control.replay();
        this.rewriter.rewrite(this.gadget, this.content);
        Assert.assertTrue((String)"Script not inserted", (boolean)this.content.getContent().contains("DataContext.putDataSet(\"key\",{\"foo\":\"bar\"})"));
        Assert.assertFalse((String)"os-data wasn't deleted", (boolean)this.content.getContent().contains("type=\"text/os-data\""));
        Assert.assertTrue((boolean)((PipelinedData.Batch)batchCapture.getValue()).getPreloads().containsKey("me"));
        Assert.assertTrue((boolean)((PipelinedData.Batch)batchCapture.getValue()).getPreloads().containsKey("json"));
        Assert.assertFalse((boolean)this.gadget.getDirectFeatureDeps().contains("opensocial-data"));
        Assert.assertTrue((boolean)this.gadget.getDirectFeatureDeps().contains("opensocial-data-context"));
        this.control.verify();
    }

    @Test
    public void rewriteWithBlockedBatch() throws Exception {
        this.setupGadget(PipelineDataGadgetRewriterTest.getGadgetXml(BLOCKED_FIRST_BATCH_CONTENT));
        EasyMock.expect((Object)this.preloader.createPreloadTasks((GadgetContext)EasyMock.same((Object)this.gadget.getContext()), this.eqBatch(0, 0))).andReturn((Object)ImmutableList.of());
        this.control.replay();
        this.rewriter.rewrite(this.gadget, this.content);
        this.control.verify();
        Assert.assertFalse((String)"DataContext write shouldn't be present", (this.content.getContent().indexOf("DataContext.putDataSet(") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"os-data was deleted", (this.content.getContent().indexOf("type=\"text/os-data\"") > 0 ? 1 : 0) != 0);
    }

    private PipelinedData.Batch eqBatch(int socialCount, int httpCount) {
        EasyMock.reportMatcher((IArgumentMatcher)new BatchMatcher(socialCount, httpCount));
        return null;
    }

    @Test
    public void rewriteWithoutPipeline() throws Exception {
        this.setupGadget(XML_WITHOUT_PIPELINE);
        this.control.replay();
        this.rewriter.rewrite(this.gadget, this.content);
        this.control.verify();
    }

    @Test
    public void rewriteWithoutFeature() throws Exception {
        this.setupGadget(XML_WITHOUT_FEATURE);
        this.control.replay();
        this.rewriter.rewrite(this.gadget, this.content);
        this.control.verify();
    }

    @Test
    public void parseOfDataRequest() throws Exception {
        String contentWithDataRequest = "<script xmlns:os=\"http://ns.opensocial.org/2008/markup\" type=\"text/os-data\">  <os:DataRequest key=\"me\" method=\"people.get\" userId=\"canonical\"/></script>";
        this.setupGadget(PipelineDataGadgetRewriterTest.getGadgetXml("<script xmlns:os=\"http://ns.opensocial.org/2008/markup\" type=\"text/os-data\">  <os:DataRequest key=\"me\" method=\"people.get\" userId=\"canonical\"/></script>"));
        Map pipelines = this.rewriter.parsePipelinedData(this.gadget, this.content.getDocument());
        Assert.assertEquals((long)1L, (long)pipelines.size());
        PipelinedData pipeline = (PipelinedData)pipelines.keySet().iterator().next();
        PipelinedData.Batch batch = pipeline.getBatch(Expressions.forTesting(), (ELResolver)new RootELResolver());
        Map preloads = batch.getPreloads();
        Assert.assertTrue((boolean)preloads.containsKey("me"));
        Assert.assertEquals((Object)PipelinedData.BatchType.SOCIAL, (Object)((PipelinedData.BatchItem)preloads.get("me")).getType());
        JsonAssert.assertObjectEquals((Object)"{params: {userId: 'canonical'}, method: 'people.get', id: 'me'}", (Object)((PipelinedData.BatchItem)preloads.get("me")).getData());
    }

    private Callable<PreloadedData> createPreloadTask(String key, String jsonResult) throws JSONException {
        final JSONObject value = new JSONObject(jsonResult);
        value.put("id", (Object)key);
        final PreloadedData preloadResult = new PreloadedData(){

            public Collection<Object> toJson() throws PreloadException {
                return ImmutableList.of((Object)value);
            }
        };
        Callable<PreloadedData> callable = new Callable<PreloadedData>(){

            @Override
            public PreloadedData call() throws Exception {
                return preloadResult;
            }
        };
        return callable;
    }

    private static String getGadgetXml(String content) {
        return "<Module><ModulePrefs title='Title'><Require feature='opensocial-data'/></ModulePrefs><Content>    <![CDATA[" + content + "]]>" + "</Content></Module>";
    }

    private static class BatchMatcher
    implements IArgumentMatcher {
        private final int socialCount;
        private final int httpCount;

        public BatchMatcher(int socialCount, int httpCount) {
            this.socialCount = socialCount;
            this.httpCount = httpCount;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append("eqBuffer[social=" + this.socialCount + ",http=" + this.httpCount + ']');
        }

        public boolean matches(Object obj) {
            if (!(obj instanceof PipelinedData.Batch)) {
                return false;
            }
            PipelinedData.Batch batch = (PipelinedData.Batch)obj;
            int actualSocialCount = 0;
            int actualHttpCount = 0;
            for (PipelinedData.BatchItem item : batch.getPreloads().values()) {
                if (item.getType() == PipelinedData.BatchType.HTTP) {
                    ++actualHttpCount;
                    continue;
                }
                if (item.getType() != PipelinedData.BatchType.SOCIAL) continue;
                ++actualSocialCount;
            }
            return this.socialCount == actualSocialCount && this.httpCount == actualHttpCount;
        }
    }
}

