/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.JsonAssert;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.testing.TestExecutorService;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.servlet.FakeIframeUriManager;
import org.apache.shindig.gadgets.servlet.FakeProcessor;
import org.apache.shindig.gadgets.servlet.GadgetsHandler;
import org.apache.shindig.gadgets.servlet.GadgetsHandlerService;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.RpcHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanFilter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class GadgetsHandlerTest
extends EasyMockTestCase {
    private static final String GADGET1_URL = FakeProcessor.SPEC_URL.toString();
    private static final String GADGET2_URL = FakeProcessor.SPEC_URL2.toString();
    private static final String CONTAINER = "container";
    private static final String TOKEN = "_nekot_";
    private final FakeProcessor processor = new FakeProcessor();
    private final FakeIframeUriManager urlGenerator = new FakeIframeUriManager();
    private final Map<String, FormDataItem> emptyFormItems = Collections.emptyMap();
    private Injector injector;
    private BeanJsonConverter converter;
    private HandlerRegistry registry;
    private FakeGadgetToken token;

    @Before
    public void setUp() throws Exception {
        this.injector = Guice.createInjector((Module[])new Module[0]);
        this.converter = new BeanJsonConverter(this.injector);
        this.token = new FakeGadgetToken();
        this.token.setAppUrl("http://www.example.com/gadget.xml");
    }

    private void registerGadgetsHandler(SecurityTokenCodec codec) {
        BeanFilter beanFilter = new BeanFilter();
        GadgetsHandlerService service = new GadgetsHandlerService((Processor)this.processor, (IframeUriManager)this.urlGenerator, codec, beanFilter);
        GadgetsHandler handler = new GadgetsHandler((ExecutorService)new TestExecutorService(), service, beanFilter);
        this.registry = new DefaultHandlerRegistry(this.injector, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)ImmutableSet.of((Object)handler));
    }

    private JSONObject makeMetadataRequest(String lang, String country, String ... uris) throws JSONException {
        JSONObject req = new JSONObject().put("method", (Object)"gadgets.metadata").put("id", (Object)"req1").put("params", (Object)new JSONObject().put("ids", (Collection)ImmutableList.copyOf((Object[])uris)).put(CONTAINER, (Object)CONTAINER));
        if (lang != null) {
            req.put("language", (Object)lang);
        }
        if (country != null) {
            req.put("country", (Object)country);
        }
        return req;
    }

    private JSONObject makeTokenRequest(String ... uris) throws JSONException {
        JSONObject req = new JSONObject().put("method", (Object)"gadgets.token").put("id", (Object)"req1").put("params", (Object)new JSONObject().put("ids", (Collection)ImmutableList.copyOf((Object[])uris)).put(CONTAINER, (Object)CONTAINER));
        return req;
    }

    @Test
    public void testMetadataEmptyRequest() throws Exception {
        this.registerGadgetsHandler(null);
        JSONObject request = this.makeMetadataRequest(null, null, new String[0]);
        RpcHandler operation = this.registry.getRpcHandler(request);
        Object empty = operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        JsonAssert.assertJsonEquals((String)"{}", (String)this.converter.convertToString(empty));
    }

    @Test
    public void testTokenEmptyRequest() throws Exception {
        this.registerGadgetsHandler(null);
        JSONObject request = this.makeTokenRequest(new String[0]);
        RpcHandler operation = this.registry.getRpcHandler(request);
        Object empty = operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        JsonAssert.assertJsonEquals((String)"{}", (String)this.converter.convertToString(empty));
    }

    @Test(expected=ExecutionException.class)
    public void testMetadataInvalidUrl() throws Exception {
        this.registerGadgetsHandler(null);
        JSONObject request = this.makeMetadataRequest(null, null, "[moo]");
        RpcHandler operation = this.registry.getRpcHandler(request);
        operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
    }

    @Test(expected=ExecutionException.class)
    public void testTokenInvalidUrl() throws Exception {
        this.registerGadgetsHandler(null);
        JSONObject request = this.makeTokenRequest("[moo]");
        RpcHandler operation = this.registry.getRpcHandler(request);
        operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
    }

    @Test
    public void testMetadataOneGadget() throws Exception {
        this.registerGadgetsHandler(null);
        JSONObject request = this.makeMetadataRequest(null, null, GADGET1_URL);
        RpcHandler operation = this.registry.getRpcHandler(request);
        Object responseObj = operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        JSONObject response = new JSONObject(this.converter.convertToString(responseObj));
        JSONObject gadget = response.getJSONObject(GADGET1_URL);
        GadgetsHandlerTest.assertEquals((Object)FakeIframeUriManager.DEFAULT_IFRAME_URI.toString(), (Object)gadget.getString("iframeUrl"));
        GadgetsHandlerTest.assertEquals((Object)"JSON-TEST", (Object)gadget.getJSONObject("modulePrefs").getString("title"));
        JSONObject view = gadget.getJSONObject("views").getJSONObject("default");
        GadgetsHandlerTest.assertEquals((long)100L, (long)view.getInt("preferredHeight"));
        GadgetsHandlerTest.assertEquals((long)242L, (long)view.getInt("preferredWidth"));
        GadgetsHandlerTest.assertEquals((Object)"http://example.org/foo", (Object)gadget.getJSONObject("modulePrefs").getJSONObject("links").getJSONObject("rel").getString("href"));
        JSONObject userPrefs = gadget.getJSONObject("userPrefs");
        GadgetsHandlerTest.assertNotNull((Object)userPrefs);
        JSONObject userPrefData = userPrefs.getJSONObject("up_one");
        GadgetsHandlerTest.assertNotNull((Object)userPrefData);
        JSONObject upEnums = userPrefData.getJSONObject("enumValues");
        GadgetsHandlerTest.assertNotNull((Object)upEnums);
        GadgetsHandlerTest.assertEquals((Object)"disp1", (Object)upEnums.get("val1"));
        GadgetsHandlerTest.assertEquals((Object)"disp2", (Object)upEnums.get("abc"));
        GadgetsHandlerTest.assertEquals((Object)"disp3", (Object)upEnums.get("z_xabc"));
        GadgetsHandlerTest.assertEquals((Object)"disp4", (Object)upEnums.get("foo"));
        JSONArray orderedEnums = userPrefData.getJSONArray("orderedEnumValues");
        GadgetsHandlerTest.assertNotNull((Object)orderedEnums);
        GadgetsHandlerTest.assertEquals((long)4L, (long)orderedEnums.length());
        GadgetsHandlerTest.assertEquals((Object)"val1", (Object)orderedEnums.getJSONObject(0).getString("value"));
        GadgetsHandlerTest.assertEquals((Object)"abc", (Object)orderedEnums.getJSONObject(1).getString("value"));
        GadgetsHandlerTest.assertEquals((Object)"z_xabc", (Object)orderedEnums.getJSONObject(2).getString("value"));
        GadgetsHandlerTest.assertEquals((Object)"foo", (Object)orderedEnums.getJSONObject(3).getString("value"));
    }

    @Test
    public void testTokenOneGadget() throws Exception {
        SecurityTokenCodec codec = (SecurityTokenCodec)EasyMock.createMock(SecurityTokenCodec.class);
        Capture tokenCapture = new Capture();
        EasyMock.expect((Object)codec.encodeToken((SecurityToken)EasyMock.capture((Capture)tokenCapture))).andReturn((Object)TOKEN);
        this.replay(codec);
        this.registerGadgetsHandler(codec);
        JSONObject request = this.makeTokenRequest(GADGET1_URL);
        RpcHandler operation = this.registry.getRpcHandler(request);
        Object responseObj = operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        JSONObject response = new JSONObject(this.converter.convertToString(responseObj));
        JSONObject gadget = response.getJSONObject(GADGET1_URL);
        GadgetsHandlerTest.assertEquals((Object)TOKEN, (Object)gadget.getString("token"));
        GadgetsHandlerTest.assertFalse((boolean)gadget.has("error"));
        GadgetsHandlerTest.assertEquals((Object)CONTAINER, (Object)((SecurityToken)tokenCapture.getValue()).getContainer());
        GadgetsHandlerTest.assertEquals((Object)GADGET1_URL, (Object)((SecurityToken)tokenCapture.getValue()).getAppId());
        GadgetsHandlerTest.assertEquals((Object)GADGET1_URL, (Object)((SecurityToken)tokenCapture.getValue()).getAppUrl());
        GadgetsHandlerTest.assertSame((Object)this.token.getOwnerId(), (Object)((SecurityToken)tokenCapture.getValue()).getOwnerId());
        GadgetsHandlerTest.assertSame((Object)this.token.getViewerId(), (Object)((SecurityToken)tokenCapture.getValue()).getViewerId());
    }

    @Test
    public void testMetadataOneGadgetFailure() throws Exception {
        this.registerGadgetsHandler(null);
        JSONObject request = this.makeMetadataRequest(null, null, GADGET1_URL);
        this.urlGenerator.throwRandomFault = true;
        RpcHandler operation = this.registry.getRpcHandler(request);
        Object responseObj = operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        JSONObject response = new JSONObject(this.converter.convertToString(responseObj));
        JSONObject gadget = response.getJSONObject(GADGET1_URL);
        GadgetsHandlerTest.assertEquals((Object)"Failed to get gadget metadata.", (Object)gadget.getString("error"));
    }

    @Test
    public void testTokenOneGadgetFailure() throws Exception {
        SecurityTokenCodec codec = (SecurityTokenCodec)EasyMock.createMock(SecurityTokenCodec.class);
        EasyMock.expect((Object)codec.encodeToken((SecurityToken)EasyMock.isA(SecurityToken.class))).andThrow((Throwable)new SecurityTokenException("blah"));
        this.replay(codec);
        this.registerGadgetsHandler(codec);
        JSONObject request = this.makeTokenRequest(GADGET1_URL);
        RpcHandler operation = this.registry.getRpcHandler(request);
        Object responseObj = operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        JSONObject response = new JSONObject(this.converter.convertToString(responseObj));
        JSONObject gadget = response.getJSONObject(GADGET1_URL);
        GadgetsHandlerTest.assertFalse((boolean)gadget.has("token"));
        GadgetsHandlerTest.assertEquals((Object)"Failed to get gadget token.", (Object)gadget.getString("error"));
    }

    @Test
    public void testMetadataMultipleGadgets() throws Exception {
        this.registerGadgetsHandler(null);
        JSONObject request = this.makeMetadataRequest("en", "US", GADGET1_URL, GADGET2_URL);
        RpcHandler operation = this.registry.getRpcHandler(request);
        Object responseObj = operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        JSONObject response = new JSONObject(this.converter.convertToString(responseObj));
        JSONObject modulePrefs1 = response.getJSONObject(GADGET1_URL).getJSONObject("modulePrefs");
        GadgetsHandlerTest.assertEquals((Object)"JSON-TEST", (Object)modulePrefs1.getString("title"));
        JSONObject modulePrefs2 = response.getJSONObject(GADGET2_URL).getJSONObject("modulePrefs");
        GadgetsHandlerTest.assertEquals((Object)"JSON-TEST2", (Object)modulePrefs2.getString("title"));
    }

    @Test
    public void testTokenMultipleGadgetsWithSuccessAndFailure() throws Exception {
        SecurityTokenCodec codec = (SecurityTokenCodec)EasyMock.createMock(SecurityTokenCodec.class);
        EasyMock.expect((Object)codec.encodeToken((SecurityToken)EasyMock.isA(SecurityToken.class))).andReturn((Object)TOKEN);
        EasyMock.expect((Object)codec.encodeToken((SecurityToken)EasyMock.isA(SecurityToken.class))).andThrow((Throwable)new SecurityTokenException("blah"));
        this.replay(codec);
        this.registerGadgetsHandler(codec);
        JSONObject request = this.makeTokenRequest(GADGET1_URL, GADGET2_URL);
        RpcHandler operation = this.registry.getRpcHandler(request);
        Object responseObj = operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        JSONObject response = new JSONObject(this.converter.convertToString(responseObj));
        JSONObject gadget1 = response.getJSONObject(GADGET1_URL);
        GadgetsHandlerTest.assertEquals((Object)TOKEN, (Object)gadget1.getString("token"));
        GadgetsHandlerTest.assertFalse((boolean)gadget1.has("error"));
        JSONObject gadget2 = response.getJSONObject(GADGET2_URL);
        GadgetsHandlerTest.assertFalse((boolean)gadget2.has("token"));
        GadgetsHandlerTest.assertEquals((Object)"Failed to get gadget token.", (Object)gadget2.getString("error"));
    }

    @Test
    public void testMetadataMultipleGadgetsWithFailure() throws Exception {
        this.registerGadgetsHandler(null);
        JSONObject request = this.makeMetadataRequest("en", "US", GADGET1_URL, GADGET2_URL);
        this.processor.exceptions.put(FakeProcessor.SPEC_URL2, new ProcessingException("broken", 400));
        RpcHandler operation = this.registry.getRpcHandler(request);
        Object responseObj = operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        JSONObject response = new JSONObject(this.converter.convertToString(responseObj));
        JSONObject modulePrefs1 = response.getJSONObject(GADGET1_URL).getJSONObject("modulePrefs");
        GadgetsHandlerTest.assertEquals((Object)"JSON-TEST", (Object)modulePrefs1.getString("title"));
        JSONObject gadget2 = response.getJSONObject(GADGET2_URL);
        GadgetsHandlerTest.assertNotNull((String)"got gadget2", (Object)gadget2);
        GadgetsHandlerTest.assertEquals((Object)"Failed to get gadget metadata.", (Object)gadget2.getString("error"));
    }
}

