/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junitx.framework.StringAssert;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.servlet.HttpServletResponseRecorder;
import org.apache.shindig.common.servlet.HttpUtilTest;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.servlet.MakeRequestHandler;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class MakeRequestHandlerTest
extends ServletTestFixture {
    private static final Uri REQUEST_URL = Uri.parse((String)"http://example.org/file");
    private static final String REQUEST_BODY = "I+am+the+request+body!foo=baz%20la";
    private static final String RESPONSE_BODY = "makeRequest response body";
    private static final SecurityToken DUMMY_TOKEN = new FakeGadgetToken();
    private final MakeRequestHandler handler;

    public MakeRequestHandlerTest() {
        this.handler = new MakeRequestHandler(this.pipeline, this.rewriterRegistry);
    }

    private void expectGetAndReturnBody(String response) throws Exception {
        this.expectGetAndReturnBody(AuthType.NONE, response);
    }

    private void expectGetAndReturnBody(AuthType authType, String response) throws Exception {
        HttpRequest request = new HttpRequest(REQUEST_URL).setAuthType(authType);
        EasyMock.expect((Object)this.pipeline.execute(request)).andReturn((Object)new HttpResponse(response));
    }

    private void expectPostAndReturnBody(String postData, String response) throws Exception {
        this.expectPostAndReturnBody(AuthType.NONE, postData, response);
    }

    private void expectPostAndReturnBody(AuthType authType, String postData, String response) throws Exception {
        HttpRequest req = new HttpRequest(REQUEST_URL).setMethod("POST").setPostBody(REQUEST_BODY.getBytes("UTF-8")).setAuthType(authType).addHeader("Content-Type", "application/x-www-form-urlencoded");
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)new HttpResponse(response));
        EasyMock.expect((Object)this.request.getParameter("httpMethod")).andReturn((Object)"POST");
        EasyMock.expect((Object)this.request.getParameter("postData")).andReturn((Object)REQUEST_BODY);
    }

    private JSONObject extractJsonFromResponse() throws JSONException {
        String body = this.recorder.getResponseAsString();
        StringAssert.assertStartsWith((String)"throw 1; < don't be evil' >", (String)body);
        body = body.substring("throw 1; < don't be evil' >".length());
        return new JSONObject(body).getJSONObject(REQUEST_URL.toString());
    }

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.request.getMethod()).andReturn((Object)"POST").anyTimes();
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.URL.getKey())).andReturn((Object)REQUEST_URL.toString()).anyTimes();
    }

    @Test
    public void testGetRequest() throws Exception {
        this.expectGetAndReturnBody(RESPONSE_BODY);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((long)200L, (long)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testGetRequestWithUncommonStatusCode() throws Exception {
        HttpRequest req = new HttpRequest(REQUEST_URL);
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(201).setResponseString(RESPONSE_BODY).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)response);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((long)201L, (long)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testGetRequestWithRefresh() throws Exception {
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.REFRESH.getKey())).andReturn((Object)"120").anyTimes();
        Capture requestCapture = new Capture();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.capture((Capture)requestCapture))).andReturn((Object)new HttpResponse(RESPONSE_BODY));
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        HttpRequest httpRequest = (HttpRequest)requestCapture.getValue();
        MakeRequestHandlerTest.assertEquals((Object)"public,max-age=120", (Object)this.recorder.getHeader("Cache-Control"));
        MakeRequestHandlerTest.assertEquals((long)120L, (long)httpRequest.getCacheTtl());
    }

    @Test
    public void testGetRequestWithBadTtl() throws Exception {
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.REFRESH.getKey())).andReturn((Object)"foo").anyTimes();
        Capture requestCapture = new Capture();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.capture((Capture)requestCapture))).andReturn((Object)new HttpResponse(RESPONSE_BODY));
        this.replay();
        try {
            this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        }
        catch (GadgetException e) {
            // empty catch block
        }
        HttpRequest httpRequest = (HttpRequest)requestCapture.getValue();
        MakeRequestHandlerTest.assertEquals(null, (Object)this.recorder.getHeader("Cache-Control"));
        MakeRequestHandlerTest.assertEquals((long)-1L, (long)httpRequest.getCacheTtl());
    }

    @Test
    public void testExplicitHeaders() throws Exception {
        String headerString = "X-Foo=bar&X-Bar=baz%20foo";
        HttpRequest expected = new HttpRequest(REQUEST_URL).addHeader("X-Foo", "bar").addHeader("X-Bar", "baz foo");
        EasyMock.expect((Object)this.pipeline.execute(expected)).andReturn((Object)new HttpResponse(RESPONSE_BODY));
        EasyMock.expect((Object)this.request.getParameter("headers")).andReturn((Object)headerString);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((long)200L, (long)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testPostRequest() throws Exception {
        EasyMock.expect((Object)this.request.getParameter("httpMethod")).andReturn((Object)"POST");
        this.expectPostAndReturnBody(REQUEST_BODY, RESPONSE_BODY);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((long)200L, (long)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testFetchContentTypeFeed() throws Exception {
        String entryTitle = "Feed title";
        String entryLink = "http://example.org/entry/0/1";
        String entrySummary = "This is the summary";
        String rss = "<?xml version=\"1.0\" encoding=\"utf-8\"?><rss version=\"2.0\"><channel><title>dummy</title><link>http://example.org/</link><item><title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "</channel></rss>";
        this.expectGetAndReturnBody(rss);
        EasyMock.expect((Object)this.request.getParameter("contentType")).andReturn((Object)"FEED");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        JSONObject feed = new JSONObject(results.getString("body"));
        JSONObject entry = feed.getJSONArray("Entry").getJSONObject(0);
        MakeRequestHandlerTest.assertEquals((Object)entryTitle, (Object)entry.getString("Title"));
        MakeRequestHandlerTest.assertEquals((Object)entryLink, (Object)entry.getString("Link"));
        MakeRequestHandlerTest.assertNull((String)"getSummaries has the wrong default value (should be false).", (Object)entry.optString("Summary", null));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testFetchFeedWithParameters() throws Exception {
        String entryTitle = "Feed title";
        String entryLink = "http://example.org/entry/0/1";
        String entrySummary = "This is the summary";
        String rss = "<?xml version=\"1.0\" encoding=\"utf-8\"?><rss version=\"2.0\"><channel><title>dummy</title><link>http://example.org/</link><item><title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "<item>" + "<title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "<item>" + "<title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "</channel></rss>";
        this.expectGetAndReturnBody(rss);
        EasyMock.expect((Object)this.request.getParameter("getSummaries")).andReturn((Object)"true");
        EasyMock.expect((Object)this.request.getParameter("numEntries")).andReturn((Object)"2");
        EasyMock.expect((Object)this.request.getParameter("contentType")).andReturn((Object)"FEED");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        JSONObject feed = new JSONObject(results.getString("body"));
        JSONArray feeds = feed.getJSONArray("Entry");
        MakeRequestHandlerTest.assertEquals((String)"numEntries not parsed correctly.", (long)2L, (long)feeds.length());
        JSONObject entry = feeds.getJSONObject(1);
        MakeRequestHandlerTest.assertEquals((Object)entryTitle, (Object)entry.getString("Title"));
        MakeRequestHandlerTest.assertEquals((Object)entryLink, (Object)entry.getString("Link"));
        MakeRequestHandlerTest.assertTrue((String)"getSummaries not parsed correctly.", (boolean)entry.has("Summary"));
        MakeRequestHandlerTest.assertEquals((Object)entrySummary, (Object)entry.getString("Summary"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testFetchEmptyDocument() throws Exception {
        this.expectGetAndReturnBody("");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((long)200L, (long)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)"", (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    private void expectParameters(HttpServletRequest request, String ... params) {
        final ArrayList v = Lists.newArrayList((Object[])params);
        EasyMock.expect((Object)request.getParameterNames()).andStubAnswer((IAnswer)new IAnswer<Enumeration<String>>(){

            public Enumeration<String> answer() throws Throwable {
                return Collections.enumeration(v);
            }
        });
    }

    @Test
    public void testSignedGetRequest() throws Exception {
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn((Object)DUMMY_TOKEN).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)AuthType.SIGNED.toString()).atLeastOnce();
        HttpRequest expected = new HttpRequest(REQUEST_URL).setAuthType(AuthType.SIGNED);
        EasyMock.expect((Object)this.pipeline.execute(expected)).andReturn((Object)new HttpResponse(RESPONSE_BODY));
        this.expectParameters(this.request, "authz");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testSignedPostRequest() throws Exception {
        this.expectPostAndReturnBody(AuthType.SIGNED, REQUEST_BODY, RESPONSE_BODY);
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn((Object)DUMMY_TOKEN).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)AuthType.SIGNED.toString()).atLeastOnce();
        this.expectParameters(this.request, "httpMethod", "postData", "authz");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertFalse((String)"A security token was returned when it was not requested.", (boolean)results.has("st"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testChangeSecurityToken() throws Exception {
        this.expectGetAndReturnBody(AuthType.SIGNED, RESPONSE_BODY);
        FakeGadgetToken authToken = new FakeGadgetToken().setUpdatedToken("updated");
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn((Object)authToken).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)AuthType.SIGNED.toString()).atLeastOnce();
        this.expectParameters(this.request, "authz");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertEquals((Object)"updated", (Object)results.getString("st"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testDoOAuthRequest() throws Exception {
        this.expectGetAndReturnBody(AuthType.OAUTH, RESPONSE_BODY);
        FakeGadgetToken authToken = new FakeGadgetToken().setUpdatedToken("updated");
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn((Object)authToken).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)AuthType.OAUTH.toString()).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameterMap()).andStubReturn(Collections.emptyMap());
        this.expectParameters(this.request, new String[0]);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((long)200L, (long)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testInvalidSigningTypeTreatedAsNone() throws Exception {
        this.expectGetAndReturnBody(RESPONSE_BODY);
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)"garbage");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((long)200L, (long)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testBadHttpResponseIsPropagated() throws Exception {
        HttpRequest internalRequest = new HttpRequest(REQUEST_URL);
        EasyMock.expect((Object)this.pipeline.execute(internalRequest)).andReturn((Object)HttpResponse.error());
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((long)500L, (long)results.getInt("rc"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test(expected=GadgetException.class)
    public void testBadSecurityTokenThrows() throws Exception {
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)AuthType.SIGNED.toString()).atLeastOnce();
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
    }

    @Test
    public void testMetadataCopied() throws Exception {
        HttpRequest internalRequest = new HttpRequest(REQUEST_URL);
        HttpResponse response = new HttpResponseBuilder().setResponse("foo".getBytes("UTF-8")).setMetadata("foo", RESPONSE_BODY).create();
        EasyMock.expect((Object)this.pipeline.execute(internalRequest)).andReturn((Object)response);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.getString("foo"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testSetCookiesReturned() throws Exception {
        HttpRequest internalRequest = new HttpRequest(REQUEST_URL);
        HttpResponse response = new HttpResponseBuilder().setResponse("foo".getBytes("UTF-8")).addHeader("Set-Cookie", "foo=bar; Secure").addHeader("Set-Cookie", "name=value").create();
        EasyMock.expect((Object)this.pipeline.execute(internalRequest)).andReturn((Object)response);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        JSONObject headers = results.getJSONObject("headers");
        MakeRequestHandlerTest.assertNotNull((Object)headers);
        JSONArray cookies = headers.getJSONArray("set-cookie");
        MakeRequestHandlerTest.assertNotNull((Object)cookies);
        MakeRequestHandlerTest.assertEquals((long)2L, (long)cookies.length());
        MakeRequestHandlerTest.assertEquals((Object)"foo=bar; Secure", (Object)cookies.get(0));
        MakeRequestHandlerTest.assertEquals((Object)"name=value", (Object)cookies.get(1));
    }

    @Test
    public void testLocationReturned() throws Exception {
        HttpRequest internalRequest = new HttpRequest(REQUEST_URL);
        HttpResponse response = new HttpResponseBuilder().setResponse("foo".getBytes("UTF-8")).addHeader("Location", "somewhere else").create();
        EasyMock.expect((Object)this.pipeline.execute(internalRequest)).andReturn((Object)response);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        JSONObject headers = results.getJSONObject("headers");
        MakeRequestHandlerTest.assertNotNull((Object)headers);
        JSONArray locations = headers.getJSONArray("location");
        MakeRequestHandlerTest.assertNotNull((Object)locations);
        MakeRequestHandlerTest.assertEquals((long)1L, (long)locations.length());
        MakeRequestHandlerTest.assertEquals((Object)"somewhere else", (Object)locations.get(0));
    }

    @Test
    public void testSetResponseHeaders() throws Exception {
        HttpResponse results = new HttpResponseBuilder().create();
        this.replay();
        MakeRequestHandler.setResponseHeaders((HttpServletRequest)this.request, (HttpServletResponse)this.recorder, (HttpResponse)results);
        MakeRequestHandlerTest.assertNotNull((String)"Expires header not set", (Object)this.recorder.getHeader("Expires"));
        MakeRequestHandlerTest.assertNotNull((String)"Cache-Control header not set", (Object)this.recorder.getHeader("Cache-Control"));
        MakeRequestHandlerTest.assertEquals((Object)"attachment;filename=p.txt", (Object)this.recorder.getHeader("Content-Disposition"));
    }

    @Test
    public void testSetContentTypeHeader() throws Exception {
        HttpResponse results = new HttpResponseBuilder().create();
        this.replay();
        MakeRequestHandler.setResponseHeaders((HttpServletRequest)this.request, (HttpServletResponse)this.recorder, (HttpResponse)results);
        MakeRequestHandlerTest.assertEquals((Object)"application/octet-stream", (Object)this.recorder.getHeader("Content-Type"));
    }

    @Test
    public void testSetResponseHeadersNoCache() throws Exception {
        TreeMap headers = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        headers.put("Pragma", Arrays.asList("no-cache"));
        HttpResponse results = new HttpResponseBuilder().addHeader("Pragma", "no-cache").create();
        this.replay();
        MakeRequestHandler.setResponseHeaders((HttpServletRequest)this.request, (HttpServletResponse)this.recorder, (HttpResponse)results);
        MakeRequestHandlerTest.assertNotNull((String)"Expires header not set", (Object)this.recorder.getHeader("Expires"));
        MakeRequestHandlerTest.assertEquals((Object)"no-cache", (Object)this.recorder.getHeader("Pragma"));
        MakeRequestHandlerTest.assertEquals((Object)"no-cache", (Object)this.recorder.getHeader("Cache-Control"));
        MakeRequestHandlerTest.assertEquals((Object)"attachment;filename=p.txt", (Object)this.recorder.getHeader("Content-Disposition"));
    }

    @Test
    public void testSetResponseHeadersForceParam() throws Exception {
        HttpResponse results = new HttpResponseBuilder().create();
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.REFRESH.getKey())).andReturn((Object)"30").anyTimes();
        this.replay();
        System.out.println("request started at " + HttpUtilTest.testStartTime);
        MakeRequestHandler.setResponseHeaders((HttpServletRequest)this.request, (HttpServletResponse)this.recorder, (HttpResponse)results);
        HttpUtilTest.checkCacheControlHeaders((long)HttpUtilTest.testStartTime, (HttpServletResponseRecorder)this.recorder, (int)30, (boolean)false);
        MakeRequestHandlerTest.assertEquals((Object)"attachment;filename=p.txt", (Object)this.recorder.getHeader("Content-Disposition"));
    }

    @Test
    public void testSetResponseHeadersForceParamInvalid() throws Exception {
        HttpResponse results = new HttpResponseBuilder().create();
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.REFRESH.getKey())).andReturn((Object)"foo").anyTimes();
        this.replay();
        try {
            MakeRequestHandler.setResponseHeaders((HttpServletRequest)this.request, (HttpServletResponse)this.recorder, (HttpResponse)results);
        }
        catch (GadgetException e) {
            MakeRequestHandlerTest.assertEquals((Object)GadgetException.Code.INVALID_PARAMETER, (Object)e.getCode());
        }
    }

    @Test
    public void testGetParameter() {
        EasyMock.expect((Object)this.request.getParameter("foo")).andReturn((Object)"bar");
        this.replay();
        MakeRequestHandlerTest.assertEquals((Object)"bar", (Object)MakeRequestHandler.getParameter((HttpServletRequest)this.request, (String)"foo", (String)"not foo"));
    }

    @Test
    public void testGetParameterWithNullValue() {
        EasyMock.expect((Object)this.request.getParameter("foo")).andReturn(null);
        this.replay();
        MakeRequestHandlerTest.assertEquals((Object)"not foo", (Object)MakeRequestHandler.getParameter((HttpServletRequest)this.request, (String)"foo", (String)"not foo"));
    }

    @Test
    public void testGetContainerWithContainer() {
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.CONTAINER.getKey())).andReturn((Object)"bar");
        this.replay();
        MakeRequestHandlerTest.assertEquals((Object)"bar", (Object)MakeRequestHandler.getContainer((HttpServletRequest)this.request));
    }

    @Test
    public void testGetContainerWithSynd() {
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.CONTAINER.getKey())).andReturn(null);
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.SYND.getKey())).andReturn((Object)"syndtainer");
        this.replay();
        MakeRequestHandlerTest.assertEquals((Object)"syndtainer", (Object)MakeRequestHandler.getContainer((HttpServletRequest)this.request));
    }

    @Test
    public void testGetContainerNoParam() {
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.CONTAINER.getKey())).andReturn(null);
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.SYND.getKey())).andReturn(null);
        this.replay();
        MakeRequestHandlerTest.assertEquals((Object)"default", (Object)MakeRequestHandler.getContainer((HttpServletRequest)this.request));
    }
}

