/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.uri.AllJsIframeVersioner;
import org.apache.shindig.gadgets.uri.UriStatus;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AllJsIframeVersionerTest {
    private static final Uri GADGET_URI = null;
    private static final String CONTAINER = null;
    private AllJsIframeVersioner versioner;
    private String featureChecksum;

    @Before
    public void setUp() {
        String featureContent = "THE_FEATURE_CONTENT";
        String debugContent = "FEATURE_DEBUG_CONTENT";
        this.featureChecksum = HashUtil.checksum((byte[])(featureContent + debugContent).getBytes());
        FeatureRegistry registry = (FeatureRegistry)EasyMock.createMock(FeatureRegistry.class);
        FeatureResource.Simple resource = new FeatureResource.Simple(featureContent, debugContent);
        ArrayList allResources = Lists.newArrayList((Object[])new FeatureResource[]{resource});
        EasyMock.expect((Object)registry.getAllFeatures()).andReturn((Object)allResources).once();
        EasyMock.replay((Object[])new Object[]{registry});
        this.versioner = new AllJsIframeVersioner(registry);
        EasyMock.verify((Object[])new Object[]{registry});
    }

    @Test
    public void versionIsAsExpectedAlwaysTheSame() {
        Assert.assertEquals((Object)this.featureChecksum, (Object)this.versioner.version(GADGET_URI, CONTAINER));
        Assert.assertEquals((Object)this.featureChecksum, (Object)this.versioner.version(Uri.parse((String)"http://valid.com/"), "foo"));
    }

    @Test
    public void validateNull() {
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)this.versioner.validate(GADGET_URI, CONTAINER, null));
    }

    @Test
    public void validateEmpty() {
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)this.versioner.validate(GADGET_URI, CONTAINER, ""));
    }

    @Test
    public void validateMismatch() {
        Assert.assertEquals((Object)UriStatus.INVALID_VERSION, (Object)this.versioner.validate(GADGET_URI, CONTAINER, this.featureChecksum + "-not"));
    }

    @Test
    public void validateMatch() {
        Assert.assertEquals((Object)UriStatus.VALID_VERSIONED, (Object)this.versioner.validate(GADGET_URI, CONTAINER, this.featureChecksum));
    }
}

