/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.uri.ConcatUriManager;
import org.apache.shindig.gadgets.uri.DefaultConcatUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriManagerTestBase;
import org.apache.shindig.gadgets.uri.UriStatus;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DefaultConcatUriManagerTest
extends UriManagerTestBase {
    private static final String CONTAINER = "container";
    private static final Uri RESOURCE_1 = Uri.parse((String)"http://example.com/one.dat");
    private static final Uri RESOURCE_2 = Uri.parse((String)"http://gadgets.com/two.dat");
    private static final Uri RESOURCE_3 = Uri.parse((String)"http://foobar.com/three.dat");
    private static final List<Uri> RESOURCES_ONE = ImmutableList.of((Object)RESOURCE_1, (Object)RESOURCE_2, (Object)RESOURCE_3);
    private static final List<Uri> RESOURCES_TWO = ImmutableList.of((Object)RESOURCE_3, (Object)RESOURCE_2, (Object)RESOURCE_1);

    @Test
    public void typeCssBasicParams() throws Exception {
        this.checkBasicParams(ConcatUriManager.Type.CSS);
    }

    @Test
    public void typeCssAltParams() throws Exception {
        this.checkAltParams(ConcatUriManager.Type.CSS);
    }

    @Test
    public void typeCssBatch() throws Exception {
        this.checkBatchAdjacent(ConcatUriManager.Type.CSS);
    }

    @Test
    public void typeCssValidatedGeneratedBatch() throws Exception {
        this.checkValidatedBatchAdjacent(ConcatUriManager.Type.CSS);
    }

    @Test(expected=NoSuchElementException.class)
    public void typeCssBatchInsufficientVersions() throws Exception {
        this.checkBatchInsufficientVersions(ConcatUriManager.Type.CSS);
    }

    @Test(expected=RuntimeException.class)
    public void typeCssMissingHostConfig() throws Exception {
        this.checkMissingHostConfig(ConcatUriManager.Type.CSS);
    }

    @Test(expected=RuntimeException.class)
    public void typeCssMissingPathConfig() throws Exception {
        this.checkMissingPathConfig(ConcatUriManager.Type.CSS);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void typeCssSplitNotSupported() throws Exception {
        Gadget gadget = this.mockGadget(false, false);
        DefaultConcatUriManager manager = this.makeManager("host.com", "/foo", "token", null);
        ImmutableList resourceUris = ImmutableList.of(RESOURCES_ONE);
        manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)ConcatUriManager.Type.CSS), false);
    }

    @Test
    public void typeJsBasicParams() throws Exception {
        this.checkBasicParams(ConcatUriManager.Type.JS);
    }

    @Test
    public void typeJsAltParams() throws Exception {
        this.checkAltParams(ConcatUriManager.Type.JS);
    }

    @Test
    public void typeJsBatchAdjacent() throws Exception {
        this.checkBatchAdjacent(ConcatUriManager.Type.JS);
    }

    @Test
    public void typeJsBatchSplitBatched() throws Exception {
        Gadget gadget = this.mockGadget(false, false);
        String host = "host.com";
        String path = "/concat/path";
        ConcatUriManager.Type type = ConcatUriManager.Type.JS;
        String splitParam = "token";
        String[] versions = new String[]{"version1", "v2", "v3"};
        ConcatUriManager.Versioner versioner = this.makeVersioner(null, versions);
        DefaultConcatUriManager manager = this.makeManager(host, path, splitParam, versioner);
        ImmutableList resourceUris = ImmutableList.of(RESOURCES_ONE, RESOURCES_TWO, RESOURCES_ONE);
        List concatUris = manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)type), false);
        Assert.assertEquals((long)3L, (long)concatUris.size());
        for (int i = 0; i < 3; ++i) {
            ConcatUriManager.ConcatData uri = (ConcatUriManager.ConcatData)concatUris.get(i);
            Assert.assertEquals((Object)DefaultConcatUriManager.getJsSnippet((String)splitParam, (Uri)RESOURCE_1), (Object)uri.getSnippet(RESOURCE_1));
            Assert.assertEquals((Object)DefaultConcatUriManager.getJsSnippet((String)splitParam, (Uri)RESOURCE_2), (Object)uri.getSnippet(RESOURCE_2));
            Assert.assertEquals((Object)DefaultConcatUriManager.getJsSnippet((String)splitParam, (Uri)RESOURCE_3), (Object)uri.getSnippet(RESOURCE_3));
            Assert.assertNull((Object)uri.getUri().getScheme());
            Assert.assertEquals((Object)host, (Object)uri.getUri().getAuthority());
            Assert.assertEquals((Object)path, (Object)uri.getUri().getPath());
            Assert.assertEquals((long)10L, (long)uri.getUri().getQueryParameters().size());
            Assert.assertEquals((Object)CONTAINER, (Object)uri.getUri().getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
            Assert.assertEquals((Object)SPEC_URI.toString(), (Object)uri.getUri().getQueryParameter(UriCommon.Param.GADGET.getKey()));
            Assert.assertEquals((Object)type.getType(), (Object)uri.getUri().getQueryParameter(UriCommon.Param.TYPE.getKey()));
            Assert.assertEquals((Object)"0", (Object)uri.getUri().getQueryParameter(UriCommon.Param.DEBUG.getKey()));
            Assert.assertEquals((Object)"0", (Object)uri.getUri().getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
            Assert.assertEquals((Object)type.getType(), (Object)uri.getUri().getQueryParameter(UriCommon.Param.TYPE.getKey()));
            List<Uri> resList = i % 2 == 0 ? RESOURCES_ONE : RESOURCES_TWO;
            Assert.assertEquals((Object)resList.get(0).toString(), (Object)uri.getUri().getQueryParameter("1"));
            Assert.assertEquals((Object)resList.get(1).toString(), (Object)uri.getUri().getQueryParameter("2"));
            Assert.assertEquals((Object)resList.get(2).toString(), (Object)uri.getUri().getQueryParameter("3"));
            Assert.assertEquals((Object)versions[i], (Object)uri.getUri().getQueryParameter(UriCommon.Param.VERSION.getKey()));
        }
    }

    @Test
    public void typeJsValidatedGeneratedBatch() throws Exception {
        this.checkValidatedBatchAdjacent(ConcatUriManager.Type.JS);
    }

    @Test(expected=NoSuchElementException.class)
    public void typeJsBatchInsufficientVersions() throws Exception {
        Gadget gadget = this.mockGadget(true, true);
        String host = "bar.com";
        String path = "/other/path";
        String[] versions = new String[]{"v1"};
        ConcatUriManager.Versioner versioner = this.makeVersioner(null, versions);
        DefaultConcatUriManager manager = this.makeManager(host, path, "token", versioner);
        ImmutableList resourceUris = ImmutableList.of(RESOURCES_ONE, RESOURCES_ONE);
        manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)ConcatUriManager.Type.JS), true);
    }

    @Test(expected=RuntimeException.class)
    public void typeJsMissingHostConfig() throws Exception {
        Gadget gadget = this.mockGadget(false, false);
        DefaultConcatUriManager manager = this.makeManager(null, "/foo", "token", null);
        ImmutableList resourceUris = ImmutableList.of((Object)ImmutableList.of((Object)RESOURCE_1));
        manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)ConcatUriManager.Type.JS), false);
    }

    @Test(expected=RuntimeException.class)
    public void typeJsMissingPathConfig() throws Exception {
        Gadget gadget = this.mockGadget(false, false);
        DefaultConcatUriManager manager = this.makeManager("host.com", null, "token", null);
        ImmutableList resourceUris = ImmutableList.of((Object)ImmutableList.of((Object)RESOURCE_1));
        manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)ConcatUriManager.Type.JS), false);
    }

    @Test
    public void typeJsMissingSplitTokenConfig() throws Exception {
        Gadget gadget = this.mockGadget(false, false);
        DefaultConcatUriManager manager = this.makeManager("host.com", "/foo", null, null);
        ImmutableList resourceUris = ImmutableList.of((Object)ImmutableList.of((Object)RESOURCE_1));
        List concatUris = manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)ConcatUriManager.Type.JS), false);
        Assert.assertEquals((long)1L, (long)concatUris.size());
        Assert.assertNull((Object)((ConcatUriManager.ConcatData)concatUris.get(0)).getUri().getQueryParameter(UriCommon.Param.JSON.getKey()));
    }

    @Test
    public void jsEvalSnippet() {
        Assert.assertEquals((Object)("eval(_js['" + StringEscapeUtils.escapeJavaScript((String)RESOURCE_1.toString()) + "']);"), (Object)DefaultConcatUriManager.getJsSnippet((String)"_js", (Uri)RESOURCE_1));
    }

    @Test
    public void validateNoContainerStrict() {
        DefaultConcatUriManager manager = this.makeManager("host.com", "/path", null, null);
        manager.setUseStrictParsing(true);
        ConcatUriManager.ConcatUri validated = manager.process(Uri.parse((String)"http://host.com/path?q=f"));
        Assert.assertEquals((Object)UriStatus.BAD_URI, (Object)validated.getStatus());
    }

    @Test
    public void validateNoContainer() {
        DefaultConcatUriManager manager = this.makeManager("host.com", "/path", null, null);
        ConcatUriManager.ConcatUri validated = manager.process(Uri.parse((String)"http://host.com/path?q=f"));
        Assert.assertEquals((Object)UriStatus.BAD_URI, (Object)validated.getStatus());
    }

    @Test
    public void validateHostMismatchStrict() {
        DefaultConcatUriManager manager = this.makeManager("host.com", "/path", null, null);
        manager.setUseStrictParsing(true);
        ConcatUriManager.ConcatUri validated = manager.process(Uri.parse((String)("http://another.com/path?" + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + "&type=css")));
        Assert.assertEquals((Object)UriStatus.BAD_URI, (Object)validated.getStatus());
    }

    @Test
    public void validatePathMismatchStrict() {
        DefaultConcatUriManager manager = this.makeManager("host.com", "/path", null, null);
        manager.setUseStrictParsing(true);
        ConcatUriManager.ConcatUri validated = manager.process(Uri.parse((String)("http://host.com/another?" + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + "&type=css")));
        Assert.assertEquals((Object)UriStatus.BAD_URI, (Object)validated.getStatus());
    }

    @Test
    public void validateInvalidChildUri() {
        DefaultConcatUriManager manager = this.makeManager("host.com", "/path", null, null);
        ConcatUriManager.ConcatUri validated = manager.process(Uri.parse((String)("http://host.com/path?" + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + "&1=!!!")));
        Assert.assertEquals((Object)UriStatus.BAD_URI, (Object)validated.getStatus());
    }

    @Test
    public void validateNullTypeUri() {
        DefaultConcatUriManager manager = this.makeManager("host.com", "/path", null, null);
        ConcatUriManager.ConcatUri validated = manager.process(Uri.parse((String)("http://host.com/path?" + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + "&1=http://legit.com/1.dat")));
        Assert.assertEquals((Object)UriStatus.BAD_URI, (Object)validated.getStatus());
    }

    @Test
    public void validateBadTypeUri() {
        DefaultConcatUriManager manager = this.makeManager("host.com", "/path", null, null);
        ConcatUriManager.ConcatUri validated = manager.process(Uri.parse((String)("http://host.com/path?" + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + "&1=http://legit.com/1.dat&" + UriCommon.Param.TYPE.getKey() + "=NOTATYPE")));
        Assert.assertEquals((Object)UriStatus.BAD_URI, (Object)validated.getStatus());
    }

    @Test
    public void validateOldStyleTypeUri() {
        DefaultConcatUriManager manager = this.makeManager("host.com", "/path", null, null);
        ConcatUriManager.ConcatUri validated = manager.process(Uri.parse((String)("http://host.com/path?" + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + "&1=http://legit.com/1.dat&" + UriCommon.Param.TYPE.getKey() + "=NOTATYPE&rewriteMime=text/css")));
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)validated.getStatus());
        Assert.assertEquals((Object)ConcatUriManager.Type.CSS, (Object)validated.getType());
    }

    @Test
    public void validateCssUriUnversioned() {
        this.checkUnversionedUri(ConcatUriManager.Type.CSS, false);
    }

    @Test
    public void validateCssUriVersioned() {
        this.checkValidateUri(UriStatus.VALID_VERSIONED, ConcatUriManager.Type.CSS, false);
    }

    @Test
    public void validateCssUriBadVersion() {
        this.checkValidateUri(UriStatus.INVALID_VERSION, ConcatUriManager.Type.CSS, false);
    }

    @Test
    public void validateJsUriUnversioned() {
        this.checkUnversionedUri(ConcatUriManager.Type.JS, true);
    }

    @Test
    public void validateJsUriVersioned() {
        this.checkValidateUri(UriStatus.VALID_VERSIONED, ConcatUriManager.Type.JS, true);
    }

    @Test
    public void validateJsUriBadVersion() {
        this.checkValidateUri(UriStatus.INVALID_VERSION, ConcatUriManager.Type.JS, true);
    }

    private void checkUnversionedUri(ConcatUriManager.Type type, boolean hasSplit) {
        ConcatUriManager.Versioner versioner = this.makeVersioner(UriStatus.VALID_VERSIONED, new String[0]);
        DefaultConcatUriManager manager = this.makeManager("host.com", "/path", null, versioner);
        ConcatUriManager.ConcatUri validated = manager.process(Uri.parse((String)("http://host.com/path?" + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + "&1=http://legit.com/1.dat&2=http://another.com/2.dat&" + UriCommon.Param.TYPE.getKey() + '=' + type.getType() + '&' + UriCommon.Param.JSON.getKey() + "=split&" + UriCommon.Param.GADGET.getKey() + "=http://www.gadget.com/g.xml&" + UriCommon.Param.REFRESH.getKey() + "=123")));
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)validated.getStatus());
        Assert.assertEquals((Object)type, (Object)validated.getType());
        Assert.assertEquals((Object)CONTAINER, (Object)validated.getContainer());
        Assert.assertEquals((Object)"http://www.gadget.com/g.xml", (Object)validated.getGadget());
        Assert.assertEquals((long)2L, (long)validated.getBatch().size());
        Assert.assertEquals((Object)"http://legit.com/1.dat", (Object)((Uri)validated.getBatch().get(0)).toString());
        Assert.assertEquals((Object)"http://another.com/2.dat", (Object)((Uri)validated.getBatch().get(1)).toString());
        Assert.assertEquals((long)123L, (long)validated.getRefresh().intValue());
        Assert.assertEquals((Object)(hasSplit ? "split" : null), (Object)validated.getSplitParam());
    }

    private void checkValidateUri(UriStatus status, ConcatUriManager.Type type, boolean hasSplit) {
        ConcatUriManager.Versioner versioner = this.makeVersioner(status, new String[0]);
        DefaultConcatUriManager manager = this.makeManager("host.com", "/path", null, versioner);
        ConcatUriManager.ConcatUri validated = manager.process(Uri.parse((String)("http://host.com/path?" + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + "&1=http://legit.com/1.dat&2=http://another.com/2.dat&" + UriCommon.Param.TYPE.getKey() + '=' + type.getType() + '&' + UriCommon.Param.VERSION.getKey() + "=something&" + UriCommon.Param.JSON.getKey() + "=split&" + UriCommon.Param.GADGET.getKey() + "=http://www.gadget.com/g.xml&" + UriCommon.Param.REFRESH.getKey() + "=123")));
        Assert.assertEquals((Object)status, (Object)validated.getStatus());
        Assert.assertEquals((Object)type, (Object)validated.getType());
        Assert.assertEquals((Object)CONTAINER, (Object)validated.getContainer());
        Assert.assertEquals((Object)"http://www.gadget.com/g.xml", (Object)validated.getGadget());
        Assert.assertEquals((long)2L, (long)validated.getBatch().size());
        Assert.assertEquals((Object)"http://legit.com/1.dat", (Object)((Uri)validated.getBatch().get(0)).toString());
        Assert.assertEquals((Object)"http://another.com/2.dat", (Object)((Uri)validated.getBatch().get(1)).toString());
        Assert.assertEquals((long)123L, (long)validated.getRefresh().intValue());
        Assert.assertEquals((Object)(hasSplit ? "split" : null), (Object)validated.getSplitParam());
    }

    private void checkBasicParams(ConcatUriManager.Type type) throws Exception {
        Gadget gadget = this.mockGadget(false, false);
        String host = "host.com";
        String path = "/concat/path";
        DefaultConcatUriManager manager = this.makeManager(host, path, "token", null);
        ImmutableList resourceUris = ImmutableList.of(RESOURCES_ONE);
        List concatUris = manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)type), true);
        Assert.assertEquals((long)1L, (long)concatUris.size());
        ConcatUriManager.ConcatData uri = (ConcatUriManager.ConcatData)concatUris.get(0);
        Assert.assertNull((Object)uri.getSnippet(RESOURCE_1));
        Assert.assertNull((Object)uri.getSnippet(RESOURCE_2));
        Assert.assertNull((Object)uri.getSnippet(RESOURCE_3));
        Assert.assertNull((Object)uri.getUri().getScheme());
        Assert.assertEquals((Object)host, (Object)uri.getUri().getAuthority());
        Assert.assertEquals((Object)path, (Object)uri.getUri().getPath());
        Assert.assertEquals((long)8L, (long)uri.getUri().getQueryParameters().size());
        Assert.assertEquals((Object)CONTAINER, (Object)uri.getUri().getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)SPEC_URI.toString(), (Object)uri.getUri().getQueryParameter(UriCommon.Param.GADGET.getKey()));
        Assert.assertEquals((Object)"0", (Object)uri.getUri().getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)"0", (Object)uri.getUri().getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)type.getType(), (Object)uri.getUri().getQueryParameter(UriCommon.Param.TYPE.getKey()));
        Assert.assertEquals((Object)RESOURCES_ONE.get(0).toString(), (Object)uri.getUri().getQueryParameter("1"));
        Assert.assertEquals((Object)RESOURCES_ONE.get(1).toString(), (Object)uri.getUri().getQueryParameter("2"));
        Assert.assertEquals((Object)RESOURCES_ONE.get(2).toString(), (Object)uri.getUri().getQueryParameter("3"));
    }

    private void checkAltParams(ConcatUriManager.Type type) throws Exception {
        Gadget gadget = this.mockGadget(true, true);
        String host = "bar.com";
        String path = "/other/path";
        String version = "version";
        ConcatUriManager.Versioner versioner = this.makeVersioner(null, version);
        DefaultConcatUriManager manager = this.makeManager(host, path, "token", versioner);
        ImmutableList resourceUris = ImmutableList.of(RESOURCES_ONE);
        List concatUris = manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)type), true);
        Assert.assertEquals((long)1L, (long)concatUris.size());
        ConcatUriManager.ConcatData uri = (ConcatUriManager.ConcatData)concatUris.get(0);
        Assert.assertNull((Object)uri.getSnippet(RESOURCE_1));
        Assert.assertNull((Object)uri.getSnippet(RESOURCE_2));
        Assert.assertNull((Object)uri.getSnippet(RESOURCE_3));
        Assert.assertNull((Object)uri.getUri().getScheme());
        Assert.assertEquals((Object)host, (Object)uri.getUri().getAuthority());
        Assert.assertEquals((Object)path, (Object)uri.getUri().getPath());
        Assert.assertEquals((long)9L, (long)uri.getUri().getQueryParameters().size());
        Assert.assertEquals((Object)CONTAINER, (Object)uri.getUri().getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)SPEC_URI.toString(), (Object)uri.getUri().getQueryParameter(UriCommon.Param.GADGET.getKey()));
        Assert.assertEquals((Object)"1", (Object)uri.getUri().getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)"1", (Object)uri.getUri().getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)type.getType(), (Object)uri.getUri().getQueryParameter(UriCommon.Param.TYPE.getKey()));
        Assert.assertEquals((Object)RESOURCES_ONE.get(0).toString(), (Object)uri.getUri().getQueryParameter("1"));
        Assert.assertEquals((Object)RESOURCES_ONE.get(1).toString(), (Object)uri.getUri().getQueryParameter("2"));
        Assert.assertEquals((Object)RESOURCES_ONE.get(2).toString(), (Object)uri.getUri().getQueryParameter("3"));
        Assert.assertEquals((Object)version, (Object)uri.getUri().getQueryParameter(UriCommon.Param.VERSION.getKey()));
    }

    private void checkBatchAdjacent(ConcatUriManager.Type type) throws Exception {
        Gadget gadget = this.mockGadget(true, true);
        String host = "bar.com";
        String path = "/other/path";
        String[] versions = new String[]{"version1", "v2", "v3"};
        ConcatUriManager.Versioner versioner = this.makeVersioner(null, versions);
        DefaultConcatUriManager manager = this.makeManager(host, path, "token", versioner);
        ImmutableList resourceUris = ImmutableList.of(RESOURCES_ONE, RESOURCES_TWO, RESOURCES_ONE);
        List concatUris = manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)type), true);
        Assert.assertEquals((long)3L, (long)concatUris.size());
        for (int i = 0; i < 3; ++i) {
            ConcatUriManager.ConcatData uri = (ConcatUriManager.ConcatData)concatUris.get(i);
            Assert.assertNull((Object)uri.getSnippet(RESOURCE_1));
            Assert.assertNull((Object)uri.getSnippet(RESOURCE_2));
            Assert.assertNull((Object)uri.getSnippet(RESOURCE_3));
            Assert.assertNull((Object)uri.getUri().getScheme());
            Assert.assertEquals((Object)host, (Object)uri.getUri().getAuthority());
            Assert.assertEquals((Object)path, (Object)uri.getUri().getPath());
            Assert.assertEquals((long)9L, (long)uri.getUri().getQueryParameters().size());
            Assert.assertEquals((Object)CONTAINER, (Object)uri.getUri().getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
            Assert.assertEquals((Object)SPEC_URI.toString(), (Object)uri.getUri().getQueryParameter(UriCommon.Param.GADGET.getKey()));
            Assert.assertEquals((Object)"1", (Object)uri.getUri().getQueryParameter(UriCommon.Param.DEBUG.getKey()));
            Assert.assertEquals((Object)"1", (Object)uri.getUri().getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
            Assert.assertEquals((Object)type.getType(), (Object)uri.getUri().getQueryParameter(UriCommon.Param.TYPE.getKey()));
            List<Uri> resList = i % 2 == 0 ? RESOURCES_ONE : RESOURCES_TWO;
            Assert.assertEquals((Object)resList.get(0).toString(), (Object)uri.getUri().getQueryParameter("1"));
            Assert.assertEquals((Object)resList.get(1).toString(), (Object)uri.getUri().getQueryParameter("2"));
            Assert.assertEquals((Object)resList.get(2).toString(), (Object)uri.getUri().getQueryParameter("3"));
            Assert.assertEquals((Object)versions[i], (Object)uri.getUri().getQueryParameter(UriCommon.Param.VERSION.getKey()));
        }
    }

    private void checkValidatedBatchAdjacent(ConcatUriManager.Type type) throws Exception {
        Gadget gadget = this.mockGadget(true, true);
        String host = "bar.com";
        String path = "/other/path";
        String[] versions = new String[]{"version1", "v2", "v3"};
        ConcatUriManager.Versioner versioner = this.makeVersioner(UriStatus.VALID_VERSIONED, versions);
        DefaultConcatUriManager manager = this.makeManager(host, path, "token", versioner);
        ImmutableList resourceUris = ImmutableList.of(RESOURCES_ONE, RESOURCES_TWO, RESOURCES_ONE);
        List concatUris = manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)type), true);
        Assert.assertEquals((long)3L, (long)concatUris.size());
        for (int i = 0; i < 3; ++i) {
            ConcatUriManager.ConcatUri validated = manager.process(((ConcatUriManager.ConcatData)concatUris.get(i)).getUri());
            Assert.assertEquals((Object)UriStatus.VALID_VERSIONED, (Object)validated.getStatus());
            List<Uri> resList = i % 2 == 0 ? RESOURCES_ONE : RESOURCES_TWO;
            Assert.assertEquals(resList, (Object)validated.getBatch());
            Assert.assertEquals((Object)type, (Object)validated.getType());
        }
    }

    private void checkBatchInsufficientVersions(ConcatUriManager.Type type) throws Exception {
        Gadget gadget = this.mockGadget(true, true);
        String host = "bar.com";
        String path = "/other/path";
        String[] versions = new String[]{"v1"};
        ConcatUriManager.Versioner versioner = this.makeVersioner(null, versions);
        DefaultConcatUriManager manager = this.makeManager(host, path, "token", versioner);
        ImmutableList resourceUris = ImmutableList.of(RESOURCES_ONE, RESOURCES_ONE);
        manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)type), true);
    }

    private void checkMissingHostConfig(ConcatUriManager.Type type) throws Exception {
        Gadget gadget = this.mockGadget(false, false);
        DefaultConcatUriManager manager = this.makeManager(null, "/foo", "token", null);
        ImmutableList resourceUris = ImmutableList.of(RESOURCES_ONE);
        manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)type), true);
    }

    private void checkMissingPathConfig(ConcatUriManager.Type type) throws Exception {
        Gadget gadget = this.mockGadget(false, false);
        DefaultConcatUriManager manager = this.makeManager("host.com", null, "token", null);
        ImmutableList resourceUris = ImmutableList.of(RESOURCES_ONE);
        manager.make(ConcatUriManager.ConcatUri.fromList((Gadget)gadget, (List)resourceUris, (ConcatUriManager.Type)type), false);
    }

    private DefaultConcatUriManager makeManager(String host, String path, String splitToken, ConcatUriManager.Versioner versioner) {
        ContainerConfig config = (ContainerConfig)EasyMock.createMock(ContainerConfig.class);
        EasyMock.expect((Object)config.getString(CONTAINER, "gadgets.uri.concat.host")).andReturn((Object)host).anyTimes();
        EasyMock.expect((Object)config.getString(CONTAINER, "gadgets.uri.concat.path")).andReturn((Object)path).anyTimes();
        EasyMock.expect((Object)config.getString(CONTAINER, "gadgets.uri.concat.js.splitToken")).andReturn((Object)splitToken).anyTimes();
        EasyMock.replay((Object[])new Object[]{config});
        return new DefaultConcatUriManager(config, versioner);
    }

    private ConcatUriManager.Versioner makeVersioner(UriStatus status, String ... versions) {
        ConcatUriManager.Versioner versioner = (ConcatUriManager.Versioner)EasyMock.createMock(ConcatUriManager.Versioner.class);
        EasyMock.expect((Object)versioner.version((List)EasyMock.isA(List.class), (String)EasyMock.eq((Object)CONTAINER))).andReturn((Object)ImmutableList.copyOf((Object[])versions)).anyTimes();
        EasyMock.expect((Object)versioner.validate((List)EasyMock.isA(List.class), (String)EasyMock.eq((Object)CONTAINER), (String)EasyMock.isA(String.class))).andReturn((Object)status).anyTimes();
        EasyMock.replay((Object[])new Object[]{versioner});
        return versioner;
    }
}

