/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.uri.DefaultJsUriManager;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJsUriManagerTest {
    private static final String CONTAINER = "container";
    private static final Uri GADGET_URI = Uri.parse((String)"http://example.com/gadget.xml");

    @Test(expected=RuntimeException.class)
    public void makeMissingHostConfig() {
        ContainerConfig config = this.mockConfig(null, "/gadgets/js");
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        Gadget gadget = this.mockGadget(false, false);
        manager.makeExternJsUri(gadget, null);
    }

    @Test(expected=RuntimeException.class)
    public void makeMissingPathConfig() {
        ContainerConfig config = this.mockConfig("foo", null);
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        Gadget gadget = this.mockGadget(false, false);
        manager.makeExternJsUri(gadget, null);
    }

    @Test
    public void makeJsUriNoPathSlashNoVersion() {
        ContainerConfig config = this.mockConfig("http://www.js.org", "/gadgets/js/");
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        Gadget gadget = this.mockGadget(false, false);
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature"});
        Uri jsUri = manager.makeExternJsUri(gadget, extern);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)"http", (Object)jsUri.getScheme());
        Assert.assertEquals((Object)"www.js.org", (Object)jsUri.getAuthority());
        Assert.assertEquals((Object)("/gadgets/js/" + DefaultJsUriManager.addJsLibs((Collection)extern) + ".js"), (Object)jsUri.getPath());
        Assert.assertEquals((Object)CONTAINER, (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER_MODE.getKey()));
    }

    @Test
    public void makeJsUriAddPathSlashNoVersion() {
        ContainerConfig config = this.mockConfig("http://www.js.org", "/gadgets/js");
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        Gadget gadget = this.mockGadget(false, false);
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature"});
        Uri jsUri = manager.makeExternJsUri(gadget, extern);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)"http", (Object)jsUri.getScheme());
        Assert.assertEquals((Object)"www.js.org", (Object)jsUri.getAuthority());
        Assert.assertEquals((Object)("/gadgets/js/" + DefaultJsUriManager.addJsLibs((Collection)extern) + ".js"), (Object)jsUri.getPath());
        Assert.assertEquals((Object)CONTAINER, (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER_MODE.getKey()));
    }

    @Test
    public void makeJsUriAddPathSlashVersioned() {
        ContainerConfig config = this.mockConfig("http://www.js.org", "/gadgets/js");
        Gadget gadget = this.mockGadget(false, false);
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature"});
        String version = "verstring";
        JsUriManager.Versioner versioner = this.mockVersioner(extern, version, version);
        TestDefaultJsUriManager manager = this.makeManager(config, versioner);
        Uri jsUri = manager.makeExternJsUri(gadget, extern);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)"http", (Object)jsUri.getScheme());
        Assert.assertEquals((Object)"www.js.org", (Object)jsUri.getAuthority());
        Assert.assertEquals((Object)("/gadgets/js/" + DefaultJsUriManager.addJsLibs((Collection)extern) + ".js"), (Object)jsUri.getPath());
        Assert.assertEquals((Object)CONTAINER, (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)version, (Object)jsUri.getQueryParameter(UriCommon.Param.VERSION.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER_MODE.getKey()));
    }

    @Test
    public void makeJsUriWithVersionerNoVersionOnIgnoreCache() {
        ContainerConfig config = this.mockConfig("http://www.js.org", "/gadgets/js");
        Gadget gadget = this.mockGadget(true, false);
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature"});
        String version = "verstring";
        JsUriManager.Versioner versioner = this.mockVersioner(extern, version, version);
        TestDefaultJsUriManager manager = this.makeManager(config, versioner);
        Uri jsUri = manager.makeExternJsUri(gadget, extern);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)"http", (Object)jsUri.getScheme());
        Assert.assertEquals((Object)"www.js.org", (Object)jsUri.getAuthority());
        Assert.assertEquals((Object)("/gadgets/js/" + DefaultJsUriManager.addJsLibs((Collection)extern) + ".js"), (Object)jsUri.getPath());
        Assert.assertEquals((Object)CONTAINER, (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals(null, (Object)jsUri.getQueryParameter(UriCommon.Param.VERSION.getKey()));
        Assert.assertEquals((Object)"1", (Object)jsUri.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER_MODE.getKey()));
    }

    @Test
    public void makeJsUriWithContainerContext() {
        ContainerConfig config = this.mockConfig("http://www.js.org", "/gadgets/js/");
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        Gadget gadget = this.mockGadget(false, false, true);
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature", "another"});
        Uri jsUri = manager.makeExternJsUri(gadget, extern);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)"http", (Object)jsUri.getScheme());
        Assert.assertEquals((Object)"www.js.org", (Object)jsUri.getAuthority());
        Assert.assertEquals((Object)("/gadgets/js/" + DefaultJsUriManager.addJsLibs((Collection)extern) + ".js"), (Object)jsUri.getPath());
        Assert.assertEquals((Object)CONTAINER, (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)"1", (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER_MODE.getKey()));
    }

    @Test(expected=RuntimeException.class)
    public void processMissingHostConfig() throws GadgetException {
        ContainerConfig config = this.mockConfig(null, "/gadgets/js");
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        manager.processExternJsUri(Uri.parse((String)"http://example.com?container=container"));
    }

    @Test(expected=RuntimeException.class)
    public void processMissingPathConfig() throws GadgetException {
        ContainerConfig config = this.mockConfig("foo", null);
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        manager.processExternJsUri(Uri.parse((String)"http://example.com?container=container"));
    }

    @Test
    public void processDefaultConfig() throws GadgetException {
        ContainerConfig config = this.mockDefaultConfig("foo", "/gadgets/js");
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        manager.processExternJsUri(Uri.parse((String)"http://example.com?container=container"));
    }

    @Test
    public void processPathPrefixMismatch() throws GadgetException {
        String targetHost = "target-host.org";
        ContainerConfig config = this.mockConfig("http://" + targetHost, "/gadgets/js");
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        Uri testUri = Uri.parse((String)("http://target-host.org/gadgets/other-js/feature.js?" + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER));
        JsUriManager.JsUri jsUri = manager.processExternJsUri(testUri);
        Assert.assertTrue((boolean)manager.hadError());
        Assert.assertEquals((Object)jsUri.getStatus(), (Object)UriStatus.BAD_URI);
        Assert.assertSame((Object)DefaultJsUriManager.INVALID_URI, (Object)jsUri);
    }

    @Test
    public void processPathSuffixNoJs() throws GadgetException {
        String targetHost = "target-host.org";
        ContainerConfig config = this.mockConfig("http://" + targetHost, "/gadgets/js");
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        Uri testUri = Uri.parse((String)("http://target-host.org/gadgets/js/feature:another?" + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER));
        JsUriManager.JsUri jsUri = manager.processExternJsUri(testUri);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)jsUri.getStatus(), (Object)UriStatus.VALID_UNVERSIONED);
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature", "another"});
        this.assertCollectionEquals(jsUri.getLibs(), extern);
    }

    @Test
    public void processValidUnversionedNoVersioner() throws GadgetException {
        String targetHost = "target-host.org";
        ContainerConfig config = this.mockConfig("http://" + targetHost, "/gadgets/js");
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature", "another"});
        String version = "verstring";
        TestDefaultJsUriManager manager = this.makeManager(config, null);
        Uri testUri = Uri.parse((String)("http://target-host.org/gadgets/js/" + DefaultJsUriManager.addJsLibs((Collection)extern) + ".js" + '?' + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + '&' + UriCommon.Param.VERSION.getKey() + '=' + version));
        JsUriManager.JsUri jsUri = manager.processExternJsUri(testUri);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)jsUri.getStatus(), (Object)UriStatus.VALID_UNVERSIONED);
        this.assertCollectionEquals(jsUri.getLibs(), extern);
    }

    @Test
    public void processValidInvalidVersion() throws GadgetException {
        String targetHost = "target-host.org";
        ContainerConfig config = this.mockConfig("http://" + targetHost, "/gadgets/js");
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature", "another"});
        String version = "verstring";
        String badVersion = version + "-a";
        JsUriManager.Versioner versioner = this.mockVersioner(extern, version, badVersion);
        TestDefaultJsUriManager manager = this.makeManager(config, versioner);
        Uri testUri = Uri.parse((String)("http://target-host.org/gadgets/js/" + DefaultJsUriManager.addJsLibs((Collection)extern) + ".js" + '?' + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + '&' + UriCommon.Param.VERSION.getKey() + '=' + badVersion));
        JsUriManager.JsUri jsUri = manager.processExternJsUri(testUri);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)jsUri.getStatus(), (Object)UriStatus.INVALID_VERSION);
        this.assertCollectionEquals(jsUri.getLibs(), extern);
    }

    @Test
    public void processValidUnversionedNoParam() throws GadgetException {
        String targetHost = "target-host.org";
        ContainerConfig config = this.mockConfig("http://" + targetHost, "/gadgets/js");
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature", "another"});
        String version = "verstring";
        JsUriManager.Versioner versioner = this.mockVersioner(extern, version, version);
        TestDefaultJsUriManager manager = this.makeManager(config, versioner);
        Uri testUri = Uri.parse((String)("http://target-host.org/gadgets/js/" + DefaultJsUriManager.addJsLibs((Collection)extern) + ".js" + '?' + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER));
        JsUriManager.JsUri jsUri = manager.processExternJsUri(testUri);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)jsUri.getStatus(), (Object)UriStatus.VALID_UNVERSIONED);
        this.assertCollectionEquals(jsUri.getLibs(), extern);
    }

    @Test
    public void processValidVersioned() throws GadgetException {
        String targetHost = "target-host.org";
        ContainerConfig config = this.mockConfig("http://" + targetHost, "/gadgets/js");
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature", "another"});
        String version = "verstring";
        JsUriManager.Versioner versioner = this.mockVersioner(extern, version, version);
        TestDefaultJsUriManager manager = this.makeManager(config, versioner);
        Uri testUri = Uri.parse((String)("http://target-host.org/gadgets/js/" + DefaultJsUriManager.addJsLibs((Collection)extern) + ".js" + '?' + UriCommon.Param.CONTAINER.getKey() + '=' + CONTAINER + '&' + UriCommon.Param.VERSION.getKey() + '=' + version));
        JsUriManager.JsUri jsUri = manager.processExternJsUri(testUri);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)jsUri.getStatus(), (Object)UriStatus.VALID_VERSIONED);
        this.assertCollectionEquals(jsUri.getLibs(), extern);
    }

    @Test
    public void makeAndProcessSymmetric() throws GadgetException {
        ContainerConfig config = this.mockConfig("http://www.js.org", "/gadgets/js");
        Gadget gadget = this.mockGadget(false, false);
        ArrayList extern = Lists.newArrayList((Object[])new String[]{"feature1", "feature2", "feature3"});
        String version = "verstring";
        JsUriManager.Versioner versioner = this.mockVersioner(extern, version, version);
        TestDefaultJsUriManager manager = this.makeManager(config, versioner);
        Uri jsUri = manager.makeExternJsUri(gadget, extern);
        Assert.assertFalse((boolean)manager.hadError());
        Assert.assertEquals((Object)"http", (Object)jsUri.getScheme());
        Assert.assertEquals((Object)"www.js.org", (Object)jsUri.getAuthority());
        Assert.assertEquals((Object)("/gadgets/js/" + DefaultJsUriManager.addJsLibs((Collection)extern) + ".js"), (Object)jsUri.getPath());
        Assert.assertEquals((Object)CONTAINER, (Object)jsUri.getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)version, (Object)jsUri.getQueryParameter(UriCommon.Param.VERSION.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)"0", (Object)jsUri.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        JsUriManager.JsUri processed = manager.processExternJsUri(jsUri);
        Assert.assertEquals((Object)UriStatus.VALID_VERSIONED, (Object)processed.getStatus());
        this.assertCollectionEquals(extern, processed.getLibs());
    }

    private void assertCollectionEquals(Collection<String> expected, Collection<String> test) {
        Assert.assertEquals((long)expected.size(), (long)test.size());
        ArrayList expectedCopy = Lists.newArrayList(expected);
        ArrayList testCopy = Lists.newArrayList(test);
        Assert.assertEquals((Object)expectedCopy, (Object)testCopy);
    }

    private ContainerConfig mockConfig(String jsHost, String jsPath) {
        ContainerConfig config = (ContainerConfig)EasyMock.createMock(ContainerConfig.class);
        EasyMock.expect((Object)config.getString(CONTAINER, "gadgets.uri.js.host")).andReturn((Object)jsHost).anyTimes();
        EasyMock.expect((Object)config.getString(CONTAINER, "gadgets.uri.js.path")).andReturn((Object)jsPath).anyTimes();
        EasyMock.expect((Object)config.getString("default", "gadgets.uri.js.host")).andReturn(null).anyTimes();
        EasyMock.expect((Object)config.getString("default", "gadgets.uri.js.path")).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{config});
        return config;
    }

    private ContainerConfig mockDefaultConfig(String jsHost, String jsPath) {
        ContainerConfig config = (ContainerConfig)EasyMock.createMock(ContainerConfig.class);
        EasyMock.expect((Object)config.getString(CONTAINER, "gadgets.uri.js.host")).andReturn(null).anyTimes();
        EasyMock.expect((Object)config.getString(CONTAINER, "gadgets.uri.js.path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)config.getString("default", "gadgets.uri.js.host")).andReturn((Object)jsHost).anyTimes();
        EasyMock.expect((Object)config.getString("default", "gadgets.uri.js.path")).andReturn((Object)jsPath).anyTimes();
        EasyMock.replay((Object[])new Object[]{config});
        return config;
    }

    private JsUriManager.Versioner mockVersioner(Collection<String> extern, String genVersion, String testVersion) {
        JsUriManager.Versioner versioner = (JsUriManager.Versioner)EasyMock.createMock(JsUriManager.Versioner.class);
        EasyMock.expect((Object)versioner.version(GADGET_URI, CONTAINER, extern)).andReturn((Object)genVersion).anyTimes();
        EasyMock.expect((Object)versioner.version(null, CONTAINER, extern)).andReturn((Object)genVersion).anyTimes();
        UriStatus status = genVersion != null && genVersion.equals(testVersion) ? UriStatus.VALID_VERSIONED : UriStatus.INVALID_VERSION;
        EasyMock.expect((Object)versioner.validate(GADGET_URI, CONTAINER, extern, testVersion)).andReturn((Object)status).anyTimes();
        EasyMock.expect((Object)versioner.validate(null, CONTAINER, extern, testVersion)).andReturn((Object)status).anyTimes();
        EasyMock.replay((Object[])new Object[]{versioner});
        return versioner;
    }

    private Gadget mockGadget(boolean nocache, boolean debug) {
        return this.mockGadget(nocache, debug, false);
    }

    private Gadget mockGadget(boolean nocache, boolean debug, boolean isContainer) {
        GadgetContext context = (GadgetContext)EasyMock.createMock(GadgetContext.class);
        EasyMock.expect((Object)context.getContainer()).andReturn((Object)CONTAINER).anyTimes();
        EasyMock.expect((Object)context.getIgnoreCache()).andReturn((Object)nocache).anyTimes();
        EasyMock.expect((Object)context.getDebug()).andReturn((Object)debug).anyTimes();
        EasyMock.expect((Object)context.getUrl()).andReturn((Object)GADGET_URI).anyTimes();
        EasyMock.expect((Object)context.getRenderingContext()).andReturn((Object)(isContainer ? RenderingContext.CONTAINER : RenderingContext.GADGET)).anyTimes();
        EasyMock.replay((Object[])new Object[]{context});
        return new Gadget().setContext(context);
    }

    private TestDefaultJsUriManager makeManager(ContainerConfig config, JsUriManager.Versioner versioner) {
        return new TestDefaultJsUriManager(config, versioner);
    }

    private static final class TestDefaultJsUriManager
    extends DefaultJsUriManager {
        private boolean errorReported = false;

        private TestDefaultJsUriManager(ContainerConfig config, JsUriManager.Versioner versioner) {
            super(config, versioner);
        }

        protected void issueUriFormatError(String err) {
            this.errorReported = true;
        }

        public boolean hadError() {
            return this.errorReported;
        }
    }
}

