/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.uri.DefaultOAuthUriManager;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DefaultOAuthUriManagerTest {
    private static final String CONTAINER = "container";
    private static final String HOST = "www.host.com";

    @Test
    public void noConfigValueConfigured() throws Exception {
        ContainerConfig config = this.mockConfig(null);
        DefaultOAuthUriManager manager = this.makeManager(config);
        Assert.assertNull((Object)manager.makeOAuthCallbackUri(CONTAINER, HOST));
        EasyMock.verify((Object[])new Object[]{config});
    }

    @Test
    public void noHostSubstitution() throws Exception {
        String value = "http://www.apache.org/oauth/callback";
        ContainerConfig config = this.mockConfig(value);
        DefaultOAuthUriManager manager = this.makeManager(config);
        Assert.assertEquals((Object)value, (Object)manager.makeOAuthCallbackUri(CONTAINER, HOST).toString());
        EasyMock.verify((Object[])new Object[]{config});
    }

    @Test
    public void oauthUriWithHostSubstitution() throws Exception {
        String value = "http://%host%/oauth/callback";
        ContainerConfig config = this.mockConfig(value);
        DefaultOAuthUriManager manager = this.makeManager(config);
        Assert.assertEquals((Object)"http://www.host.com/oauth/callback", (Object)manager.makeOAuthCallbackUri(CONTAINER, HOST).toString());
        EasyMock.verify((Object[])new Object[]{config});
    }

    private ContainerConfig mockConfig(String tplVal) {
        ContainerConfig config = (ContainerConfig)EasyMock.createMock(ContainerConfig.class);
        EasyMock.expect((Object)config.getString(CONTAINER, "gadgets.uri.oauth.callbackTemplate")).andReturn((Object)tplVal).once();
        EasyMock.replay((Object[])new Object[]{config});
        return config;
    }

    private DefaultOAuthUriManager makeManager(ContainerConfig config) {
        return new DefaultOAuthUriManager(config);
    }
}

