/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.easymock.EasyMock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriManagerTestBase {
    protected static final String CONTAINER = "container";
    protected static final Uri SPEC_URI = Uri.parse((String)"http://example.com/gadget.xml");
    protected static final String VIEW = "theview";
    protected static final String LANG = "en";
    protected static final String COUNTRY = "US";

    protected Gadget mockGadget(String ... features) {
        HashMap prefs = Maps.newHashMap();
        return this.mockGadget(SPEC_URI.toString(), false, false, false, prefs, prefs, false, Lists.newArrayList((Object[])features));
    }

    protected Gadget mockGadget(boolean prefsForRendering, Map<String, String> specPrefs, Map<String, String> inPrefs) {
        return this.mockGadget(SPEC_URI.toString(), false, false, false, specPrefs, inPrefs, prefsForRendering, Lists.newArrayList());
    }

    protected Gadget mockGadget(String targetUrl, boolean isTypeUrl, boolean isDebug, boolean ignoreCache, Map<String, String> specPrefs, Map<String, String> inPrefs, boolean needsPrefSubst, List<String> features) {
        return this.mockGadget(targetUrl, isTypeUrl, VIEW, LANG, COUNTRY, isDebug, ignoreCache, specPrefs, inPrefs, needsPrefSubst, features);
    }

    protected Gadget mockGadget(boolean isDebug, boolean ignoreCache) {
        return this.mockGadget(SPEC_URI.toString(), false, isDebug, ignoreCache, Maps.newHashMap(), Maps.newHashMap(), false, Lists.newArrayList());
    }

    protected Gadget mockGadget(String targetUrl, boolean isTypeUrl, String viewStr, String lang, String country, boolean isDebug, boolean ignoreCache, Map<String, String> specPrefs, Map<String, String> inPrefs, boolean needsPrefSubst, List<String> features) {
        View view = (View)EasyMock.createMock(View.class);
        ModulePrefs modulePrefs = (ModulePrefs)EasyMock.createMock(ModulePrefs.class);
        GadgetSpec spec = (GadgetSpec)EasyMock.createMock(GadgetSpec.class);
        GadgetContext context = (GadgetContext)EasyMock.createMock(GadgetContext.class);
        Gadget gadget = (Gadget)EasyMock.createMock(Gadget.class);
        Uri targetUri = Uri.parse((String)targetUrl);
        if (isTypeUrl) {
            EasyMock.expect((Object)view.getType()).andReturn((Object)View.ContentType.URL).anyTimes();
            EasyMock.expect((Object)view.getHref()).andReturn((Object)targetUri).anyTimes();
        } else {
            EasyMock.expect((Object)view.getType()).andReturn((Object)View.ContentType.HTML).anyTimes();
            EasyMock.expect((Object)spec.getUrl()).andReturn((Object)targetUri).anyTimes();
        }
        EasyMock.expect((Object)view.getName()).andReturn((Object)viewStr).anyTimes();
        Locale locale = new Locale(lang, country);
        EasyMock.expect((Object)context.getUrl()).andReturn((Object)SPEC_URI).anyTimes();
        EasyMock.expect((Object)context.getContainer()).andReturn((Object)CONTAINER).anyTimes();
        EasyMock.expect((Object)context.getLocale()).andReturn((Object)locale).anyTimes();
        EasyMock.expect((Object)context.getDebug()).andReturn((Object)isDebug).anyTimes();
        EasyMock.expect((Object)context.getIgnoreCache()).andReturn((Object)ignoreCache).anyTimes();
        EasyMock.expect((Object)context.getToken()).andReturn(null).anyTimes();
        EasyMock.expect((Object)gadget.getAllFeatures()).andReturn(features).anyTimes();
        LinkedHashMap specPrefMap = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> specPref : specPrefs.entrySet()) {
            UserPref up = (UserPref)EasyMock.createMock(UserPref.class);
            EasyMock.expect((Object)up.getName()).andReturn((Object)specPref.getKey()).anyTimes();
            EasyMock.expect((Object)up.getDefaultValue()).andReturn((Object)specPref.getValue()).anyTimes();
            EasyMock.replay((Object[])new Object[]{up});
            specPrefMap.put(up.getName(), up);
        }
        EasyMock.expect((Object)spec.getUserPrefs()).andReturn((Object)specPrefMap).anyTimes();
        UserPrefs ctxPrefs = new UserPrefs(inPrefs);
        EasyMock.expect((Object)context.getUserPrefs()).andReturn((Object)ctxPrefs).anyTimes();
        EasyMock.expect((Object)context.getParameter(UriCommon.Param.REFRESH.getKey())).andReturn(null).anyTimes();
        EasyMock.expect((Object)view.needsUserPrefSubstitution()).andReturn((Object)needsPrefSubst).anyTimes();
        EasyMock.expect((Object)spec.getModulePrefs()).andReturn((Object)modulePrefs).anyTimes();
        EasyMock.expect((Object)gadget.getCurrentView()).andReturn((Object)view).anyTimes();
        EasyMock.expect((Object)gadget.getSpec()).andReturn((Object)spec).anyTimes();
        EasyMock.expect((Object)gadget.getContext()).andReturn((Object)context).anyTimes();
        EasyMock.replay((Object[])new Object[]{view, modulePrefs, spec, context, gadget});
        return gadget;
    }
}

