/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.variables.ModuleSubstituter;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModuleSubstituterTest
extends Assert {
    private final Substitutions substitutions = new Substitutions();
    private GadgetSpec spec;

    @Before
    public void setUp() throws Exception {
        this.spec = new GadgetSpec(Uri.parse((String)"#"), "<Module><ModulePrefs title='' /><Content /></Module>");
    }

    @Test
    public void testDefault() throws Exception {
        ModuleSubstituter substituter = new ModuleSubstituter();
        substituter.addSubstitutions(this.substitutions, new GadgetContext(), this.spec);
        ModuleSubstituterTest.assertEquals((Object)"0", (Object)this.substitutions.getSubstitution(Substitutions.Type.MODULE, "ID"));
    }

    @Test
    public void testSpecific() throws Exception {
        int moduleId = 12345678;
        ModuleSubstituter substituter = new ModuleSubstituter();
        substituter.addSubstitutions(this.substitutions, new GadgetContext(){

            public int getModuleId() {
                return 12345678;
            }
        }, this.spec);
        ModuleSubstituterTest.assertEquals((Object)Integer.toString(12345678), (Object)this.substitutions.getSubstitution(Substitutions.Type.MODULE, "ID"));
    }
}

