/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.apache.shindig.gadgets.variables.UserPrefSubstituter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserPrefSubstituterTest
extends Assert {
    private final Substitutions substituter = new Substitutions();
    private static final String DEFAULT_NAME = "default";
    private static final String DEFAULT_VALUE = "default value";
    private static final String USER_NAME = "user";
    private static final String USER_VALUE = "user value";
    private static final String OVERRIDE_NAME = "override";
    private static final String OVERRIDE_VALUE = "override value";
    private static final String UNESCAPED_USER_VALUE = "<hello, & world > \"";
    private static final String ESCAPED_USER_VALUE = "&lt;hello, &amp; world &gt; &quot;";
    private static final String DEFAULT_XML = "<Module><ModulePrefs title=\"Hello, __UP_world__\"/><UserPref name=\"default\" datatype=\"string\" default_value=\"default value\"/><UserPref name=\"user\" datatype=\"string\"/><UserPref name=\"override\" datatype=\"string\"  default_value=\"FOOOOOOOOOOBAR!\"/><Content type=\"html\"/></Module>";
    private GadgetSpec spec;

    @Before
    public void setUp() throws Exception {
        this.spec = new GadgetSpec(Uri.parse((String)"#"), DEFAULT_XML);
    }

    @Test
    public void testSubstitutions() throws Exception {
        ImmutableMap map = ImmutableMap.of((Object)USER_NAME, (Object)USER_VALUE, (Object)OVERRIDE_NAME, (Object)OVERRIDE_VALUE);
        final UserPrefs prefs = new UserPrefs((Map)map);
        GadgetContext context = new GadgetContext(){

            public UserPrefs getUserPrefs() {
                return prefs;
            }
        };
        new UserPrefSubstituter().addSubstitutions(this.substituter, context, this.spec);
        UserPrefSubstituterTest.assertEquals((Object)DEFAULT_VALUE, (Object)this.substituter.getSubstitution(Substitutions.Type.USER_PREF, DEFAULT_NAME));
        UserPrefSubstituterTest.assertEquals((Object)USER_VALUE, (Object)this.substituter.getSubstitution(Substitutions.Type.USER_PREF, USER_NAME));
        UserPrefSubstituterTest.assertEquals((Object)OVERRIDE_VALUE, (Object)this.substituter.getSubstitution(Substitutions.Type.USER_PREF, OVERRIDE_NAME));
    }

    @Test
    public void testEscaping() throws Exception {
        ImmutableMap map = ImmutableMap.of((Object)USER_NAME, (Object)UNESCAPED_USER_VALUE);
        final UserPrefs prefs = new UserPrefs((Map)map);
        GadgetContext context = new GadgetContext(){

            public UserPrefs getUserPrefs() {
                return prefs;
            }
        };
        new UserPrefSubstituter().addSubstitutions(this.substituter, context, this.spec);
        UserPrefSubstituterTest.assertEquals((Object)ESCAPED_USER_VALUE, (Object)this.substituter.getSubstitution(Substitutions.Type.USER_PREF, USER_NAME));
    }
}

