/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.config.ConfigContributor;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JsHandler {
    protected final FeatureRegistry registry;
    protected final ContainerConfig containerConfig;
    protected final Map<String, ConfigContributor> configContributors;

    @Inject
    public JsHandler(FeatureRegistry registry, ContainerConfig containerConfig, Map<String, ConfigContributor> configContributors) {
        this.registry = registry;
        this.containerConfig = containerConfig;
        this.configContributors = configContributors;
    }

    public JsHandlerResponse getJsContent(HttpServletRequest req) {
        Set<String> needed = this.getFeaturesNeeded(req);
        GadgetContext ctx = this.getGadgetContext(req);
        return this.getFeatureResourcesContent(req, ctx, needed);
    }

    protected Set<String> getFeaturesNeeded(HttpServletRequest req) {
        String uri = req.getRequestURI();
        String resourceName = uri.substring(uri.lastIndexOf(47) + 1);
        if (resourceName.endsWith(".js")) {
            resourceName = resourceName.substring(0, resourceName.length() - ".js".length());
        }
        ImmutableSet needed = ImmutableSet.copyOf((Object[])StringUtils.split((String)resourceName, (char)':'));
        return needed;
    }

    protected GadgetContext getGadgetContext(HttpServletRequest req) {
        String containerParam = req.getParameter("container");
        String containerStr = req.getParameter("c");
        RenderingContext context = "1".equals(containerStr) ? RenderingContext.CONTAINER : RenderingContext.GADGET;
        String container = containerParam != null ? containerParam : "default";
        return new JsGadgetContext(context, container);
    }

    protected JsHandlerResponse getFeatureResourcesContent(HttpServletRequest req, GadgetContext ctx, Set<String> needed) {
        StringBuilder jsData = new StringBuilder();
        List<FeatureResource> resources = this.registry.getFeatureResources(ctx, needed, null);
        String debugStr = req.getParameter("debug");
        boolean debug = "1".equals(debugStr);
        String container = ctx.getContainer();
        boolean isProxyCacheable = true;
        for (FeatureResource featureResource : resources) {
            String content;
            String string = content = debug ? featureResource.getDebugContent() : featureResource.getContent();
            if (!featureResource.isExternal()) {
                jsData.append(content);
            } else {
                jsData.append("document.write('<script src=\"").append(content).append("\"></script>')");
            }
            isProxyCacheable = isProxyCacheable && featureResource.isProxyCacheable();
            jsData.append(";\n");
        }
        if (ctx.getRenderingContext() == RenderingContext.CONTAINER) {
            Map features = this.containerConfig.getMap(container, "gadgets.features");
            HashMap config = Maps.newHashMapWithExpectedSize((int)(features == null ? 2 : features.size() + 2));
            if (features != null) {
                for (String name : this.registry.getFeatures(needed)) {
                    ConfigContributor contributor;
                    Object conf = features.get(name);
                    if (conf != null) {
                        config.put(name, conf);
                    }
                    if ((contributor = this.configContributors.get(name)) == null) continue;
                    contributor.contribute(config, container, req.getHeader("Host"));
                }
                jsData.append("gadgets.config.init(").append(JsonSerializer.serialize((Map)config)).append(");\n");
            }
        }
        return new JsHandlerResponse(jsData, isProxyCacheable);
    }

    protected static class JsGadgetContext
    extends GadgetContext {
        private final RenderingContext renderingContext;
        private final String container;

        public JsGadgetContext(RenderingContext renderingContext, String container) {
            this.renderingContext = renderingContext;
            this.container = container;
        }

        public RenderingContext getRenderingContext() {
            return this.renderingContext;
        }

        public String getContainer() {
            return this.container;
        }
    }

    public static class JsHandlerResponse {
        private final boolean isProxyCacheable;
        private final StringBuilder jsData;

        public JsHandlerResponse(StringBuilder jsData, boolean isProxyCacheable) {
            this.jsData = jsData;
            this.isProxyCacheable = isProxyCacheable;
        }

        public boolean isProxyCacheable() {
            return this.isProxyCacheable;
        }

        public StringBuilder getJsData() {
            return this.jsData;
        }
    }
}

