/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.HashLockedDomainService;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class HashLockedDomainServiceTest
extends EasyMockTestCase {
    private HashLockedDomainService lockedDomainService;
    private Gadget wantsLocked = null;
    private Gadget notLocked = null;
    private Gadget wantsSecurityToken = null;
    private Gadget wantsBoth = null;
    private final ContainerConfig requiredConfig = (ContainerConfig)this.mock(ContainerConfig.class);
    private final ContainerConfig enabledConfig = (ContainerConfig)this.mock(ContainerConfig.class);

    private Gadget makeGadget(boolean wantsLocked, boolean wantsSecurityToken, String url) {
        ArrayList gadgetFeatures = Lists.newArrayList();
        String requires = "";
        if (wantsLocked || wantsSecurityToken) {
            gadgetFeatures.add("locked-domain");
            if (wantsLocked) {
                requires = requires + "  <Require feature='locked-domain'/>";
            }
            if (wantsSecurityToken) {
                requires = requires + "  <Require feature='security-token'/>";
                gadgetFeatures.add("security-token");
            }
        }
        String gadgetXml = "<Module><ModulePrefs title=''>" + requires + "</ModulePrefs><Content/></Module>";
        GadgetSpec spec = null;
        try {
            spec = new GadgetSpec(Uri.parse((String)url), gadgetXml);
        }
        catch (GadgetException e) {
            return null;
        }
        FeatureRegistry registry = (FeatureRegistry)this.mock(FeatureRegistry.class);
        EasyMock.expect((Object)registry.getFeatures((Collection)EasyMock.isA(Collection.class))).andReturn((Object)gadgetFeatures).anyTimes();
        return new Gadget().setSpec(spec).setGadgetFeatureRegistry(registry);
    }

    @Before
    public void setUp() throws Exception {
        EasyMock.expect((Object)this.requiredConfig.getString("default", "gadgets.lockedDomainSuffix")).andReturn((Object)"-a.example.com:8080").anyTimes();
        EasyMock.expect((Object)this.requiredConfig.getBool("default", "gadgets.lockedDomainRequired")).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.requiredConfig.getContainers()).andReturn(Arrays.asList("default")).anyTimes();
        EasyMock.expect((Object)this.enabledConfig.getString("default", "gadgets.lockedDomainSuffix")).andReturn((Object)"-a.example.com:8080").anyTimes();
        EasyMock.expect((Object)this.enabledConfig.getContainers()).andReturn(Arrays.asList("default")).anyTimes();
        this.wantsLocked = this.makeGadget(true, false, "http://somehost.com/somegadget.xml");
        this.notLocked = this.makeGadget(false, false, "not-locked");
        this.wantsSecurityToken = this.makeGadget(false, true, "http://somehost.com/securitytoken.xml");
        this.wantsBoth = this.makeGadget(true, true, "http://somehost.com/tokenandlocked.xml");
    }

    @Test
    public void testDisabledGlobally() {
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(this.requiredConfig, false);
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("anywhere.com"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("embed.com"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.notLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.wantsSecurityToken, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.wantsBoth, "default"));
        this.lockedDomainService = new HashLockedDomainService(this.enabledConfig, false);
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("anywhere.com"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("embed.com"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.notLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.wantsSecurityToken, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("embed.com", this.wantsBoth, "default"));
    }

    @Test
    public void testEnabledForGadget() {
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(this.enabledConfig, true);
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("images-a.example.com:8080"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("-a.example.com:8080"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("embed.com"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.wantsSecurityToken, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("h2nlf2a2dqou2lul3n50jb4v7e8t34kc-a.example.com:8080", this.wantsBoth, "default"));
        String target = this.lockedDomainService.getLockedDomainForGadget(this.wantsLocked, "default");
        HashLockedDomainServiceTest.assertEquals((Object)"8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", (Object)target);
        target = this.lockedDomainService.getLockedDomainForGadget(this.wantsBoth, "default");
        HashLockedDomainServiceTest.assertEquals((Object)"h2nlf2a2dqou2lul3n50jb4v7e8t34kc-a.example.com:8080", (Object)target);
        this.lockedDomainService.setLockSecurityTokens(Boolean.valueOf(true));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("lrrq12l8s5flpqcjoj1h1872lp9p93nk-a.example.com:8080", this.wantsSecurityToken, "default"));
        target = this.lockedDomainService.getLockedDomainForGadget(this.wantsSecurityToken, "default");
        HashLockedDomainServiceTest.assertEquals((Object)"lrrq12l8s5flpqcjoj1h1872lp9p93nk-a.example.com:8080", (Object)target);
        target = this.lockedDomainService.getLockedDomainForGadget(this.wantsLocked, "default");
        HashLockedDomainServiceTest.assertEquals((Object)"8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", (Object)target);
        target = this.lockedDomainService.getLockedDomainForGadget(this.wantsBoth, "default");
        HashLockedDomainServiceTest.assertEquals((Object)"h2nlf2a2dqou2lul3n50jb4v7e8t34kc-a.example.com:8080", (Object)target);
    }

    @Test
    public void testNotEnabledForGadget() {
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(this.enabledConfig, true);
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("images-a.example.com:8080"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("-a.example.com:8080"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("embed.com"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.notLocked, "default"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.notLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("auvn86n7q0l4ju2tq5cq8akotcjlda66-a.example.com:8080", this.notLocked, "default"));
        HashLockedDomainServiceTest.assertNull((Object)this.lockedDomainService.getLockedDomainForGadget(this.notLocked, "default"));
    }

    @Test
    public void testRequiredForContainer() {
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(this.requiredConfig, true);
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("images-a.example.com:8080"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.isSafeForOpenProxy("-a.example.com:8080"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.isSafeForOpenProxy("embed.com"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.notLocked, "default"));
        String target = this.lockedDomainService.getLockedDomainForGadget(this.wantsLocked, "default");
        HashLockedDomainServiceTest.assertEquals((Object)"8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", (Object)target);
        target = this.lockedDomainService.getLockedDomainForGadget(this.notLocked, "default");
        HashLockedDomainServiceTest.assertEquals((Object)"auvn86n7q0l4ju2tq5cq8akotcjlda66-a.example.com:8080", (Object)target);
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("auvn86n7q0l4ju2tq5cq8akotcjlda66-a.example.com:8080", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("auvn86n7q0l4ju2tq5cq8akotcjlda66-a.example.com:8080", this.notLocked, "default"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.notLocked, "default"));
    }

    @Test
    public void testMissingConfig() throws Exception {
        ContainerConfig containerMissingConfig = (ContainerConfig)this.mock(ContainerConfig.class);
        EasyMock.expect((Object)containerMissingConfig.getContainers()).andReturn(Arrays.asList("default"));
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(containerMissingConfig, true);
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.wantsLocked, "default"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.notLocked, "default"));
    }

    @Test
    public void testMultiContainer() throws Exception {
        ContainerConfig inheritsConfig = (ContainerConfig)this.mock(ContainerConfig.class);
        EasyMock.expect((Object)inheritsConfig.getContainers()).andReturn(Arrays.asList("default", "other"));
        EasyMock.expect((Object)inheritsConfig.getBool((String)EasyMock.isA(String.class), (String)EasyMock.eq((Object)"gadgets.lockedDomainRequired"))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)inheritsConfig.getString((String)EasyMock.isA(String.class), (String)EasyMock.eq((Object)"gadgets.lockedDomainSuffix"))).andReturn((Object)"-a.example.com:8080").anyTimes();
        this.replay();
        this.lockedDomainService = new HashLockedDomainService(inheritsConfig, true);
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.wantsLocked, "other"));
        HashLockedDomainServiceTest.assertFalse((boolean)this.lockedDomainService.gadgetCanRender("www.example.com", this.notLocked, "other"));
        HashLockedDomainServiceTest.assertTrue((boolean)this.lockedDomainService.gadgetCanRender("8uhr00296d2o3sfhqilj387krjmgjv3v-a.example.com:8080", this.wantsLocked, "other"));
    }
}

